/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc;

import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.common.utils.NetUtils;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.rpc.AsyncContext;
import org.apache.dubbo.rpc.AsyncContextImpl;
import org.apache.dubbo.rpc.FutureContext;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.RpcContext;
import org.apache.dubbo.rpc.RpcException;

public class RpcServiceContext
extends RpcContext {
    private List<URL> urls;
    private URL url;
    private String methodName;
    private Class<?>[] parameterTypes;
    private Object[] arguments;
    private InetSocketAddress localAddress;
    private InetSocketAddress remoteAddress;
    private String remoteApplicationName;
    @Deprecated
    private List<Invoker<?>> invokers;
    @Deprecated
    private Invoker<?> invoker;
    @Deprecated
    private Invocation invocation;
    private Object request;
    private Object response;
    private AsyncContext asyncContext;
    private boolean remove = true;
    private URL consumerUrl;

    protected RpcServiceContext() {
    }

    @Override
    public Object getRequest() {
        return this.request;
    }

    @Override
    public void setRequest(Object request) {
        this.request = request;
    }

    @Override
    public <T> T getRequest(Class<T> clazz) {
        return (T)(this.request != null && clazz.isAssignableFrom(this.request.getClass()) ? this.request : null);
    }

    @Override
    public Object getResponse() {
        return this.response;
    }

    @Override
    public void setResponse(Object response) {
        this.response = response;
    }

    @Override
    public <T> T getResponse(Class<T> clazz) {
        return (T)(this.response != null && clazz.isAssignableFrom(this.response.getClass()) ? this.response : null);
    }

    @Override
    public boolean isProviderSide() {
        return !this.isConsumerSide();
    }

    @Override
    public boolean isConsumerSide() {
        return this.getUrl().getSide("provider").equals("consumer");
    }

    @Override
    public <T> CompletableFuture<T> getCompletableFuture() {
        return FutureContext.getContext().getCompletableFuture();
    }

    @Override
    public <T> Future<T> getFuture() {
        return FutureContext.getContext().getCompletableFuture();
    }

    @Override
    public void setFuture(CompletableFuture<?> future) {
        FutureContext.getContext().setFuture(future);
    }

    @Override
    public List<URL> getUrls() {
        return this.urls == null && this.url != null ? Arrays.asList(this.url) : this.urls;
    }

    @Override
    public void setUrls(List<URL> urls) {
        this.urls = urls;
    }

    @Override
    public URL getUrl() {
        return this.url;
    }

    @Override
    public void setUrl(URL url) {
        this.url = url;
    }

    @Override
    public String getMethodName() {
        return this.methodName;
    }

    @Override
    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    @Override
    public Class<?>[] getParameterTypes() {
        return this.parameterTypes;
    }

    @Override
    public void setParameterTypes(Class<?>[] parameterTypes) {
        this.parameterTypes = parameterTypes;
    }

    @Override
    public Object[] getArguments() {
        return this.arguments;
    }

    @Override
    public void setArguments(Object[] arguments) {
        this.arguments = arguments;
    }

    @Override
    public RpcServiceContext setLocalAddress(String host, int port) {
        if (port < 0) {
            port = 0;
        }
        this.localAddress = InetSocketAddress.createUnresolved(host, port);
        return this;
    }

    @Override
    public InetSocketAddress getLocalAddress() {
        return this.localAddress;
    }

    @Override
    public RpcServiceContext setLocalAddress(InetSocketAddress address) {
        this.localAddress = address;
        return this;
    }

    @Override
    public String getLocalAddressString() {
        return this.getLocalHost() + ":" + this.getLocalPort();
    }

    @Override
    public String getLocalHostName() {
        String host;
        String string = host = this.localAddress == null ? null : this.localAddress.getHostName();
        if (StringUtils.isEmpty((String)host)) {
            return this.getLocalHost();
        }
        return host;
    }

    @Override
    public RpcServiceContext setRemoteAddress(String host, int port) {
        if (port < 0) {
            port = 0;
        }
        this.remoteAddress = InetSocketAddress.createUnresolved(host, port);
        return this;
    }

    @Override
    public InetSocketAddress getRemoteAddress() {
        return this.remoteAddress;
    }

    @Override
    public RpcServiceContext setRemoteAddress(InetSocketAddress address) {
        this.remoteAddress = address;
        return this;
    }

    @Override
    public String getRemoteApplicationName() {
        return this.remoteApplicationName;
    }

    @Override
    public RpcServiceContext setRemoteApplicationName(String remoteApplicationName) {
        this.remoteApplicationName = remoteApplicationName;
        return this;
    }

    @Override
    public String getRemoteAddressString() {
        return this.getRemoteHost() + ":" + this.getRemotePort();
    }

    @Override
    public String getRemoteHostName() {
        return this.remoteAddress == null ? null : this.remoteAddress.getHostName();
    }

    @Override
    public String getLocalHost() {
        String host;
        String string = this.localAddress == null ? null : (host = this.localAddress.getAddress() == null ? this.localAddress.getHostName() : NetUtils.filterLocalHost((String)this.localAddress.getAddress().getHostAddress()));
        if (host == null || host.length() == 0) {
            return NetUtils.getLocalHost();
        }
        return host;
    }

    @Override
    public int getLocalPort() {
        return this.localAddress == null ? 0 : this.localAddress.getPort();
    }

    @Override
    public String getRemoteHost() {
        return this.remoteAddress == null ? null : (this.remoteAddress.getAddress() == null ? this.remoteAddress.getHostName() : NetUtils.filterLocalHost((String)this.remoteAddress.getAddress().getHostAddress()));
    }

    @Override
    public int getRemotePort() {
        return this.remoteAddress == null ? 0 : this.remoteAddress.getPort();
    }

    @Override
    @Deprecated
    public boolean isServerSide() {
        return this.isProviderSide();
    }

    @Override
    @Deprecated
    public boolean isClientSide() {
        return this.isConsumerSide();
    }

    @Override
    @Deprecated
    public List<Invoker<?>> getInvokers() {
        return this.invokers == null && this.invoker != null ? Arrays.asList(this.invoker) : this.invokers;
    }

    @Override
    public RpcServiceContext setInvokers(List<Invoker<?>> invokers) {
        this.invokers = invokers;
        if (CollectionUtils.isNotEmpty(invokers)) {
            ArrayList<URL> urls = new ArrayList<URL>(invokers.size());
            for (Invoker<?> invoker : invokers) {
                urls.add(invoker.getUrl());
            }
            this.setUrls(urls);
        }
        return this;
    }

    @Override
    @Deprecated
    public Invoker<?> getInvoker() {
        return this.invoker;
    }

    @Override
    public RpcServiceContext setInvoker(Invoker<?> invoker) {
        this.invoker = invoker;
        if (invoker != null) {
            this.setUrl(invoker.getUrl());
        }
        return this;
    }

    @Override
    @Deprecated
    public Invocation getInvocation() {
        return this.invocation;
    }

    @Override
    public RpcServiceContext setInvocation(Invocation invocation) {
        this.invocation = invocation;
        if (invocation != null) {
            this.setMethodName(invocation.getMethodName());
            this.setParameterTypes(invocation.getParameterTypes());
            this.setArguments(invocation.getArguments());
        }
        return this;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <T> CompletableFuture<T> asyncCall(Callable<T> callable) {
        try {
            try {
                this.setAttachment("async", Boolean.TRUE.toString());
                T o = callable.call();
                if (o == null) return (CompletableFuture)RpcServiceContext.getServiceContext().getFuture();
                if (o instanceof CompletableFuture) {
                    CompletableFuture completableFuture = (CompletableFuture)o;
                    return completableFuture;
                }
                CompletableFuture<T> completableFuture = CompletableFuture.completedFuture(o);
                return completableFuture;
            }
            catch (Exception e) {
                throw new RpcException(e);
            }
            finally {
                this.removeAttachment("async");
            }
        }
        catch (RpcException e) {
            CompletableFuture exceptionFuture = new CompletableFuture();
            exceptionFuture.completeExceptionally(e);
            return exceptionFuture;
        }
    }

    @Override
    public void asyncCall(Runnable runnable) {
        try {
            this.setAttachment("return", Boolean.FALSE.toString());
            runnable.run();
        }
        catch (Throwable e) {
            throw new RpcException("oneway call error ." + e.getMessage(), e);
        }
        finally {
            this.removeAttachment("return");
        }
    }

    public static AsyncContext startAsync() throws IllegalStateException {
        RpcServiceContext currentContext = RpcServiceContext.getServiceContext();
        if (currentContext.asyncContext == null) {
            currentContext.asyncContext = new AsyncContextImpl();
        }
        currentContext.asyncContext.start();
        return currentContext.asyncContext;
    }

    @Override
    protected void setAsyncContext(AsyncContext asyncContext) {
        this.asyncContext = asyncContext;
    }

    @Override
    public boolean isAsyncStarted() {
        if (this.asyncContext == null) {
            return false;
        }
        return this.asyncContext.isAsyncStarted();
    }

    @Override
    public boolean stopAsync() {
        return this.asyncContext.stop();
    }

    @Override
    public AsyncContext getAsyncContext() {
        return this.asyncContext;
    }

    @Override
    public String getGroup() {
        if (this.consumerUrl == null) {
            return null;
        }
        return this.consumerUrl.getGroup();
    }

    @Override
    public String getVersion() {
        if (this.consumerUrl == null) {
            return null;
        }
        return this.consumerUrl.getVersion();
    }

    @Override
    public String getInterfaceName() {
        if (this.consumerUrl == null) {
            return null;
        }
        return this.consumerUrl.getServiceInterface();
    }

    @Override
    public String getProtocol() {
        if (this.consumerUrl == null) {
            return null;
        }
        return this.consumerUrl.getParameter("protocol", "dubbo");
    }

    @Override
    public String getServiceKey() {
        if (this.consumerUrl == null) {
            return null;
        }
        return this.consumerUrl.getServiceKey();
    }

    @Override
    public String getProtocolServiceKey() {
        if (this.consumerUrl == null) {
            return null;
        }
        return this.consumerUrl.getProtocolServiceKey();
    }

    @Override
    public URL getConsumerUrl() {
        return this.consumerUrl;
    }

    @Override
    public void setConsumerUrl(URL consumerUrl) {
        this.consumerUrl = consumerUrl;
    }

    public static void setRpcContext(URL url) {
        RpcServiceContext rpcContext = RpcContext.getServiceContext();
        rpcContext.setConsumerUrl(url);
    }
}

