/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol;

import org.apache.dubbo.common.URL;
import org.apache.dubbo.rpc.Filter;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.ListenableFilter;
import org.apache.dubbo.rpc.Result;
import org.apache.dubbo.rpc.RpcException;

class FilterNode<T>
implements Invoker<T> {
    private final Invoker<T> invoker;
    private final Invoker<T> next;
    private final Filter filter;

    public FilterNode(Invoker<T> invoker, Invoker<T> next, Filter filter) {
        this.invoker = invoker;
        this.next = next;
        this.filter = filter;
    }

    @Override
    public Class<T> getInterface() {
        return this.invoker.getInterface();
    }

    public URL getUrl() {
        return this.invoker.getUrl();
    }

    public boolean isAvailable() {
        return this.invoker.isAvailable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Result invoke(Invocation invocation) throws RpcException {
        try {
            Result asyncResult = this.filter.invoke(this.next, invocation);
            return asyncResult.whenCompleteWithContext((r, t) -> {
                if (this.filter instanceof ListenableFilter) {
                    ListenableFilter listenableFilter = (ListenableFilter)this.filter;
                    Filter.Listener listener = listenableFilter.listener(invocation);
                    try {
                        if (listener == null) return;
                        if (t == null) {
                            listener.onResponse((Result)r, this.invoker, invocation);
                            return;
                        }
                        listener.onError((Throwable)t, this.invoker, invocation);
                        return;
                    }
                    finally {
                        listenableFilter.removeListener(invocation);
                    }
                } else {
                    if (!(this.filter instanceof Filter.Listener)) return;
                    Filter.Listener listener = (Filter.Listener)((Object)this.filter);
                    if (t == null) {
                        listener.onResponse((Result)r, this.invoker, invocation);
                        return;
                    } else {
                        listener.onError((Throwable)t, this.invoker, invocation);
                    }
                }
            });
        }
        catch (Exception e) {
            if (this.filter instanceof ListenableFilter) {
                ListenableFilter listenableFilter = (ListenableFilter)this.filter;
                try {
                    Filter.Listener listener = listenableFilter.listener(invocation);
                    if (listener == null) throw e;
                    listener.onError(e, this.invoker, invocation);
                    throw e;
                }
                finally {
                    listenableFilter.removeListener(invocation);
                }
            } else {
                if (!(this.filter instanceof Filter.Listener)) throw e;
                Filter.Listener listener = (Filter.Listener)((Object)this.filter);
                listener.onError(e, this.invoker, invocation);
            }
            throw e;
        }
    }

    public void destroy() {
        this.invoker.destroy();
    }

    public String toString() {
        return this.invoker.toString();
    }
}

