/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.remoting.http3.netty4;

import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOutboundHandler;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.Headers;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.incubator.codec.http3.DefaultHttp3DataFrame;
import io.netty.incubator.codec.http3.DefaultHttp3Headers;
import io.netty.incubator.codec.http3.DefaultHttp3HeadersFrame;
import io.netty.incubator.codec.http3.Http3DataFrame;
import io.netty.incubator.codec.http3.Http3Headers;
import io.netty.incubator.codec.http3.Http3HeadersFrame;
import io.netty.incubator.codec.http3.Http3RequestStreamInboundHandler;
import io.netty.incubator.codec.quic.QuicStreamChannel;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.SocketAddress;
import org.apache.dubbo.common.io.StreamUtils;
import org.apache.dubbo.remoting.http12.HttpHeaders;
import org.apache.dubbo.remoting.http12.HttpStatus;
import org.apache.dubbo.remoting.http12.h2.Http2Header;
import org.apache.dubbo.remoting.http12.h2.Http2InputMessageFrame;
import org.apache.dubbo.remoting.http12.h2.Http2MetadataFrame;
import org.apache.dubbo.remoting.http12.h2.Http2OutputMessage;
import org.apache.dubbo.remoting.http12.message.DefaultHttpHeaders;
import org.apache.dubbo.remoting.http12.netty4.NettyHttpHeaders;
import org.apache.dubbo.remoting.http3.netty4.Constants;

@ChannelHandler.Sharable
public class NettyHttp3FrameCodec
extends Http3RequestStreamInboundHandler
implements ChannelOutboundHandler {
    public static final NettyHttp3FrameCodec INSTANCE = new NettyHttp3FrameCodec();

    protected void channelRead(ChannelHandlerContext ctx, Http3HeadersFrame frame) {
        Http3Headers headers = frame.headers();
        if (headers.contains((Object)Constants.TRI_PING)) {
            this.pingReceived(ctx);
            return;
        }
        ctx.fireChannelRead((Object)new Http2MetadataFrame(NettyHttp3FrameCodec.getStreamId(ctx), (HttpHeaders)new DefaultHttpHeaders((Headers)headers), false));
    }

    private void pingReceived(ChannelHandlerContext ctx) {
        DefaultHttp3Headers pongHeader = new DefaultHttp3Headers(false);
        pongHeader.set((Object)Constants.TRI_PING, (Object)"0");
        pongHeader.set((Object)Http2Headers.PseudoHeaderName.STATUS.value(), (Object)HttpStatus.OK.getStatusString());
        ctx.write((Object)new DefaultHttp3HeadersFrame((Http3Headers)pongHeader));
        ctx.close();
    }

    protected void channelRead(ChannelHandlerContext ctx, Http3DataFrame frame) {
        ctx.fireChannelRead((Object)new Http2InputMessageFrame(NettyHttp3FrameCodec.getStreamId(ctx), (InputStream)new ByteBufInputStream(frame.content(), true), false));
    }

    private static long getStreamId(ChannelHandlerContext ctx) {
        return ((QuicStreamChannel)ctx.channel()).streamId();
    }

    protected void channelInputClosed(ChannelHandlerContext ctx) {
        ctx.fireChannelRead((Object)new Http2InputMessageFrame(NettyHttp3FrameCodec.getStreamId(ctx), (InputStream)StreamUtils.EMPTY, true));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        if (msg instanceof Http2Header) {
            Http2Header headers = (Http2Header)msg;
            ctx.write((Object)new DefaultHttp3HeadersFrame((Http3Headers)((NettyHttpHeaders)headers.headers()).getHeaders()), promise);
            if (headers.isEndStream()) {
                ctx.close();
            }
        } else {
            if (msg instanceof Http2OutputMessage) {
                Http2OutputMessage message = (Http2OutputMessage)msg;
                try {
                    OutputStream body = message.getBody();
                    if (body == null) {
                        DefaultHttp3DataFrame frame = new DefaultHttp3DataFrame(Unpooled.EMPTY_BUFFER);
                        ctx.write((Object)frame, promise);
                        return;
                    }
                    if (body instanceof ByteBufOutputStream) {
                        DefaultHttp3DataFrame frame = new DefaultHttp3DataFrame(((ByteBufOutputStream)body).buffer());
                        ctx.write((Object)frame, promise);
                        return;
                    }
                }
                finally {
                    if (message.isEndStream()) {
                        ctx.close();
                    }
                }
                throw new IllegalArgumentException("Http2OutputMessage body must be ByteBufOutputStream");
            }
            ctx.write(msg, promise);
        }
    }

    public void bind(ChannelHandlerContext ctx, SocketAddress localAddress, ChannelPromise promise) throws Exception {
        ctx.bind(localAddress, promise);
    }

    public void connect(ChannelHandlerContext ctx, SocketAddress remoteAddress, SocketAddress localAddress, ChannelPromise promise) {
        ctx.connect(remoteAddress, localAddress, promise);
    }

    public void disconnect(ChannelHandlerContext ctx, ChannelPromise promise) {
        ctx.disconnect(promise);
    }

    public void close(ChannelHandlerContext ctx, ChannelPromise promise) throws Exception {
        ctx.close(promise);
    }

    public void deregister(ChannelHandlerContext ctx, ChannelPromise promise) {
        ctx.deregister(promise);
    }

    public void read(ChannelHandlerContext ctx) throws Exception {
        ctx.read();
    }

    public void flush(ChannelHandlerContext ctx) {
        ctx.flush();
    }
}

