/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.remoting.http12.message;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.dubbo.remoting.http12.CompositeInputStream;
import org.apache.dubbo.remoting.http12.exception.DecodeException;
import org.apache.dubbo.remoting.http12.message.StreamingDecoder;

public class LengthFieldStreamingDecoder
implements StreamingDecoder {
    private long pendingDeliveries;
    private boolean inDelivery = false;
    private boolean closing;
    private boolean closed;
    private DecodeState state = DecodeState.HEADER;
    private final CompositeInputStream accumulate = new CompositeInputStream();
    private StreamingDecoder.FragmentListener listener;
    private final int lengthFieldOffset;
    private final int lengthFieldLength;
    private int requiredLength;

    public LengthFieldStreamingDecoder() {
        this(4);
    }

    public LengthFieldStreamingDecoder(int lengthFieldLength) {
        this(0, lengthFieldLength);
    }

    public LengthFieldStreamingDecoder(int lengthFieldOffset, int lengthFieldLength) {
        this.lengthFieldOffset = lengthFieldOffset;
        this.lengthFieldLength = lengthFieldLength;
        this.requiredLength = lengthFieldOffset + lengthFieldLength;
    }

    @Override
    public final void decode(InputStream inputStream) throws DecodeException {
        if (this.closing || this.closed) {
            return;
        }
        this.accumulate.addInputStream(inputStream);
        this.deliver();
    }

    @Override
    public final void request(int numMessages) {
        this.pendingDeliveries += (long)numMessages;
        this.deliver();
    }

    @Override
    public final void close() {
        this.closing = true;
        this.deliver();
    }

    @Override
    public final void onStreamClosed() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        try {
            this.accumulate.close();
        }
        catch (IOException e) {
            throw new DecodeException(e);
        }
    }

    @Override
    public final void setFragmentListener(StreamingDecoder.FragmentListener listener) {
        this.listener = listener;
    }

    private void deliver() {
        if (this.inDelivery) {
            return;
        }
        if (this.closed) {
            return;
        }
        this.inDelivery = true;
        try {
            block9: while (this.pendingDeliveries > 0L && this.hasEnoughBytes()) {
                switch (this.state.ordinal()) {
                    case 0: {
                        this.processHeader();
                        continue block9;
                    }
                    case 1: {
                        this.processBody();
                        --this.pendingDeliveries;
                        continue block9;
                    }
                }
                throw new AssertionError((Object)("Invalid state: " + (Object)((Object)this.state)));
            }
            if (this.closing && !this.closed) {
                this.closed = true;
                this.accumulate.close();
                this.listener.onClose();
            }
        }
        catch (IOException e) {
            throw new DecodeException(e);
        }
        finally {
            this.inDelivery = false;
        }
    }

    private void processHeader() throws IOException {
        byte[] offsetData = new byte[this.lengthFieldOffset];
        int ignore = this.accumulate.read(offsetData);
        this.processOffset(new ByteArrayInputStream(offsetData), this.lengthFieldOffset);
        byte[] lengthBytes = new byte[this.lengthFieldLength];
        ignore = this.accumulate.read(lengthBytes);
        this.requiredLength = LengthFieldStreamingDecoder.bytesToInt(lengthBytes);
        this.state = DecodeState.PAYLOAD;
    }

    protected void processOffset(InputStream inputStream, int lengthFieldOffset) throws IOException {
        this.skipOffset(inputStream, lengthFieldOffset);
    }

    private void skipOffset(InputStream inputStream, int lengthFieldOffset) throws IOException {
        if (lengthFieldOffset != 0) {
            return;
        }
        int ignore = inputStream.read(new byte[lengthFieldOffset]);
    }

    private void processBody() throws IOException {
        byte[] rawMessage = this.readRawMessage(this.accumulate, this.requiredLength);
        ByteArrayInputStream inputStream = new ByteArrayInputStream(rawMessage);
        this.invokeListener(inputStream);
        this.state = DecodeState.HEADER;
        this.requiredLength = this.lengthFieldOffset + this.lengthFieldLength;
    }

    public void invokeListener(InputStream inputStream) {
        this.listener.onFragmentMessage(inputStream);
    }

    protected byte[] readRawMessage(InputStream inputStream, int length) throws IOException {
        byte[] data = new byte[length];
        inputStream.read(data, 0, length);
        return data;
    }

    private boolean hasEnoughBytes() {
        return this.requiredLength - this.accumulate.available() <= 0;
    }

    protected static int bytesToInt(byte[] bytes) {
        return (bytes[0] & 0xFF) << 24 | (bytes[1] & 0xFF) << 16 | (bytes[2] & 0xFF) << 8 | bytes[3] & 0xFF;
    }

    private static enum DecodeState {
        HEADER,
        PAYLOAD;

    }
}

