/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.remoting.http12.exception;

import org.apache.dubbo.remoting.http12.HttpResult;
import org.apache.dubbo.remoting.http12.HttpStatus;
import org.apache.dubbo.remoting.http12.exception.HttpStatusException;

public class HttpResultPayloadException
extends HttpStatusException {
    private static final long serialVersionUID = 1L;
    private final HttpResult<?> result;

    public HttpResultPayloadException(HttpResult<?> result) {
        super(result.getStatus());
        this.result = result;
    }

    public HttpResultPayloadException(int statusCode, Object body) {
        super(statusCode);
        this.result = HttpResult.of(statusCode, body);
    }

    public HttpResultPayloadException(Object body) {
        this(HttpStatus.OK.getCode(), body);
    }

    @Override
    public synchronized Throwable fillInStackTrace() {
        return this;
    }

    public <T> HttpResult<T> getResult() {
        return this.result;
    }

    public <T> T getBody() {
        return (T)this.result.getBody();
    }

    @Override
    public String getMessage() {
        return String.valueOf(this.result);
    }

    @Override
    public String toString() {
        return "HttpResultPayloadException{result=" + this.result + '}';
    }
}

