/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.remoting.http12;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufOutputStream;
import java.io.IOException;
import org.apache.dubbo.remoting.http12.exception.HttpOverPayloadException;

public class LimitedByteBufOutputStream
extends ByteBufOutputStream {
    private final int capacity;

    public LimitedByteBufOutputStream(ByteBuf byteBuf, int capacity) {
        super(byteBuf);
        this.capacity = capacity == 0 ? Integer.MAX_VALUE : capacity;
    }

    public void write(int b) throws IOException {
        this.ensureCapacity(1);
        super.write(b);
    }

    public void write(byte[] b) throws IOException {
        this.ensureCapacity(b.length);
        super.write(b);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.ensureCapacity(len);
        super.write(b, off, len);
    }

    private void ensureCapacity(int len) {
        if (this.writtenBytes() + len > this.capacity) {
            throw new HttpOverPayloadException("Response Entity Too Large");
        }
    }
}

