/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.remoting.http12.netty4;

import io.netty.handler.codec.Headers;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.apache.dubbo.remoting.http12.HttpHeaders;
import org.apache.dubbo.remoting.http12.message.HttpHeadersMapAdapter;
import org.apache.dubbo.remoting.http12.netty4.StringValueIterator;

public class NettyHttpHeaders<T extends Headers<CharSequence, CharSequence, ?>>
implements HttpHeaders {
    private final T headers;

    public NettyHttpHeaders(T headers) {
        this.headers = headers;
    }

    @Override
    public final int size() {
        return this.headers.size();
    }

    @Override
    public final boolean isEmpty() {
        return this.headers.isEmpty();
    }

    @Override
    public final boolean containsKey(CharSequence key) {
        return this.headers.contains((Object)key);
    }

    @Override
    public final String getFirst(CharSequence name) {
        CharSequence value = (CharSequence)this.headers.get((Object)name);
        return value == null ? null : value.toString();
    }

    @Override
    public final List<String> get(CharSequence key) {
        List all = this.headers.getAll((Object)key);
        if (all.isEmpty()) {
            return Collections.emptyList();
        }
        ListIterator<String> it = all.listIterator();
        while (it.hasNext()) {
            CharSequence next = (CharSequence)it.next();
            if (next == null || next.getClass() == String.class) continue;
            it.set(next.toString());
        }
        return all;
    }

    @Override
    public final HttpHeaders add(CharSequence name, String value) {
        this.headers.add((Object)name, (Object)value);
        return this;
    }

    @Override
    public final HttpHeaders add(CharSequence name, Iterable<String> values) {
        this.headers.add((Object)name, values);
        return this;
    }

    @Override
    public final HttpHeaders add(CharSequence name, String ... values) {
        if (values != null && values.length != 0) {
            this.headers.add((Object)name, Arrays.asList(values));
        }
        return this;
    }

    @Override
    public final HttpHeaders add(Map<? extends CharSequence, ? extends Iterable<String>> map) {
        for (Map.Entry<? extends CharSequence, ? extends Iterable<String>> entry : map.entrySet()) {
            this.headers.add((Object)entry.getKey(), entry.getValue());
        }
        return this;
    }

    @Override
    public final HttpHeaders add(HttpHeaders headers) {
        for (Map.Entry<CharSequence, String> entry : headers) {
            this.headers.add((Object)entry.getKey(), (Object)entry.getValue());
        }
        return this;
    }

    @Override
    public final HttpHeaders set(CharSequence name, String value) {
        this.headers.set((Object)name, (Object)value);
        return this;
    }

    @Override
    public final HttpHeaders set(CharSequence name, Iterable<String> values) {
        this.headers.set((Object)name, values);
        return this;
    }

    @Override
    public final HttpHeaders set(CharSequence name, String ... values) {
        if (values != null && values.length != 0) {
            this.headers.set((Object)name, Arrays.asList(values));
        }
        return this;
    }

    @Override
    public final HttpHeaders set(Map<? extends CharSequence, ? extends Iterable<String>> map) {
        for (Map.Entry<? extends CharSequence, ? extends Iterable<String>> entry : map.entrySet()) {
            this.headers.set((Object)entry.getKey(), entry.getValue());
        }
        return this;
    }

    @Override
    public final HttpHeaders set(HttpHeaders headers) {
        for (Map.Entry<CharSequence, String> entry : headers) {
            this.headers.set((Object)entry.getKey(), (Object)entry.getValue());
        }
        return this;
    }

    @Override
    public final List<String> remove(CharSequence key) {
        return this.headers.getAllAndRemove((Object)key);
    }

    @Override
    public final void clear() {
        this.headers.clear();
    }

    @Override
    public final Set<String> names() {
        final Set names = this.headers.names();
        return new AbstractSet<String>(){

            @Override
            public Iterator<String> iterator() {
                final Iterator it = names.iterator();
                return new Iterator<String>(){

                    @Override
                    public boolean hasNext() {
                        return it.hasNext();
                    }

                    @Override
                    public String next() {
                        CharSequence next = (CharSequence)it.next();
                        return next == null ? null : next.toString();
                    }

                    @Override
                    public void remove() {
                        it.remove();
                    }
                };
            }

            @Override
            public int size() {
                return names.size();
            }

            @Override
            public boolean contains(Object o) {
                return names.contains(o);
            }
        };
    }

    @Override
    public Set<CharSequence> nameSet() {
        return this.headers.names();
    }

    @Override
    public final Map<String, List<String>> asMap() {
        return this.headers.isEmpty() ? Collections.emptyMap() : new HttpHeadersMapAdapter(this);
    }

    @Override
    public final Iterator<Map.Entry<CharSequence, String>> iterator() {
        return new StringValueIterator(this.headers.iterator());
    }

    public final T getHeaders() {
        return this.headers;
    }

    public boolean equals(Object obj) {
        return obj instanceof NettyHttpHeaders && this.headers.equals(((NettyHttpHeaders)obj).headers);
    }

    public int hashCode() {
        return this.headers.hashCode();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{headers=" + this.headers + '}';
    }
}

