/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.remoting.http12.message.codec;

import com.google.protobuf.Message;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.util.JsonFormat;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import org.apache.dubbo.common.io.StreamUtils;
import org.apache.dubbo.common.utils.MethodUtils;
import org.apache.dubbo.remoting.http12.exception.DecodeException;
import org.apache.dubbo.remoting.http12.exception.EncodeException;
import org.apache.dubbo.remoting.http12.exception.HttpStatusException;
import org.apache.dubbo.remoting.http12.message.codec.JsonCodec;
import org.apache.dubbo.rpc.model.FrameworkModel;

public final class JsonPbCodec
extends JsonCodec {
    public static final JsonPbCodec INSTANCE = new JsonPbCodec();

    private JsonPbCodec() {
    }

    public JsonPbCodec(FrameworkModel frameworkModel) {
        super(frameworkModel);
    }

    @Override
    public void encode(OutputStream os, Object data, Charset charset) throws EncodeException {
        try {
            if (data instanceof Message) {
                String jsonString = JsonFormat.printer().print((MessageOrBuilder)((Message)data));
                os.write(jsonString.getBytes(charset));
                return;
            }
        }
        catch (IOException e) {
            throw new EncodeException("Error encoding jsonPb", (Throwable)e);
        }
        super.encode(os, data, charset);
    }

    @Override
    public Object decode(InputStream is, Class<?> targetType, Charset charset) throws DecodeException {
        try {
            if (JsonPbCodec.isProtobuf(targetType)) {
                Message.Builder newBuilder = (Message.Builder)MethodUtils.findMethod(targetType, (String)"newBuilder").invoke(null, new Object[0]);
                JsonFormat.parser().ignoringUnknownFields().merge(StreamUtils.toString((InputStream)is, (Charset)charset), newBuilder);
                return newBuilder.build();
            }
        }
        catch (HttpStatusException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new DecodeException("Error decoding jsonPb", e);
        }
        return super.decode(is, targetType, charset);
    }

    @Override
    public Object decode(InputStream is, Type targetType, Charset charset) throws DecodeException {
        return targetType instanceof Class ? this.decode(is, (Class)targetType, charset) : super.decode(is, targetType, charset);
    }

    @Override
    public Object[] decode(InputStream is, Class<?>[] targetTypes, Charset charset) throws DecodeException {
        try {
            if (JsonPbCodec.hasProtobuf(targetTypes)) {
                return new Object[]{this.decode(is, targetTypes[0], charset)};
            }
        }
        catch (HttpStatusException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new DecodeException("Error decoding jsonPb", e);
        }
        return super.decode(is, targetTypes, charset);
    }

    private static boolean isProtobuf(Class<?> targetType) {
        if (targetType == null) {
            return false;
        }
        return Message.class.isAssignableFrom(targetType);
    }

    private static boolean hasProtobuf(Class<?>[] classes) {
        for (Class<?> clazz : classes) {
            if (!JsonPbCodec.isProtobuf(clazz)) continue;
            return true;
        }
        return false;
    }
}

