/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.remoting.http12.message.codec;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.utils.Assert;
import org.apache.dubbo.remoting.http12.exception.UnsupportedMediaTypeException;
import org.apache.dubbo.remoting.http12.message.HttpMessageDecoder;
import org.apache.dubbo.remoting.http12.message.HttpMessageDecoderFactory;
import org.apache.dubbo.remoting.http12.message.HttpMessageEncoder;
import org.apache.dubbo.remoting.http12.message.HttpMessageEncoderFactory;
import org.apache.dubbo.rpc.model.FrameworkModel;

public final class CodecUtils {
    private final FrameworkModel frameworkModel;
    private final List<HttpMessageDecoderFactory> decoderFactories;
    private final List<HttpMessageEncoderFactory> encoderFactories;
    private final Map<String, Optional<HttpMessageEncoderFactory>> encoderCache = new ConcurrentHashMap<String, Optional<HttpMessageEncoderFactory>>();
    private final Map<String, Optional<HttpMessageDecoderFactory>> decoderCache = new ConcurrentHashMap<String, Optional<HttpMessageDecoderFactory>>();

    public CodecUtils(FrameworkModel frameworkModel) {
        this.frameworkModel = frameworkModel;
        this.decoderFactories = frameworkModel.getActivateExtensions(HttpMessageDecoderFactory.class);
        this.encoderFactories = frameworkModel.getActivateExtensions(HttpMessageEncoderFactory.class);
        this.decoderFactories.forEach(f -> this.decoderCache.putIfAbsent(f.mediaType().getName(), Optional.of(f)));
        this.encoderFactories.forEach(f -> this.encoderCache.putIfAbsent(f.mediaType().getName(), Optional.of(f)));
    }

    public HttpMessageDecoder determineHttpMessageDecoder(URL url, String mediaType) {
        return this.determineHttpMessageDecoderFactory(mediaType).orElseThrow(() -> new UnsupportedMediaTypeException(mediaType)).createCodec(url, this.frameworkModel, mediaType);
    }

    public HttpMessageDecoder determineHttpMessageDecoder(String mediaType) {
        return this.determineHttpMessageDecoder(null, mediaType);
    }

    public HttpMessageEncoder determineHttpMessageEncoder(URL url, String mediaType) {
        return this.determineHttpMessageEncoderFactory(mediaType).orElseThrow(() -> new UnsupportedMediaTypeException(mediaType)).createCodec(url, this.frameworkModel, mediaType);
    }

    public HttpMessageEncoder determineHttpMessageEncoder(String mediaType) {
        return this.determineHttpMessageEncoder(null, mediaType);
    }

    public Optional<HttpMessageDecoderFactory> determineHttpMessageDecoderFactory(String mediaType) {
        Assert.notNull((Object)mediaType, (String)"mediaType must not be null");
        return this.decoderCache.computeIfAbsent(mediaType, k -> {
            for (HttpMessageDecoderFactory decoderFactory : this.decoderFactories) {
                if (!decoderFactory.supports((String)k)) continue;
                return Optional.of(decoderFactory);
            }
            return Optional.empty();
        });
    }

    public Optional<HttpMessageEncoderFactory> determineHttpMessageEncoderFactory(String mediaType) {
        Assert.notNull((Object)mediaType, (String)"mediaType must not be null");
        return this.encoderCache.computeIfAbsent(mediaType, k -> {
            for (HttpMessageEncoderFactory encoderFactory : this.encoderFactories) {
                if (!encoderFactory.supports((String)k)) continue;
                return Optional.of(encoderFactory);
            }
            return Optional.empty();
        });
    }

    public List<HttpMessageDecoderFactory> getDecoderFactories() {
        return this.decoderFactories;
    }

    public List<HttpMessageEncoderFactory> getEncoderFactories() {
        return this.encoderFactories;
    }
}

