/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.remoting.http12.h1;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.apache.dubbo.remoting.http12.HttpChannel;
import org.apache.dubbo.remoting.http12.HttpHeaderNames;
import org.apache.dubbo.remoting.http12.HttpHeaders;
import org.apache.dubbo.remoting.http12.HttpMetadata;
import org.apache.dubbo.remoting.http12.HttpOutputMessage;
import org.apache.dubbo.remoting.http12.h1.Http1Metadata;
import org.apache.dubbo.remoting.http12.h1.Http1ServerChannelObserver;

public class Http1ServerStreamChannelObserver
extends Http1ServerChannelObserver {
    private static final byte[] SERVER_SENT_EVENT_DATA_PREFIX_BYTES = "data:".getBytes(StandardCharsets.US_ASCII);
    private static final byte[] SERVER_SENT_EVENT_LF_BYTES = "\n\n".getBytes(StandardCharsets.US_ASCII);

    public Http1ServerStreamChannelObserver(HttpChannel httpChannel) {
        super(httpChannel);
    }

    @Override
    protected HttpMetadata encodeHttpMetadata(boolean endStream) {
        HttpHeaders headers = HttpHeaders.create();
        headers.set(HttpHeaderNames.TRANSFER_ENCODING.getKey(), "chunked");
        return new Http1Metadata(headers);
    }

    @Override
    protected void preOutputMessage(HttpOutputMessage message) throws IOException {
        HttpOutputMessage prefixMessage = this.getHttpChannel().newOutputMessage();
        prefixMessage.getBody().write(SERVER_SENT_EVENT_DATA_PREFIX_BYTES);
        this.getHttpChannel().writeMessage(prefixMessage);
    }

    @Override
    protected void postOutputMessage(HttpOutputMessage message) throws IOException {
        HttpOutputMessage lfMessage = this.getHttpChannel().newOutputMessage();
        lfMessage.getBody().write(SERVER_SENT_EVENT_LF_BYTES);
        this.getHttpChannel().writeMessage(lfMessage);
    }
}

