/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.registry.zookeeper;

import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.extension.DisableInject;
import org.apache.dubbo.registry.Registry;
import org.apache.dubbo.registry.support.AbstractRegistryFactory;
import org.apache.dubbo.registry.zookeeper.ZookeeperRegistry;
import org.apache.dubbo.remoting.zookeeper.curator5.ZookeeperClientManager;
import org.apache.dubbo.rpc.model.ApplicationModel;

public class ZookeeperRegistryFactory
extends AbstractRegistryFactory {
    private ZookeeperClientManager zookeeperClientManager;

    public ZookeeperRegistryFactory() {
        this(ApplicationModel.defaultModel());
    }

    public ZookeeperRegistryFactory(ApplicationModel applicationModel) {
        this.applicationModel = applicationModel;
        this.zookeeperClientManager = ZookeeperClientManager.getInstance((ApplicationModel)applicationModel);
    }

    @DisableInject
    public void setZookeeperTransporter(ZookeeperClientManager zookeeperClientManager) {
        this.zookeeperClientManager = zookeeperClientManager;
    }

    public Registry createRegistry(URL url) {
        return new ZookeeperRegistry(url, this.zookeeperClientManager);
    }
}

