/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.registry.nacos.util;

import com.alibaba.nacos.api.NacosFactory;
import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.naming.NamingService;
import com.alibaba.nacos.api.naming.pojo.Instance;
import java.util.Properties;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.registry.client.DefaultServiceInstance;
import org.apache.dubbo.registry.client.ServiceInstance;

public class NacosNamingServiceUtils {
    private static final Logger logger = LoggerFactory.getLogger(NacosNamingServiceUtils.class);

    public static Instance toInstance(ServiceInstance serviceInstance) {
        Instance instance = new Instance();
        instance.setInstanceId(serviceInstance.getId());
        instance.setServiceName(serviceInstance.getServiceName());
        instance.setIp(serviceInstance.getHost());
        instance.setPort(serviceInstance.getPort().intValue());
        instance.setMetadata(serviceInstance.getMetadata());
        instance.setEnabled(serviceInstance.isEnabled());
        instance.setHealthy(serviceInstance.isHealthy());
        return instance;
    }

    public static ServiceInstance toServiceInstance(Instance instance) {
        DefaultServiceInstance serviceInstance = new DefaultServiceInstance(instance.getInstanceId(), instance.getServiceName(), instance.getIp(), Integer.valueOf(instance.getPort()));
        serviceInstance.setMetadata(instance.getMetadata());
        serviceInstance.setEnabled(instance.isEnabled());
        serviceInstance.setHealthy(instance.isHealthy());
        return serviceInstance;
    }

    public static String getGroup(URL connectionURL) {
        return connectionURL.getParameter("nacos.group", "DEFAULT_GROUP");
    }

    public static NamingService createNamingService(URL connectionURL) {
        NamingService namingService;
        Properties nacosProperties = NacosNamingServiceUtils.buildNacosProperties(connectionURL);
        try {
            namingService = NacosFactory.createNamingService((Properties)nacosProperties);
        }
        catch (NacosException e) {
            if (logger.isErrorEnabled()) {
                logger.error(e.getErrMsg(), (Throwable)e);
            }
            throw new IllegalStateException(e);
        }
        return namingService;
    }

    private static Properties buildNacosProperties(URL url) {
        Properties properties = new Properties();
        NacosNamingServiceUtils.setServerAddr(url, properties);
        NacosNamingServiceUtils.setProperties(url, properties);
        return properties;
    }

    private static void setServerAddr(URL url, Properties properties) {
        StringBuilder serverAddrBuilder = new StringBuilder(url.getHost()).append(":").append(url.getPort());
        String backup = url.getParameter("backup");
        if (backup != null) {
            serverAddrBuilder.append(",").append(backup);
        }
        String serverAddr = serverAddrBuilder.toString();
        properties.put("serverAddr", serverAddr);
    }

    private static void setProperties(URL url, Properties properties) {
        NacosNamingServiceUtils.putPropertyIfAbsent(url, properties, "com.alibaba.nacos.naming.log.filename");
        NacosNamingServiceUtils.putPropertyIfAbsent(url, properties, "isUseCloudNamespaceParsing");
        NacosNamingServiceUtils.putPropertyIfAbsent(url, properties, "isUseEndpointParsingRule");
        NacosNamingServiceUtils.putPropertyIfAbsent(url, properties, "endpoint");
        NacosNamingServiceUtils.putPropertyIfAbsent(url, properties, "endpointPort");
        NacosNamingServiceUtils.putPropertyIfAbsent(url, properties, "namespace");
        NacosNamingServiceUtils.putPropertyIfAbsent(url, properties, "accessKey");
        NacosNamingServiceUtils.putPropertyIfAbsent(url, properties, "secretKey");
        NacosNamingServiceUtils.putPropertyIfAbsent(url, properties, "ramRoleName");
        NacosNamingServiceUtils.putPropertyIfAbsent(url, properties, "contextPath");
        NacosNamingServiceUtils.putPropertyIfAbsent(url, properties, "clusterName");
        NacosNamingServiceUtils.putPropertyIfAbsent(url, properties, "encode");
        NacosNamingServiceUtils.putPropertyIfAbsent(url, properties, "configLongPollTimeout");
        NacosNamingServiceUtils.putPropertyIfAbsent(url, properties, "configRetryTime");
        NacosNamingServiceUtils.putPropertyIfAbsent(url, properties, "maxRetry");
        NacosNamingServiceUtils.putPropertyIfAbsent(url, properties, "enableRemoteSyncConfig");
        NacosNamingServiceUtils.putPropertyIfAbsent(url, properties, "namingLoadCacheAtStart", "true");
        NacosNamingServiceUtils.putPropertyIfAbsent(url, properties, "namingClientBeatThreadCount");
        NacosNamingServiceUtils.putPropertyIfAbsent(url, properties, "namingPollingThreadCount");
    }

    private static void putPropertyIfAbsent(URL url, Properties properties, String propertyName) {
        String propertyValue = url.getParameter(propertyName);
        if (StringUtils.isNotEmpty((String)propertyValue)) {
            properties.setProperty(propertyName, propertyValue);
        }
    }

    private static void putPropertyIfAbsent(URL url, Properties properties, String propertyName, String defaultValue) {
        String propertyValue = url.getParameter(propertyName);
        if (StringUtils.isNotEmpty((String)propertyValue)) {
            properties.setProperty(propertyName, propertyValue);
        } else {
            properties.setProperty(propertyName, defaultValue);
        }
    }
}

