/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.registry.nacos.util;

import com.alibaba.nacos.api.naming.pojo.Instance;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.dubbo.common.utils.CollectionUtils;

public class NacosInstanceManageUtil {
    private static final Map<String, List<Instance>> SERVICE_INSTANCE_LIST_MAP = Maps.newConcurrentMap();
    private static final Map<String, Set<String>> CORRESPONDING_SERVICE_NAMES_MAP = Maps.newConcurrentMap();

    public static void setCorrespondingServiceNames(String serviceName, Set<String> serviceNames) {
        CORRESPONDING_SERVICE_NAMES_MAP.put(serviceName, serviceNames);
    }

    public static void initOrRefreshServiceInstanceList(String serviceName, List<Instance> instanceList) {
        SERVICE_INSTANCE_LIST_MAP.put(serviceName, instanceList);
    }

    public static List<Instance> getAllCorrespondingServiceInstanceList(String serviceName) {
        if (!CORRESPONDING_SERVICE_NAMES_MAP.containsKey(serviceName)) {
            return Lists.newArrayList();
        }
        ArrayList allInstances = Lists.newArrayList();
        for (String correspondingServiceName : CORRESPONDING_SERVICE_NAMES_MAP.get(serviceName)) {
            if (!SERVICE_INSTANCE_LIST_MAP.containsKey(correspondingServiceName) || !CollectionUtils.isNotEmpty((Collection)SERVICE_INSTANCE_LIST_MAP.get(correspondingServiceName))) continue;
            allInstances.addAll((Collection)SERVICE_INSTANCE_LIST_MAP.get(correspondingServiceName));
        }
        return allInstances;
    }
}

