/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.registry.nacos.util;

import com.alibaba.nacos.api.NacosFactory;
import com.alibaba.nacos.api.PropertyKeyConst;
import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.naming.NamingService;
import com.alibaba.nacos.api.naming.pojo.Instance;
import com.alibaba.nacos.api.naming.utils.NamingUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.StringConstantFieldValuePredicate;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.registry.client.DefaultServiceInstance;
import org.apache.dubbo.registry.client.ServiceInstance;
import org.apache.dubbo.registry.nacos.NacosNamingServiceWrapper;

public class NacosNamingServiceUtils {
    private static final Logger logger = LoggerFactory.getLogger(NacosNamingServiceUtils.class);

    public static Instance toInstance(ServiceInstance serviceInstance) {
        Instance instance = new Instance();
        instance.setInstanceId(serviceInstance.getId());
        instance.setServiceName(serviceInstance.getServiceName());
        instance.setIp(serviceInstance.getHost());
        instance.setPort(serviceInstance.getPort().intValue());
        instance.setMetadata(serviceInstance.getMetadata());
        instance.setEnabled(serviceInstance.isEnabled());
        instance.setHealthy(serviceInstance.isHealthy());
        return instance;
    }

    public static ServiceInstance toServiceInstance(Instance instance) {
        DefaultServiceInstance serviceInstance = new DefaultServiceInstance(instance.getInstanceId(), NamingUtils.getServiceName((String)instance.getServiceName()), instance.getIp(), Integer.valueOf(instance.getPort()));
        serviceInstance.setMetadata(instance.getMetadata());
        serviceInstance.setEnabled(instance.isEnabled());
        serviceInstance.setHealthy(instance.isHealthy());
        return serviceInstance;
    }

    public static String getGroup(URL connectionURL) {
        return connectionURL.getParameter("nacos.group", "DEFAULT_GROUP");
    }

    public static NacosNamingServiceWrapper createNamingService(URL connectionURL) {
        NamingService namingService;
        Properties nacosProperties = NacosNamingServiceUtils.buildNacosProperties(connectionURL);
        try {
            namingService = NacosFactory.createNamingService((Properties)nacosProperties);
        }
        catch (NacosException e) {
            if (logger.isErrorEnabled()) {
                logger.error(e.getErrMsg(), (Throwable)e);
            }
            throw new IllegalStateException(e);
        }
        return new NacosNamingServiceWrapper(namingService);
    }

    private static Properties buildNacosProperties(URL url) {
        Properties properties = new Properties();
        NacosNamingServiceUtils.setServerAddr(url, properties);
        NacosNamingServiceUtils.setProperties(url, properties);
        return properties;
    }

    private static void setServerAddr(URL url, Properties properties) {
        StringBuilder serverAddrBuilder = new StringBuilder(url.getHost()).append(":").append(url.getPort());
        String backup = url.getParameter("backup");
        if (backup != null) {
            serverAddrBuilder.append(",").append(backup);
        }
        String serverAddr = serverAddrBuilder.toString();
        properties.put("serverAddr", serverAddr);
    }

    private static void setProperties(URL url, Properties properties) {
        Map parameters = url.getParameters(StringConstantFieldValuePredicate.of(PropertyKeyConst.class));
        properties.putAll((Map<?, ?>)parameters);
        NacosNamingServiceUtils.putPropertyIfAbsent(url, properties, "namingLoadCacheAtStart", "true");
    }

    private static void putPropertyIfAbsent(URL url, Properties properties, String propertyName) {
        String propertyValue = url.getParameter(propertyName);
        if (StringUtils.isNotEmpty((String)propertyValue)) {
            properties.setProperty(propertyName, propertyValue);
        }
    }

    private static void putPropertyIfAbsent(URL url, Properties properties, String propertyName, String defaultValue) {
        String propertyValue = url.getParameter(propertyName);
        if (StringUtils.isNotEmpty((String)propertyValue)) {
            properties.setProperty(propertyName, propertyValue);
        } else {
            properties.setProperty(propertyName, defaultValue);
        }
    }

    public static Map<String, String> getNacosPreservedParam(URL registryUrl) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (registryUrl.getParameter("preserved.register.source") != null) {
            map.put("preserved.register.source", registryUrl.getParameter("preserved.register.source"));
        }
        if (registryUrl.getParameter("preserved.heart.beat.timeout") != null) {
            map.put("preserved.heart.beat.timeout", registryUrl.getParameter("preserved.heart.beat.timeout"));
        }
        if (registryUrl.getParameter("preserved.ip.delete.timeout") != null) {
            map.put("preserved.ip.delete.timeout", registryUrl.getParameter("preserved.ip.delete.timeout"));
        }
        if (registryUrl.getParameter("preserved.heart.beat.interval") != null) {
            map.put("preserved.heart.beat.interval", registryUrl.getParameter("preserved.heart.beat.interval"));
        }
        if (registryUrl.getParameter("preserved.instance.id.generator") != null) {
            map.put("preserved.instance.id.generator", registryUrl.getParameter("preserved.instance.id.generator"));
        }
        return map;
    }
}

