/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.registry.client.metadata;

import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.metadata.DubboMetadataServiceV2Triple;
import org.apache.dubbo.metadata.MetadataInfo;
import org.apache.dubbo.metadata.MetadataInfoV2;
import org.apache.dubbo.metadata.MetadataRequest;
import org.apache.dubbo.metadata.OpenAPIFormat;
import org.apache.dubbo.metadata.OpenAPIInfo;
import org.apache.dubbo.metadata.util.MetadataServiceVersionUtils;
import org.apache.dubbo.registry.client.ServiceDiscovery;
import org.apache.dubbo.registry.support.RegistryManager;
import org.apache.dubbo.remoting.http12.HttpStatus;
import org.apache.dubbo.remoting.http12.exception.HttpStatusException;
import org.apache.dubbo.remoting.http12.rest.OpenAPIRequest;
import org.apache.dubbo.remoting.http12.rest.OpenAPIService;
import org.apache.dubbo.rpc.model.ApplicationModel;
import org.apache.dubbo.rpc.model.FrameworkModel;
import org.apache.dubbo.rpc.protocol.tri.TripleProtocol;

public class MetadataServiceDelegationV2
extends DubboMetadataServiceV2Triple.MetadataServiceV2ImplBase {
    ErrorTypeAwareLogger logger = LoggerFactory.getErrorTypeAwareLogger(((Object)((Object)this)).getClass());
    private final FrameworkModel frameworkModel;
    private final RegistryManager registryManager;
    private URL metadataUrl;
    public static final String VERSION = "2.0.0";

    public MetadataServiceDelegationV2(ApplicationModel applicationModel) {
        this.frameworkModel = applicationModel.getFrameworkModel();
        this.registryManager = RegistryManager.getInstance(applicationModel);
    }

    public MetadataInfoV2 getMetadataInfo(MetadataRequest metadataRequestV2) {
        String revision = metadataRequestV2.getRevision();
        if (StringUtils.isEmpty((String)revision)) {
            return null;
        }
        for (ServiceDiscovery sd : this.registryManager.getServiceDiscoveries()) {
            MetadataInfo info = sd.getLocalMetadata(revision);
            if (info == null || !revision.equals(info.getRevision())) continue;
            return MetadataServiceVersionUtils.toV2((MetadataInfo)info);
        }
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("1-39", "", "", "metadataV2 not found for revision: " + metadataRequestV2);
        }
        return null;
    }

    public OpenAPIInfo getOpenAPIInfo(org.apache.dubbo.metadata.OpenAPIRequest request) {
        OpenAPIService openAPIService;
        if (TripleProtocol.OPENAPI_ENABLED && (openAPIService = (OpenAPIService)this.frameworkModel.getBean(OpenAPIService.class)) != null) {
            OpenAPIRequest oRequest = new OpenAPIRequest();
            oRequest.setGroup(request.getGroup());
            oRequest.setVersion(request.getVersion());
            oRequest.setTag((String[])request.getTagList().toArray((Object[])StringUtils.EMPTY_STRING_ARRAY));
            oRequest.setService((String[])request.getServiceList().toArray((Object[])StringUtils.EMPTY_STRING_ARRAY));
            oRequest.setOpenapi(request.getOpenapi());
            OpenAPIFormat format = request.getFormat();
            if (request.hasFormat()) {
                oRequest.setFormat(format.name());
            }
            if (request.hasPretty()) {
                oRequest.setPretty(Boolean.valueOf(request.getPretty()));
            }
            String document = openAPIService.getDocument(oRequest);
            return OpenAPIInfo.newBuilder().setDefinition(document).build();
        }
        throw new HttpStatusException(HttpStatus.NOT_FOUND.getCode(), "OpenAPI is not available");
    }

    public URL getMetadataUrl() {
        return this.metadataUrl;
    }

    public void setMetadataUrl(URL metadataUrl) {
        this.metadataUrl = metadataUrl;
    }
}

