/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.registry.integration;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.dubbo.common.config.configcenter.ConfigChangeType;
import org.apache.dubbo.common.config.configcenter.ConfigChangedEvent;
import org.apache.dubbo.common.config.configcenter.ConfigurationListener;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.rpc.cluster.Configurator;
import org.apache.dubbo.rpc.cluster.configurator.parser.ConfigParser;
import org.apache.dubbo.rpc.cluster.governance.GovernanceRuleRepository;
import org.apache.dubbo.rpc.model.ModuleModel;
import org.apache.dubbo.rpc.model.ScopeModel;

public abstract class AbstractConfiguratorListener
implements ConfigurationListener {
    private static final Logger logger = LoggerFactory.getLogger(AbstractConfiguratorListener.class);
    protected List<Configurator> configurators = Collections.emptyList();
    protected GovernanceRuleRepository ruleRepository;
    protected Set<String> securityKey = new HashSet<String>();
    protected ModuleModel moduleModel;

    public AbstractConfiguratorListener(ModuleModel moduleModel) {
        this.moduleModel = moduleModel;
        this.ruleRepository = (GovernanceRuleRepository)moduleModel.getExtensionLoader(GovernanceRuleRepository.class).getDefaultExtension();
        this.initSecurityKey();
    }

    private void initSecurityKey() {
        this.securityKey.add("accesslog");
        this.securityKey.add("router");
        this.securityKey.add("rule");
        this.securityKey.add("runtime");
        this.securityKey.add("type");
    }

    protected final void initWith(String key) {
        this.ruleRepository.addListener(key, (ConfigurationListener)this);
        String rawConfig = this.ruleRepository.getRule(key, "dubbo");
        if (!StringUtils.isEmpty((String)rawConfig)) {
            this.genConfiguratorsFromRawRule(rawConfig);
        }
    }

    protected final void stopListen(String key) {
        this.ruleRepository.removeListener(key, (ConfigurationListener)this);
    }

    public void process(ConfigChangedEvent event) {
        if (logger.isInfoEnabled()) {
            logger.info("Notification of overriding rule, change type is: " + event.getChangeType() + ", raw config content is:\n " + event.getContent());
        }
        if (event.getChangeType().equals((Object)ConfigChangeType.ADDED)) {
            return;
        }
        if (event.getChangeType().equals((Object)ConfigChangeType.DELETED)) {
            this.configurators.clear();
        } else if (!this.genConfiguratorsFromRawRule(event.getContent())) {
            return;
        }
        this.notifyOverrides();
    }

    private boolean genConfiguratorsFromRawRule(String rawConfig) {
        boolean parseSuccess = true;
        try {
            List urls = ConfigParser.parseConfigurators((String)rawConfig);
            List safeUrls = urls.stream().map(url -> url.removeParameters(this.securityKey)).map(url -> url.setScopeModel((ScopeModel)this.moduleModel)).collect(Collectors.toList());
            this.configurators = Configurator.toConfigurators(safeUrls).orElse(this.configurators);
        }
        catch (Exception e) {
            logger.error("Failed to parse raw dynamic config and it will not take effect, the raw config is: " + rawConfig, (Throwable)e);
            parseSuccess = false;
        }
        return parseSuccess;
    }

    protected abstract void notifyOverrides();

    public List<Configurator> getConfigurators() {
        return this.configurators;
    }

    public void setConfigurators(List<Configurator> configurators) {
        this.configurators = configurators;
    }
}

