/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.registry.client.migration;

import java.util.concurrent.CountDownLatch;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.registry.Registry;
import org.apache.dubbo.registry.client.migration.MigrationInvoker;
import org.apache.dubbo.registry.client.migration.model.MigrationRule;
import org.apache.dubbo.registry.integration.RegistryProtocol;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Result;
import org.apache.dubbo.rpc.RpcException;
import org.apache.dubbo.rpc.cluster.Cluster;
import org.apache.dubbo.rpc.cluster.ClusterInvoker;

public class ServiceDiscoveryMigrationInvoker<T>
extends MigrationInvoker<T> {
    private static final Logger logger = LoggerFactory.getLogger(ServiceDiscoveryMigrationInvoker.class);

    public ServiceDiscoveryMigrationInvoker(RegistryProtocol registryProtocol, Cluster cluster, Registry registry, Class<T> type, URL url, URL consumerUrl) {
        super(registryProtocol, cluster, registry, type, url, consumerUrl);
    }

    @Override
    public boolean isServiceDiscovery() {
        return true;
    }

    @Override
    public boolean migrateToForceInterfaceInvoker(MigrationRule newRule) {
        CountDownLatch latch = new CountDownLatch(0);
        this.refreshServiceDiscoveryInvoker(latch);
        this.setCurrentAvailableInvoker(this.getServiceDiscoveryInvoker());
        return true;
    }

    @Override
    public void migrateToApplicationFirstInvoker(MigrationRule newRule) {
        CountDownLatch latch = new CountDownLatch(0);
        this.refreshServiceDiscoveryInvoker(latch);
        this.setCurrentAvailableInvoker(this.getServiceDiscoveryInvoker());
    }

    @Override
    public Result invoke(Invocation invocation) throws RpcException {
        ClusterInvoker invoker = this.getServiceDiscoveryInvoker();
        if (invoker == null) {
            throw new IllegalStateException("There's no service discovery invoker available for service " + invocation.getServiceName());
        }
        return invoker.invoke(invocation);
    }
}

