/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.registry.client.event.listener;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.threadpool.manager.ExecutorRepository;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.common.utils.ConcurrentHashSet;
import org.apache.dubbo.metadata.MetadataInfo;
import org.apache.dubbo.metadata.MetadataService;
import org.apache.dubbo.registry.NotifyListener;
import org.apache.dubbo.registry.client.DefaultServiceInstance;
import org.apache.dubbo.registry.client.InstanceAddressURL;
import org.apache.dubbo.registry.client.RegistryClusterIdentifier;
import org.apache.dubbo.registry.client.ServiceDiscovery;
import org.apache.dubbo.registry.client.ServiceInstance;
import org.apache.dubbo.registry.client.event.RetryServiceInstancesChangedEvent;
import org.apache.dubbo.registry.client.event.ServiceInstancesChangedEvent;
import org.apache.dubbo.registry.client.metadata.MetadataUtils;
import org.apache.dubbo.registry.client.metadata.ServiceInstanceMetadataUtils;
import org.apache.dubbo.registry.client.metadata.store.RemoteMetadataServiceImpl;
import org.apache.dubbo.rpc.model.ScopeModel;
import org.apache.dubbo.rpc.model.ScopeModelUtil;

public class ServiceInstancesChangedListener {
    private static final Logger logger = LoggerFactory.getLogger(ServiceInstancesChangedListener.class);
    protected final Set<String> serviceNames;
    protected final ServiceDiscovery serviceDiscovery;
    protected URL url;
    protected Map<String, Set<NotifyListener>> listeners;
    protected ConcurrentLinkedQueue<NotifyListenerWithKey> listenerQueue;
    protected AtomicBoolean destroyed = new AtomicBoolean(false);
    protected Map<String, List<ServiceInstance>> allInstances;
    protected Map<String, Object> serviceUrls;
    protected Map<String, MetadataInfo> revisionToMetadata;
    private volatile long lastRefreshTime;
    private Semaphore retryPermission;
    private volatile ScheduledFuture<?> retryFuture;
    private ScheduledExecutorService scheduler;

    public ServiceInstancesChangedListener(Set<String> serviceNames, ServiceDiscovery serviceDiscovery) {
        this.serviceNames = serviceNames;
        this.serviceDiscovery = serviceDiscovery;
        this.listeners = new ConcurrentHashMap<String, Set<NotifyListener>>();
        this.listenerQueue = new ConcurrentLinkedQueue();
        this.allInstances = new HashMap<String, List<ServiceInstance>>();
        this.serviceUrls = new HashMap<String, Object>();
        this.revisionToMetadata = new HashMap<String, MetadataInfo>();
        this.retryPermission = new Semaphore(1);
        this.scheduler = ((ExecutorRepository)ScopeModelUtil.getApplicationModel(serviceDiscovery == null || serviceDiscovery.getUrl() == null ? null : serviceDiscovery.getUrl().getScopeModel()).getExtensionLoader(ExecutorRepository.class).getDefaultExtension()).getMetadataRetryExecutor();
    }

    public synchronized void onEvent(ServiceInstancesChangedEvent event) {
        if (this.destroyed.get() || !this.accept(event) || this.isRetryAndExpired(event)) {
            return;
        }
        this.refreshInstance(event);
        if (logger.isDebugEnabled()) {
            logger.debug(event.getServiceInstances().toString());
        }
        HashMap<String, List> revisionToInstances = new HashMap<String, List>();
        HashMap<String, Map<String, Set<String>>> localServiceToRevisions = new HashMap<String, Map<String, Set<String>>>();
        HashMap<String, MetadataInfo> newRevisionToMetadata = new HashMap<String, MetadataInfo>();
        for (Map.Entry<String, List<ServiceInstance>> entry : this.allInstances.entrySet()) {
            List<ServiceInstance> instances = entry.getValue();
            for (ServiceInstance instance : instances) {
                String revision = ServiceInstanceMetadataUtils.getExportedServicesRevision(instance);
                if (revision == null || "0".equals(revision)) {
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug("Find instance without valid service metadata: " + instance.getAddress());
                    continue;
                }
                List subInstances = revisionToInstances.computeIfAbsent(revision, r -> new LinkedList());
                subInstances.add(instance);
            }
        }
        for (Map.Entry<String, List<ServiceInstance>> entry : revisionToInstances.entrySet()) {
            ServiceInstance instance;
            String revision = entry.getKey();
            List<ServiceInstance> subInstances = entry.getValue();
            instance = this.selectInstance(subInstances);
            MetadataInfo metadata = this.getRemoteMetadata(revision, localServiceToRevisions, instance);
            for (ServiceInstance tmpInstance : subInstances) {
                ((DefaultServiceInstance)tmpInstance).setServiceMetadata(metadata);
            }
            newRevisionToMetadata.putIfAbsent(revision, metadata);
        }
        if (logger.isDebugEnabled()) {
            logger.debug(newRevisionToMetadata.size() + " unique revisions: " + newRevisionToMetadata.keySet());
        }
        if (this.hasEmptyMetadata(newRevisionToMetadata)) {
            if (this.retryPermission.tryAcquire()) {
                this.retryFuture = this.scheduler.schedule(new AddressRefreshRetryTask(this.retryPermission, event.getServiceName()), 10000L, TimeUnit.MILLISECONDS);
                logger.warn("Address refresh try task submitted.");
            }
            logger.error("Address refresh failed because of Metadata Server failure, wait for retry or new address refresh event.");
            return;
        }
        this.revisionToMetadata = newRevisionToMetadata;
        HashMap protocolRevisionsToUrls = new HashMap();
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        for (Map.Entry entry : localServiceToRevisions.entrySet()) {
            String protocol = (String)entry.getKey();
            ((Map)entry.getValue()).forEach((protocolServiceKey, revisions) -> {
                Map revisionsToUrls = protocolRevisionsToUrls.computeIfAbsent(protocol, k -> new HashMap());
                Object urls = revisionsToUrls.get(revisions);
                if (urls == null) {
                    urls = this.getServiceUrlsCache((Map<String, List<ServiceInstance>>)revisionToInstances, (Set<String>)revisions, protocol);
                    revisionsToUrls.put(revisions, urls);
                }
                newServiceUrls.put((String)protocolServiceKey, urls);
            });
        }
        this.serviceUrls = hashMap;
        this.notifyAddressChanged();
    }

    public synchronized void addListenerAndNotify(String serviceKey, NotifyListener listener) {
        List<URL> urls;
        Set<NotifyListener> notifyListeners;
        if (!this.listeners.containsKey(serviceKey)) {
            this.listeners.put(serviceKey, (Set<NotifyListener>)new ConcurrentHashSet());
        }
        if ((notifyListeners = this.listeners.get(serviceKey)).add(listener)) {
            NotifyListenerWithKey listenerWithKey = new NotifyListenerWithKey(serviceKey, listener);
            this.listenerQueue.offer(listenerWithKey);
        }
        if (CollectionUtils.isNotEmpty(urls = this.getAddresses(serviceKey, listener.getConsumerUrl()))) {
            listener.notify(urls);
        }
    }

    public synchronized void removeListener(String serviceKey, NotifyListener notifyListener) {
        Set<NotifyListener> notifyListeners = this.listeners.get(serviceKey);
        if (notifyListeners != null) {
            if (notifyListeners.contains(notifyListener)) {
                notifyListeners.remove(notifyListener);
                NotifyListenerWithKey listenerWithKey = new NotifyListenerWithKey(serviceKey, notifyListener);
                this.listenerQueue.remove(listenerWithKey);
            }
            if (notifyListeners.size() == 0) {
                this.listeners.remove(serviceKey);
            }
        }
        logger.info("Interface listener of interface " + serviceKey + " removed.");
        if (this.listeners.isEmpty()) {
            logger.info("No interface listeners exist, will stop instance listener for " + this.getServiceNames());
            this.serviceDiscovery.removeServiceInstancesChangedListener(this);
        }
    }

    public boolean hasListeners() {
        return CollectionUtils.isNotEmptyMap(this.listeners);
    }

    public final Set<String> getServiceNames() {
        return this.serviceNames;
    }

    public void setUrl(URL url) {
        this.url = url;
    }

    public URL getUrl() {
        return this.url;
    }

    public Map<String, List<ServiceInstance>> getAllInstances() {
        return this.allInstances;
    }

    public List<ServiceInstance> getInstancesOfApp(String appName) {
        return this.allInstances.get(appName);
    }

    public Map<String, MetadataInfo> getRevisionToMetadata() {
        return this.revisionToMetadata;
    }

    public MetadataInfo getMetadata(String revision) {
        return this.revisionToMetadata.get(revision);
    }

    private boolean accept(ServiceInstancesChangedEvent event) {
        return this.serviceNames.contains(event.getServiceName());
    }

    protected boolean isRetryAndExpired(ServiceInstancesChangedEvent event) {
        if (event instanceof RetryServiceInstancesChangedEvent) {
            RetryServiceInstancesChangedEvent retryEvent = (RetryServiceInstancesChangedEvent)event;
            logger.warn("Received address refresh retry event, " + retryEvent.getFailureRecordTime());
            if (retryEvent.getFailureRecordTime() < this.lastRefreshTime && !this.hasEmptyMetadata(this.revisionToMetadata)) {
                logger.warn("Ignore retry event, event time: " + retryEvent.getFailureRecordTime() + ", last refresh time: " + this.lastRefreshTime);
                return true;
            }
            logger.warn("Retrying address notification...");
        }
        return false;
    }

    private void refreshInstance(ServiceInstancesChangedEvent event) {
        if (event instanceof RetryServiceInstancesChangedEvent) {
            return;
        }
        String appName = event.getServiceName();
        List<ServiceInstance> appInstances = event.getServiceInstances();
        logger.info("Received instance notification, serviceName: " + appName + ", instances: " + appInstances.size());
        this.allInstances.put(appName, appInstances);
        this.lastRefreshTime = System.currentTimeMillis();
    }

    protected boolean hasEmptyMetadata(Map<String, MetadataInfo> revisionToMetadata) {
        if (revisionToMetadata == null) {
            return false;
        }
        for (Map.Entry<String, MetadataInfo> entry : revisionToMetadata.entrySet()) {
            if (entry.getValue() != MetadataInfo.EMPTY) continue;
            return true;
        }
        return false;
    }

    protected MetadataInfo getRemoteMetadata(String revision, Map<String, Map<String, Set<String>>> localServiceToRevisions, ServiceInstance instance) {
        MetadataInfo metadata = this.revisionToMetadata.get(revision);
        if (metadata != null && metadata != MetadataInfo.EMPTY) {
            if (logger.isDebugEnabled()) {
                logger.debug("MetadataInfo for instance " + instance.getAddress() + "?revision=" + revision + "&cluster=" + instance.getRegistryCluster() + ", " + metadata);
            }
            this.parseMetadata(revision, metadata, localServiceToRevisions);
            return metadata;
        }
        int triedTimes = 0;
        while (triedTimes < 3) {
            metadata = this.doGetMetadataInfo(instance);
            if (metadata != MetadataInfo.EMPTY) {
                this.parseMetadata(revision, metadata, localServiceToRevisions);
                break;
            }
            logger.error("Failed to get MetadataInfo for instance " + instance.getAddress() + "?revision=" + revision + "&cluster=" + instance.getRegistryCluster() + ", wait for retry.");
            ++triedTimes;
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.revisionToMetadata.putIfAbsent(revision, metadata);
        return metadata;
    }

    protected Map<String, Map<String, Set<String>>> parseMetadata(String revision, MetadataInfo metadata, Map<String, Map<String, Set<String>>> localServiceToRevisions) {
        Map serviceInfos = metadata.getServices();
        for (Map.Entry entry : serviceInfos.entrySet()) {
            String protocol = ((MetadataInfo.ServiceInfo)entry.getValue()).getProtocol();
            String protocolServiceKey = ((MetadataInfo.ServiceInfo)entry.getValue()).getMatchKey();
            Map map = localServiceToRevisions.computeIfAbsent(protocol, _p -> new HashMap());
            Set set = map.computeIfAbsent(protocolServiceKey, _k -> new TreeSet());
            set.add(revision);
        }
        return localServiceToRevisions;
    }

    protected MetadataInfo doGetMetadataInfo(ServiceInstance instance) {
        MetadataInfo metadataInfo;
        String metadataType = ServiceInstanceMetadataUtils.getMetadataStorageType(instance);
        if (instance.getRegistryCluster() == null) {
            instance.setRegistryCluster(RegistryClusterIdentifier.getExtension(this.url).consumerKey(this.url));
        }
        try {
            if (logger.isDebugEnabled()) {
                logger.debug("Instance " + instance.getAddress() + " is using metadata type " + metadataType);
            }
            if ("remote".equals(metadataType)) {
                RemoteMetadataServiceImpl remoteMetadataService = MetadataUtils.getRemoteMetadataService((ScopeModel)instance.getApplicationModel());
                metadataInfo = remoteMetadataService.getMetadata(instance);
            } else {
                MetadataService metadataServiceProxy = MetadataUtils.getMetadataServiceProxy(instance);
                metadataInfo = metadataServiceProxy.getMetadataInfo(ServiceInstanceMetadataUtils.getExportedServicesRevision(instance));
                MetadataUtils.destroyMetadataServiceProxy(instance);
            }
        }
        catch (Exception e) {
            logger.error("Failed to load service metadata, meta type is " + metadataType, (Throwable)e);
            metadataInfo = null;
        }
        if (metadataInfo == null) {
            metadataInfo = MetadataInfo.EMPTY;
        }
        return metadataInfo;
    }

    private ServiceInstance selectInstance(List<ServiceInstance> instances) {
        if (instances.size() == 1) {
            return instances.get(0);
        }
        return instances.get(ThreadLocalRandom.current().nextInt(0, instances.size()));
    }

    protected Object getServiceUrlsCache(Map<String, List<ServiceInstance>> revisionToInstances, Set<String> revisions, String protocol) {
        ArrayList<InstanceAddressURL> urls = new ArrayList<InstanceAddressURL>();
        for (String r : revisions) {
            for (ServiceInstance i : revisionToInstances.get(r)) {
                DefaultServiceInstance.Endpoint endpoint;
                if (ServiceInstanceMetadataUtils.hasEndpoints(i) && (endpoint = ServiceInstanceMetadataUtils.getEndpoint(i, protocol)) != null && !endpoint.getPort().equals(i.getPort())) {
                    urls.add(((DefaultServiceInstance)i).copyFrom(endpoint).toURL());
                    continue;
                }
                urls.add(i.toURL());
            }
        }
        return urls;
    }

    protected List<URL> getAddresses(String serviceProtocolKey, URL consumerURL) {
        return (List)this.serviceUrls.get(serviceProtocolKey);
    }

    protected void notifyAddressChanged() {
        this.listenerQueue.forEach(listenerWithKey -> {
            String key = listenerWithKey.getServiceKey();
            NotifyListener notifyListener = listenerWithKey.getNotifyListener();
            List<URL> urls = this.toUrlsWithEmpty(this.getAddresses(key, notifyListener.getConsumerUrl()));
            logger.info("Notify service " + key + " with urls " + urls.size());
            notifyListener.notify(urls);
        });
    }

    protected List<URL> toUrlsWithEmpty(List<URL> urls) {
        if (urls == null) {
            urls = Collections.emptyList();
        }
        return urls;
    }

    public synchronized void destroy() {
        if (!this.destroyed.get() && CollectionUtils.isEmptyMap(this.listeners) && this.destroyed.compareAndSet(false, true)) {
            this.allInstances.clear();
            this.serviceUrls.clear();
            this.revisionToMetadata.clear();
            if (this.retryFuture != null && !this.retryFuture.isDone()) {
                this.retryFuture.cancel(true);
            }
        }
    }

    public boolean isDestroyed() {
        return this.destroyed.get();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ServiceInstancesChangedListener)) {
            return false;
        }
        ServiceInstancesChangedListener that = (ServiceInstancesChangedListener)o;
        return Objects.equals(this.getServiceNames(), that.getServiceNames());
    }

    public int hashCode() {
        return Objects.hash(this.getClass(), this.getServiceNames());
    }

    protected static class NotifyListenerWithKey {
        private String serviceKey;
        private NotifyListener notifyListener;

        public NotifyListenerWithKey(String serviceKey, NotifyListener notifyListener) {
            this.serviceKey = serviceKey;
            this.notifyListener = notifyListener;
        }

        public String getServiceKey() {
            return this.serviceKey;
        }

        public NotifyListener getNotifyListener() {
            return this.notifyListener;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            NotifyListenerWithKey that = (NotifyListenerWithKey)o;
            return Objects.equals(this.serviceKey, that.serviceKey) && Objects.equals(this.notifyListener, that.notifyListener);
        }

        public int hashCode() {
            return Objects.hash(this.serviceKey, this.notifyListener);
        }
    }

    protected class AddressRefreshRetryTask
    implements Runnable {
        private final RetryServiceInstancesChangedEvent retryEvent;
        private final Semaphore retryPermission;

        public AddressRefreshRetryTask(Semaphore semaphore, String serviceName) {
            this.retryEvent = new RetryServiceInstancesChangedEvent(serviceName);
            this.retryPermission = semaphore;
        }

        @Override
        public void run() {
            this.retryPermission.release();
            ServiceInstancesChangedListener.this.onEvent(this.retryEvent);
        }
    }
}

