/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.registry.client;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.url.component.URLAddress;
import org.apache.dubbo.common.url.component.URLParam;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.metadata.MetadataInfo;
import org.apache.dubbo.registry.client.ServiceInstance;
import org.apache.dubbo.rpc.RpcContext;
import org.apache.dubbo.rpc.model.ApplicationModel;
import org.apache.dubbo.rpc.model.FrameworkModel;
import org.apache.dubbo.rpc.model.ScopeModel;
import org.apache.dubbo.rpc.model.ServiceModel;

public class InstanceAddressURL
extends URL {
    private ServiceInstance instance;
    private MetadataInfo metadataInfo;
    private volatile transient Map<String, Number> numbers;
    private volatile transient Map<String, Map<String, Number>> methodNumbers;
    private volatile transient Set<String> providerFirstParams;

    public InstanceAddressURL() {
    }

    public InstanceAddressURL(ServiceInstance instance, MetadataInfo metadataInfo) {
        this.instance = instance;
        this.metadataInfo = metadataInfo;
    }

    public ServiceInstance getInstance() {
        return this.instance;
    }

    public MetadataInfo getMetadataInfo() {
        return this.metadataInfo;
    }

    public String getServiceInterface() {
        return RpcContext.getServiceContext().getInterfaceName();
    }

    public String getGroup() {
        return RpcContext.getServiceContext().getGroup();
    }

    public String getVersion() {
        return RpcContext.getServiceContext().getVersion();
    }

    public String getProtocol() {
        return RpcContext.getServiceContext().getProtocol();
    }

    public String getProtocolServiceKey() {
        return RpcContext.getServiceContext().getProtocolServiceKey();
    }

    public String getServiceKey() {
        return RpcContext.getServiceContext().getServiceKey();
    }

    public String getAddress() {
        return this.instance.getAddress();
    }

    public String getHost() {
        return this.instance.getHost();
    }

    public int getPort() {
        return this.instance.getPort();
    }

    public String getIp() {
        return this.instance.getHost();
    }

    public String getRemoteApplication() {
        return this.instance.getServiceName();
    }

    public String getSide() {
        return "consumer";
    }

    public String getPath() {
        MetadataInfo.ServiceInfo serviceInfo = this.metadataInfo.getServiceInfo(this.getProtocolServiceKey());
        if (serviceInfo == null) {
            return this.getServiceInterface();
        }
        return serviceInfo.getPath();
    }

    public String getParameter(String key) {
        String v;
        URL consumerUrl;
        if ("version".equals(key)) {
            return this.getVersion();
        }
        if ("group".equals(key)) {
            return this.getGroup();
        }
        if ("interface".equals(key)) {
            return this.getServiceInterface();
        }
        if ("remote.application".equals(key)) {
            return this.instance.getServiceName();
        }
        if ("side".equals(key)) {
            return this.getSide();
        }
        if (this.consumerParamFirst(key) && (consumerUrl = RpcContext.getServiceContext().getConsumerUrl()) != null && StringUtils.isNotEmpty((String)(v = consumerUrl.getParameter(key)))) {
            return v;
        }
        String protocolServiceKey = this.getProtocolServiceKey();
        if (StringUtils.isEmpty((String)protocolServiceKey)) {
            return this.getInstanceParameter(key);
        }
        return this.getServiceParameter(protocolServiceKey, key);
    }

    public String getServiceParameter(String service, String key) {
        String value;
        String v;
        URL consumerUrl;
        if (this.consumerParamFirst(key) && (consumerUrl = RpcContext.getServiceContext().getConsumerUrl()) != null && StringUtils.isNotEmpty((String)(v = consumerUrl.getServiceParameter(service, key)))) {
            return v;
        }
        if (this.metadataInfo != null && StringUtils.isNotEmpty((String)(value = this.metadataInfo.getParameter(key, service)))) {
            return value;
        }
        return this.getInstanceParameter(key);
    }

    public String getServiceMethodParameter(String protocolServiceKey, String method, String key) {
        String v;
        URL consumerUrl;
        if (this.consumerParamFirst(key) && (consumerUrl = RpcContext.getServiceContext().getConsumerUrl()) != null && StringUtils.isNotEmpty((String)(v = consumerUrl.getServiceMethodParameter(protocolServiceKey, method, key)))) {
            return v;
        }
        MetadataInfo.ServiceInfo serviceInfo = this.metadataInfo.getServiceInfo(protocolServiceKey);
        String value = serviceInfo.getMethodParameter(method, key, null);
        if (StringUtils.isNotEmpty((String)value)) {
            return value;
        }
        return this.getParameter(key);
    }

    public String getMethodParameter(String method, String key) {
        String v;
        URL consumerUrl;
        if (this.consumerParamFirst(key) && (consumerUrl = RpcContext.getServiceContext().getConsumerUrl()) != null && StringUtils.isNotEmpty((String)(v = consumerUrl.getMethodParameter(method, key)))) {
            return v;
        }
        String protocolServiceKey = this.getProtocolServiceKey();
        if (StringUtils.isEmpty((String)protocolServiceKey)) {
            return null;
        }
        return this.getServiceMethodParameter(protocolServiceKey, method, key);
    }

    public boolean hasServiceMethodParameter(String protocolServiceKey, String method, String key) {
        URL consumerUrl;
        if (this.consumerParamFirst(key) && (consumerUrl = RpcContext.getServiceContext().getConsumerUrl()) != null && consumerUrl.hasServiceMethodParameter(protocolServiceKey, method, key)) {
            return true;
        }
        MetadataInfo.ServiceInfo serviceInfo = this.metadataInfo.getServiceInfo(protocolServiceKey);
        if (StringUtils.isEmpty((String)method)) {
            String suffix = "." + key;
            for (String fullKey : this.getParameters().keySet()) {
                if (!fullKey.endsWith(suffix)) continue;
                return true;
            }
            return false;
        }
        if (StringUtils.isEmpty((String)key)) {
            String prefix = method + ".";
            for (String fullKey : this.getParameters().keySet()) {
                if (!fullKey.startsWith(prefix)) continue;
                return true;
            }
            return false;
        }
        return serviceInfo.hasMethodParameter(method, key);
    }

    public boolean hasMethodParameter(String method, String key) {
        URL consumerUrl;
        if (this.consumerParamFirst(key) && (consumerUrl = RpcContext.getServiceContext().getConsumerUrl()) != null && consumerUrl.hasMethodParameter(method, key)) {
            return true;
        }
        String protocolServiceKey = this.getProtocolServiceKey();
        if (StringUtils.isEmpty((String)protocolServiceKey)) {
            return false;
        }
        return this.hasServiceMethodParameter(protocolServiceKey, method, key);
    }

    public boolean hasServiceMethodParameter(String protocolServiceKey, String method) {
        URL consumerUrl = RpcContext.getServiceContext().getConsumerUrl();
        if (consumerUrl != null && consumerUrl.hasServiceMethodParameter(protocolServiceKey, method)) {
            return true;
        }
        MetadataInfo.ServiceInfo serviceInfo = this.metadataInfo.getServiceInfo(protocolServiceKey);
        return serviceInfo.hasMethodParameter(method);
    }

    public boolean hasMethodParameter(String method) {
        URL consumerUrl = RpcContext.getServiceContext().getConsumerUrl();
        if (consumerUrl != null && consumerUrl.hasMethodParameter(method)) {
            return true;
        }
        String protocolServiceKey = this.getProtocolServiceKey();
        if (StringUtils.isEmpty((String)protocolServiceKey)) {
            return false;
        }
        return this.hasServiceMethodParameter(protocolServiceKey, method);
    }

    public Map<String, String> getServiceParameters(String protocolServiceKey) {
        URL consumerUrl;
        Map<String, String> instanceParams = this.getInstance().getAllParams();
        Map metadataParams = this.metadataInfo == null ? new HashMap() : this.metadataInfo.getParameters(protocolServiceKey);
        int i = instanceParams == null ? 0 : instanceParams.size();
        int j = metadataParams == null ? 0 : metadataParams.size();
        HashMap<String, String> params = new HashMap<String, String>((int)((double)(i + j) / 0.75) + 1);
        if (instanceParams != null) {
            params.putAll(instanceParams);
        }
        if (metadataParams != null) {
            params.putAll(metadataParams);
        }
        if ((consumerUrl = RpcContext.getServiceContext().getConsumerUrl()) != null) {
            HashMap consumerParams = new HashMap(consumerUrl.getParameters());
            if (CollectionUtils.isNotEmpty(this.providerFirstParams)) {
                this.providerFirstParams.forEach(consumerParams::remove);
            }
            params.putAll(consumerParams);
        }
        return params;
    }

    public Map<String, String> getParameters() {
        String protocolServiceKey = this.getProtocolServiceKey();
        if (StringUtils.isEmpty((String)protocolServiceKey)) {
            return this.getInstance().getAllParams();
        }
        return this.getServiceParameters(protocolServiceKey);
    }

    public URL addParameter(String key, String value) {
        if (StringUtils.isEmpty((String)key) || StringUtils.isEmpty((String)value)) {
            return this;
        }
        this.getInstance().getExtendParams().put(key, value);
        return this;
    }

    public URL addParameterIfAbsent(String key, String value) {
        if (StringUtils.isEmpty((String)key) || StringUtils.isEmpty((String)value)) {
            return this;
        }
        this.getInstance().getExtendParams().putIfAbsent(key, value);
        return this;
    }

    public URL addServiceParameter(String protocolServiceKey, String key, String value) {
        if (StringUtils.isEmpty((String)key) || StringUtils.isEmpty((String)value)) {
            return this;
        }
        this.getMetadataInfo().getServiceInfo(protocolServiceKey).addParameter(key, value);
        return this;
    }

    public URL addServiceParameterIfAbsent(String protocolServiceKey, String key, String value) {
        if (StringUtils.isEmpty((String)key) || StringUtils.isEmpty((String)value)) {
            return this;
        }
        this.getMetadataInfo().getServiceInfo(protocolServiceKey).addParameterIfAbsent(key, value);
        return this;
    }

    public URL addConsumerParams(String protocolServiceKey, Map<String, String> params) {
        this.getMetadataInfo().getServiceInfo(protocolServiceKey).addConsumerParams(params);
        return this;
    }

    public String getAnyMethodParameter(String key) {
        String suffix = "." + key;
        String protocolServiceKey = this.getProtocolServiceKey();
        if (StringUtils.isNotEmpty((String)protocolServiceKey)) {
            for (String fullKey : this.metadataInfo.getServiceInfo(protocolServiceKey).getAllParams().keySet()) {
                if (!fullKey.endsWith(suffix)) continue;
                return this.getParameter(fullKey);
            }
        }
        return null;
    }

    public URLParam getUrlParam() {
        throw new UnsupportedOperationException("URLParam is replaced with MetadataInfo in instance url");
    }

    public URLAddress getUrlAddress() {
        throw new UnsupportedOperationException("URLAddress is replaced with ServiceInstance in instance url");
    }

    protected Map<String, Number> getServiceNumbers(String protocolServiceKey) {
        return this.getServiceInfo(protocolServiceKey).getNumbers();
    }

    protected Map<String, Number> getNumbers() {
        String protocolServiceKey = this.getProtocolServiceKey();
        if (StringUtils.isEmpty((String)protocolServiceKey)) {
            if (this.numbers == null) {
                this.numbers = new ConcurrentHashMap<String, Number>();
            }
            return this.numbers;
        }
        return this.getServiceNumbers(protocolServiceKey);
    }

    protected Map<String, Map<String, Number>> getServiceMethodNumbers(String protocolServiceKey) {
        return this.getServiceInfo(protocolServiceKey).getMethodNumbers();
    }

    protected Map<String, Map<String, Number>> getMethodNumbers() {
        String protocolServiceKey = this.getProtocolServiceKey();
        if (StringUtils.isEmpty((String)protocolServiceKey)) {
            if (this.methodNumbers == null) {
                this.methodNumbers = new ConcurrentHashMap<String, Map<String, Number>>();
            }
            return this.methodNumbers;
        }
        return this.getServiceMethodNumbers(protocolServiceKey);
    }

    private MetadataInfo.ServiceInfo getServiceInfo(String protocolServiceKey) {
        return this.metadataInfo.getServiceInfo(protocolServiceKey);
    }

    private String getInstanceParameter(String key) {
        String value = this.instance.getMetadata().get(key);
        if (StringUtils.isNotEmpty((String)value)) {
            return value;
        }
        return this.instance.getExtendParams().get(key);
    }

    private Map<String, String> getInstanceMetadata() {
        return this.instance.getMetadata();
    }

    public ScopeModel getScopeModel() {
        return RpcContext.getServiceContext().getConsumerUrl().getScopeModel();
    }

    public FrameworkModel getOrDefaultFrameworkModel() {
        return this.instance.getOrDefaultApplicationModel().getFrameworkModel();
    }

    public ApplicationModel getOrDefaultApplicationModel() {
        return this.instance.getOrDefaultApplicationModel();
    }

    public ServiceModel getServiceModel() {
        return RpcContext.getServiceContext().getConsumerUrl().getServiceModel();
    }

    public Set<String> getProviderFirstParams() {
        return this.providerFirstParams;
    }

    public void setProviderFirstParams(Set<String> providerFirstParams) {
        this.providerFirstParams = providerFirstParams;
    }

    private boolean consumerParamFirst(String key) {
        if (CollectionUtils.isNotEmpty(this.providerFirstParams)) {
            return !this.providerFirstParams.contains(key);
        }
        return true;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceAddressURL)) {
            return false;
        }
        InstanceAddressURL that = (InstanceAddressURL)((Object)obj);
        return this.getInstance().equals(that.getInstance());
    }

    public int hashCode() {
        return this.getInstance().hashCode();
    }

    public String toString() {
        if (this.instance == null) {
            return "{}";
        }
        if (this.metadataInfo == null) {
            return this.instance.toString();
        }
        String protocolServiceKey = RpcContext.getServiceContext().getProtocolServiceKey();
        if (StringUtils.isNotEmpty((String)protocolServiceKey)) {
            return this.instance.toString() + ", " + this.metadataInfo.getServiceString(protocolServiceKey);
        }
        return this.instance.toString();
    }
}

