/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.registry.client.metadata;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.URLBuilder;
import org.apache.dubbo.common.config.ConfigurationUtils;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.JsonUtils;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.metadata.MetadataService;
import org.apache.dubbo.registry.client.ServiceInstance;
import org.apache.dubbo.registry.client.metadata.MetadataServiceURLBuilder;
import org.apache.dubbo.rpc.model.ApplicationModel;
import org.apache.dubbo.rpc.model.ScopeModel;

public class StandardMetadataServiceURLBuilder
implements MetadataServiceURLBuilder {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    public static final String NAME = "standard";
    private ApplicationModel applicationModel;
    private Integer metadataServicePort;

    public StandardMetadataServiceURLBuilder(ApplicationModel applicationModel) {
        this.applicationModel = applicationModel;
        this.metadataServicePort = applicationModel.getCurrentConfig().getMetadataServicePort();
    }

    @Override
    public List<URL> build(ServiceInstance serviceInstance) {
        Map<String, String> paramsMap = this.getMetadataServiceURLsParams(serviceInstance);
        String serviceName = serviceInstance.getServiceName();
        String host = serviceInstance.getHost();
        URL url = paramsMap.isEmpty() ? this.generateUrlWithoutMetadata(serviceName, host, serviceInstance.getPort()) : this.generateWithMetadata(serviceName, host, paramsMap);
        url = url.setScopeModel((ScopeModel)serviceInstance.getApplicationModel().getInternalModule());
        return Collections.singletonList(url);
    }

    private URL generateWithMetadata(String serviceName, String host, Map<String, String> params) {
        String protocol = params.get("protocol");
        int port = Integer.parseInt(params.get("port"));
        URLBuilder urlBuilder = new URLBuilder().setHost(host).setPort(port).setProtocol(protocol).setPath(MetadataService.class.getName()).addParameter("timeout", ConfigurationUtils.get((ScopeModel)this.applicationModel, (String)"dubbo.application.metadata.proxy.delay", (int)5000)).addParameter("side", "consumer").addParameter("connections", 1).addParameter("threadpool", "cached").addParameter("threads", "100").addParameter("corethreads", "2").addParameter("retries", 0);
        params.forEach((arg_0, arg_1) -> ((URLBuilder)urlBuilder).addParameter(arg_0, arg_1));
        urlBuilder.addParameter("group", serviceName);
        return urlBuilder.build();
    }

    private URL generateUrlWithoutMetadata(String serviceName, String host, Integer instancePort) {
        Integer port = this.metadataServicePort;
        if (port == null || port < 1) {
            this.logger.warn("Metadata Service Port is not provided, since DNS is not able to negotiate the metadata port between Provider and Consumer, will try to use instance port as the default metadata port.");
            port = instancePort;
        }
        if (port == null || port < 1) {
            String message = "Metadata Service Port should be specified for consumer. Please set dubbo.application.metadataServicePort and make sure it has been set on provider side. ServiceName: " + serviceName + " Host: " + host;
            throw new IllegalStateException(message);
        }
        URLBuilder urlBuilder = new URLBuilder().setHost(host).setPort(port.intValue()).setProtocol("dubbo").setPath(MetadataService.class.getName()).addParameter("timeout", ConfigurationUtils.get((ScopeModel)this.applicationModel, (String)"dubbo.application.metadata.proxy.delay", (int)5000)).addParameter("reconnect", false).addParameter("side", "consumer").addParameter("group", serviceName).addParameter("version", "1.0.0").addParameter("retries", 0);
        urlBuilder.addParameter("getAndListenInstanceMetadata.1.callback", true);
        return urlBuilder.build();
    }

    private Map<String, String> getMetadataServiceURLsParams(ServiceInstance serviceInstance) {
        Map<String, String> metadata = serviceInstance.getMetadata();
        String param = metadata.get("dubbo.metadata-service.url-params");
        return StringUtils.isBlank((CharSequence)param) ? Collections.emptyMap() : (Map)JsonUtils.getJson().toJavaObject(param, Map.class);
    }
}

