/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.registry.client.metadata.store;

import java.util.Map;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.metadata.MetadataInfo;
import org.apache.dubbo.metadata.WritableMetadataService;
import org.apache.dubbo.metadata.definition.ServiceDefinitionBuilder;
import org.apache.dubbo.metadata.definition.model.FullServiceDefinition;
import org.apache.dubbo.metadata.definition.model.ServiceDefinition;
import org.apache.dubbo.metadata.report.MetadataReport;
import org.apache.dubbo.metadata.report.MetadataReportInstance;
import org.apache.dubbo.metadata.report.identifier.MetadataIdentifier;
import org.apache.dubbo.metadata.report.identifier.SubscriberMetadataIdentifier;
import org.apache.dubbo.registry.client.ServiceInstance;
import org.apache.dubbo.registry.client.metadata.ServiceInstanceMetadataUtils;
import org.apache.dubbo.rpc.RpcException;

public class RemoteMetadataServiceImpl {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private WritableMetadataService localMetadataService;

    public RemoteMetadataServiceImpl(WritableMetadataService writableMetadataService) {
        this.localMetadataService = writableMetadataService;
    }

    public Map<String, MetadataReport> getMetadataReports() {
        return MetadataReportInstance.getMetadataReports((boolean)false);
    }

    public void publishMetadata(String serviceName) {
        Map metadataInfos = this.localMetadataService.getMetadataInfos();
        metadataInfos.forEach((registryCluster, metadataInfo) -> {
            if (!metadataInfo.hasReported()) {
                SubscriberMetadataIdentifier identifier = new SubscriberMetadataIdentifier(serviceName, metadataInfo.calAndGetRevision());
                metadataInfo.calAndGetRevision();
                metadataInfo.getExtendParams().put("REGISTRY_CLUSTER", registryCluster);
                MetadataReport metadataReport = this.getMetadataReports().get(registryCluster);
                if (metadataReport == null) {
                    metadataReport = this.getMetadataReports().entrySet().iterator().next().getValue();
                }
                this.logger.info("Publishing metadata to " + metadataReport.getClass().getSimpleName());
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug(metadataInfo.toString());
                }
                metadataReport.publishAppMetadata(identifier, metadataInfo);
                metadataInfo.markReported();
            }
        });
    }

    public MetadataInfo getMetadata(ServiceInstance instance) {
        SubscriberMetadataIdentifier identifier = new SubscriberMetadataIdentifier(instance.getServiceName(), ServiceInstanceMetadataUtils.getExportedServicesRevision(instance));
        String registryCluster = instance.getExtendParams().get("REGISTRY_CLUSTER");
        MetadataReport metadataReport = this.getMetadataReports().get(registryCluster);
        if (metadataReport == null) {
            metadataReport = this.getMetadataReports().entrySet().iterator().next().getValue();
        }
        return metadataReport.getAppMetadata(identifier, instance.getExtendParams());
    }

    public void publishServiceDefinition(URL url) {
        String side = url.getParameter("side");
        if ("provider".equalsIgnoreCase(side)) {
            this.publishProvider(url);
        } else {
            this.publishConsumer(url);
        }
    }

    private void publishProvider(URL providerUrl) throws RpcException {
        providerUrl = providerUrl.removeParameters(new String[]{"pid", "timestamp", "bind.ip", "bind.port", "timestamp"});
        try {
            String interfaceName = providerUrl.getParameter("interface");
            if (StringUtils.isNotEmpty((String)interfaceName)) {
                Class<?> interfaceClass = Class.forName(interfaceName);
                FullServiceDefinition fullServiceDefinition = ServiceDefinitionBuilder.buildFullDefinition(interfaceClass, (Map)providerUrl.getParameters());
                for (Map.Entry<String, MetadataReport> entry : this.getMetadataReports().entrySet()) {
                    MetadataReport metadataReport = entry.getValue();
                    metadataReport.storeProviderMetadata(new MetadataIdentifier(providerUrl.getServiceInterface(), providerUrl.getParameter("version"), providerUrl.getParameter("group"), "provider", providerUrl.getParameter("application")), (ServiceDefinition)fullServiceDefinition);
                }
                return;
            }
            this.logger.error("publishProvider interfaceName is empty . providerUrl: " + providerUrl.toFullString());
        }
        catch (ClassNotFoundException e) {
            this.logger.error("publishProvider getServiceDescriptor error. providerUrl: " + providerUrl.toFullString(), (Throwable)e);
        }
    }

    private void publishConsumer(URL consumerURL) throws RpcException {
        URL url = consumerURL.removeParameters(new String[]{"pid", "timestamp", "bind.ip", "bind.port", "timestamp"});
        this.getMetadataReports().forEach((registryKey, config) -> config.storeConsumerMetadata(new MetadataIdentifier(url.getServiceInterface(), url.getParameter("version"), url.getParameter("group"), "consumer", url.getParameter("application")), url.getParameters()));
    }
}

