/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.aot.api;

import java.util.Arrays;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.dubbo.aot.api.ConditionalDescriber;

public class ResourcePatternDescriber
implements ConditionalDescriber {
    private final String pattern;
    private final String reachableType;

    public ResourcePatternDescriber(String pattern, String reachableType) {
        this.pattern = pattern;
        this.reachableType = reachableType;
    }

    public String getPattern() {
        return this.pattern;
    }

    @Override
    public String getReachableType() {
        return this.reachableType;
    }

    public Pattern toRegex() {
        String prefix = this.pattern.startsWith("*") ? ".*" : "";
        String suffix = this.pattern.endsWith("*") ? ".*" : "";
        String regex = Arrays.stream(this.pattern.split("\\*")).filter(s -> !s.isEmpty()).map(Pattern::quote).collect(Collectors.joining(".*", prefix, suffix));
        return Pattern.compile(regex);
    }
}

