/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.mutiny.calls;

import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.subscription.UniEmitter;
import org.apache.dubbo.common.stream.StreamObserver;
import org.apache.dubbo.mutiny.ClientTripleMutinyPublisher;
import org.apache.dubbo.mutiny.ClientTripleMutinySubscriber;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.model.MethodDescriptor;
import org.apache.dubbo.rpc.model.StubMethodDescriptor;
import org.apache.dubbo.rpc.stub.StubInvocationUtil;

public class MutinyClientCalls {
    private MutinyClientCalls() {
    }

    public static <TRequest, TResponse, TInvoker> Uni<TResponse> oneToOne(Invoker<TInvoker> invoker, Uni<TRequest> uniRequest, StubMethodDescriptor methodDescriptor) {
        try {
            return uniRequest.onItem().transformToUni(request -> Uni.createFrom().emitter(emitter -> StubInvocationUtil.unaryCall((Invoker)invoker, (MethodDescriptor)methodDescriptor, (Object)request, (StreamObserver)new StreamObserver<TResponse>((UniEmitter)emitter){
                final /* synthetic */ UniEmitter val$emitter;
                {
                    this.val$emitter = uniEmitter;
                }

                public void onNext(TResponse value) {
                    this.val$emitter.complete(value);
                }

                public void onError(Throwable t) {
                    this.val$emitter.fail(t);
                }

                public void onCompleted() {
                }
            })));
        }
        catch (Throwable throwable) {
            return Uni.createFrom().failure(throwable);
        }
    }

    public static <TRequest, TResponse, TInvoker> Multi<TResponse> oneToMany(Invoker<TInvoker> invoker, Uni<TRequest> uniRequest, StubMethodDescriptor methodDescriptor) {
        try {
            return uniRequest.onItem().transformToMulti(request -> {
                ClientTripleMutinyPublisher clientPublisher = new ClientTripleMutinyPublisher();
                StubInvocationUtil.serverStreamCall((Invoker)invoker, (MethodDescriptor)methodDescriptor, (Object)request, clientPublisher);
                return clientPublisher;
            });
        }
        catch (Throwable throwable) {
            return Multi.createFrom().failure(throwable);
        }
    }

    public static <TRequest, TResponse, TInvoker> Uni<TResponse> manyToOne(Invoker<TInvoker> invoker, Multi<TRequest> multiRequest, StubMethodDescriptor methodDescriptor) {
        try {
            ClientTripleMutinySubscriber clientSubscriber = (ClientTripleMutinySubscriber)multiRequest.subscribe().withSubscriber(new ClientTripleMutinySubscriber());
            ClientTripleMutinyPublisher clientPublisher = new ClientTripleMutinyPublisher(s -> clientSubscriber.subscribe(s), clientSubscriber::cancel);
            return Uni.createFrom().publisher(clientPublisher).onSubscription().invoke(() -> StubInvocationUtil.biOrClientStreamCall((Invoker)invoker, (MethodDescriptor)methodDescriptor, (StreamObserver)clientPublisher));
        }
        catch (Throwable err) {
            return Uni.createFrom().failure(err);
        }
    }

    public static <TRequest, TResponse, TInvoker> Multi<TResponse> manyToMany(Invoker<TInvoker> invoker, Multi<TRequest> multiRequest, StubMethodDescriptor methodDescriptor) {
        try {
            ClientTripleMutinySubscriber clientSubscriber = (ClientTripleMutinySubscriber)multiRequest.subscribe().withSubscriber(new ClientTripleMutinySubscriber());
            ClientTripleMutinyPublisher clientPublisher = new ClientTripleMutinyPublisher(s -> clientSubscriber.subscribe(s), clientSubscriber::cancel);
            return Multi.createFrom().publisher(clientPublisher).onSubscription().invoke(() -> StubInvocationUtil.biOrClientStreamCall((Invoker)invoker, (MethodDescriptor)methodDescriptor, (StreamObserver)clientPublisher));
        }
        catch (Throwable err) {
            return Multi.createFrom().failure(err);
        }
    }
}

