/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.metrics.collector.sample;

import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.dubbo.common.utils.Assert;
import org.apache.dubbo.common.utils.ConcurrentHashMapUtils;
import org.apache.dubbo.metrics.collector.sample.MetricsCountSampleConfigurer;
import org.apache.dubbo.metrics.collector.sample.MetricsCountSampler;
import org.apache.dubbo.metrics.model.Metric;

public abstract class SimpleMetricsCountSampler<S, K, M extends Metric>
implements MetricsCountSampler<S, K, M> {
    private final ConcurrentHashMap<M, AtomicLong> EMPTY_COUNT = new ConcurrentHashMap();
    private final ConcurrentHashMap<K, ConcurrentHashMap<M, AtomicLong>> metricCounter = new ConcurrentHashMap();

    @Override
    public void inc(S source, K metricName) {
        this.getAtomicCounter(source, metricName).incrementAndGet();
    }

    @Override
    public Optional<ConcurrentHashMap<M, AtomicLong>> getCount(K metricName) {
        return Optional.ofNullable(this.metricCounter.get(metricName) == null ? this.EMPTY_COUNT : this.metricCounter.get(metricName));
    }

    protected abstract void countConfigure(MetricsCountSampleConfigurer<S, K, M> var1);

    private AtomicLong getAtomicCounter(S source, K metricsName) {
        MetricsCountSampleConfigurer sampleConfigure = new MetricsCountSampleConfigurer();
        sampleConfigure.setSource(source);
        sampleConfigure.setMetricsName(metricsName);
        this.countConfigure(sampleConfigure);
        ConcurrentHashMap metricAtomic = this.metricCounter.get(metricsName);
        if (metricAtomic == null) {
            metricAtomic = (ConcurrentHashMap)ConcurrentHashMapUtils.computeIfAbsent(this.metricCounter, metricsName, k -> new ConcurrentHashMap());
        }
        Assert.notNull(sampleConfigure.getMetric(), (String)"metrics is null");
        AtomicLong atomicCounter = (AtomicLong)metricAtomic.get(sampleConfigure.getMetric());
        if (atomicCounter == null) {
            atomicCounter = (AtomicLong)ConcurrentHashMapUtils.computeIfAbsent((ConcurrentMap)metricAtomic, sampleConfigure.getMetric(), k -> new AtomicLong());
        }
        return atomicCounter;
    }
}

