/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.metrics.collector;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.dubbo.common.utils.ConcurrentHashMapUtils;
import org.apache.dubbo.config.MetricsConfig;
import org.apache.dubbo.config.context.ConfigManager;
import org.apache.dubbo.config.nested.AggregationConfig;
import org.apache.dubbo.metrics.DefaultConstants;
import org.apache.dubbo.metrics.aggregate.TimeWindowAggregator;
import org.apache.dubbo.metrics.aggregate.TimeWindowCounter;
import org.apache.dubbo.metrics.aggregate.TimeWindowQuantile;
import org.apache.dubbo.metrics.collector.DefaultMetricsCollector;
import org.apache.dubbo.metrics.collector.MetricsCollector;
import org.apache.dubbo.metrics.event.MetricsEvent;
import org.apache.dubbo.metrics.event.RequestEvent;
import org.apache.dubbo.metrics.listener.MetricsListener;
import org.apache.dubbo.metrics.model.MethodMetric;
import org.apache.dubbo.metrics.model.MetricsCategory;
import org.apache.dubbo.metrics.model.MetricsSupport;
import org.apache.dubbo.metrics.model.key.MetricsKey;
import org.apache.dubbo.metrics.model.key.MetricsKeyWrapper;
import org.apache.dubbo.metrics.model.key.MetricsLevel;
import org.apache.dubbo.metrics.model.key.MetricsPlaceValue;
import org.apache.dubbo.metrics.model.sample.GaugeMetricSample;
import org.apache.dubbo.metrics.model.sample.MetricSample;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.model.ApplicationModel;

public class AggregateMetricsCollector
implements MetricsCollector<RequestEvent> {
    private int bucketNum = DEFAULT_BUCKET_NUM;
    private int timeWindowSeconds = DEFAULT_TIME_WINDOW_SECONDS;
    private int qpsTimeWindowMillSeconds = DEFAULT_QPS_TIME_WINDOW_MILL_SECONDS;
    private final ConcurrentHashMap<MetricsKeyWrapper, ConcurrentHashMap<MethodMetric, TimeWindowCounter>> methodTypeCounter = new ConcurrentHashMap();
    private final ConcurrentMap<MethodMetric, TimeWindowQuantile> rt = new ConcurrentHashMap<MethodMetric, TimeWindowQuantile>();
    private final ConcurrentHashMap<MethodMetric, TimeWindowCounter> qps = new ConcurrentHashMap();
    private final ApplicationModel applicationModel;
    private static final Integer DEFAULT_COMPRESSION = 100;
    private static final Integer DEFAULT_BUCKET_NUM = 10;
    private static final Integer DEFAULT_TIME_WINDOW_SECONDS = 120;
    private static final Integer DEFAULT_QPS_TIME_WINDOW_MILL_SECONDS = 3000;
    private Boolean collectEnabled = null;
    private boolean enableQps;
    private boolean enableRtPxx;
    private boolean enableRt;
    private boolean enableRequest;
    private final AtomicBoolean samplesChanged = new AtomicBoolean(true);
    private final ConcurrentMap<MethodMetric, TimeWindowAggregator> rtAgr = new ConcurrentHashMap<MethodMetric, TimeWindowAggregator>();
    private boolean serviceLevel;

    public AggregateMetricsCollector(ApplicationModel applicationModel) {
        this.applicationModel = applicationModel;
        ConfigManager configManager = applicationModel.getApplicationConfigManager();
        if (this.isCollectEnabled()) {
            Optional optional = configManager.getMetrics();
            if (optional.isPresent()) {
                this.registerListener();
                AggregationConfig aggregation = ((MetricsConfig)optional.get()).getAggregation();
                this.bucketNum = Optional.ofNullable(aggregation.getBucketNum()).orElse(DEFAULT_BUCKET_NUM);
                this.timeWindowSeconds = Optional.ofNullable(aggregation.getTimeWindowSeconds()).orElse(DEFAULT_TIME_WINDOW_SECONDS);
                this.qpsTimeWindowMillSeconds = Optional.ofNullable(aggregation.getQpsTimeWindowMillSeconds()).orElse(DEFAULT_QPS_TIME_WINDOW_MILL_SECONDS);
                this.enableQps = Optional.ofNullable(aggregation.getEnableQps()).orElse(true);
                this.enableRtPxx = Optional.ofNullable(aggregation.getEnableRtPxx()).orElse(true);
                this.enableRt = Optional.ofNullable(aggregation.getEnableRt()).orElse(true);
                this.enableRequest = Optional.ofNullable(aggregation.getEnableRequest()).orElse(true);
            }
            this.serviceLevel = MethodMetric.isServiceLevel((ApplicationModel)applicationModel);
        }
    }

    public void setCollectEnabled(Boolean collectEnabled) {
        if (collectEnabled != null) {
            this.collectEnabled = collectEnabled;
        }
    }

    public boolean isCollectEnabled() {
        if (this.collectEnabled == null) {
            ConfigManager configManager = this.applicationModel.getApplicationConfigManager();
            configManager.getMetrics().ifPresent(metricsConfig -> this.setCollectEnabled(metricsConfig.getAggregation().getEnabled()));
        }
        return Optional.ofNullable(this.collectEnabled).orElse(false);
    }

    public boolean isSupport(MetricsEvent event) {
        return event instanceof RequestEvent;
    }

    public void onEvent(RequestEvent event) {
        if (this.enableQps) {
            MethodMetric metric = this.calcWindowCounter(event, MetricsKey.METRIC_REQUESTS);
            TimeWindowCounter qpsCounter = this.qps.get(metric);
            if (qpsCounter == null) {
                qpsCounter = (TimeWindowCounter)ConcurrentHashMapUtils.computeIfAbsent(this.qps, (Object)metric, methodMetric -> new TimeWindowCounter(this.bucketNum, TimeUnit.MILLISECONDS.toSeconds(this.qpsTimeWindowMillSeconds)));
                this.samplesChanged.set(true);
            }
            qpsCounter.increment();
        }
    }

    public void onEventFinish(RequestEvent event) {
        MetricsKey targetKey = MetricsKey.METRIC_REQUESTS_SUCCEED;
        Object throwableObj = event.getAttachmentValue("metric_filter_throwable");
        if (throwableObj != null) {
            targetKey = MetricsSupport.getAggMetricsKey((Throwable)((Throwable)throwableObj));
        }
        this.calcWindowCounter(event, targetKey);
        this.onRTEvent(event);
    }

    public void onEventError(RequestEvent event) {
        if (this.enableRequest) {
            MetricsKey targetKey = MetricsKey.METRIC_REQUESTS_FAILED;
            Object throwableObj = event.getAttachmentValue("metric_filter_throwable");
            if (throwableObj != null) {
                targetKey = MetricsSupport.getAggMetricsKey((Throwable)((Throwable)throwableObj));
            }
            this.calcWindowCounter(event, targetKey);
        }
        if (this.enableRt || this.enableRtPxx) {
            this.onRTEvent(event);
        }
    }

    private void onRTEvent(RequestEvent event) {
        MethodMetric metric = new MethodMetric(this.applicationModel, (Invocation)event.getAttachmentValue("metric_filter_invocation"), this.serviceLevel);
        long responseTime = event.getTimePair().calc();
        if (this.enableRt) {
            TimeWindowQuantile quantile = (TimeWindowQuantile)this.rt.get(metric);
            if (quantile == null) {
                quantile = (TimeWindowQuantile)ConcurrentHashMapUtils.computeIfAbsent(this.rt, (Object)metric, k -> new TimeWindowQuantile((double)DEFAULT_COMPRESSION.intValue(), this.bucketNum, this.timeWindowSeconds));
                this.samplesChanged.set(true);
            }
            quantile.add((double)responseTime);
        }
        if (this.enableRtPxx) {
            TimeWindowAggregator timeWindowAggregator = (TimeWindowAggregator)this.rtAgr.get(metric);
            if (timeWindowAggregator == null) {
                timeWindowAggregator = (TimeWindowAggregator)ConcurrentHashMapUtils.computeIfAbsent(this.rtAgr, (Object)metric, methodMetric -> new TimeWindowAggregator(this.bucketNum, this.timeWindowSeconds));
                this.samplesChanged.set(true);
            }
            timeWindowAggregator.add((double)responseTime);
        }
    }

    private MethodMetric calcWindowCounter(RequestEvent event, MetricsKey targetKey) {
        MetricsPlaceValue placeType = MetricsPlaceValue.of((String)((String)event.getAttachmentValue("metric_filter_side")), (MetricsLevel)MetricsLevel.SERVICE);
        MetricsKeyWrapper metricsKeyWrapper = new MetricsKeyWrapper(targetKey, placeType);
        MethodMetric metric = new MethodMetric(this.applicationModel, (Invocation)event.getAttachmentValue("metric_filter_invocation"), this.serviceLevel);
        ConcurrentMap counter = (ConcurrentMap)ConcurrentHashMapUtils.computeIfAbsent(this.methodTypeCounter, (Object)metricsKeyWrapper, k -> new ConcurrentHashMap());
        TimeWindowCounter windowCounter = (TimeWindowCounter)counter.get(metric);
        if (windowCounter == null) {
            windowCounter = (TimeWindowCounter)ConcurrentHashMapUtils.computeIfAbsent((ConcurrentMap)counter, (Object)metric, methodMetric -> new TimeWindowCounter(this.bucketNum, (long)this.timeWindowSeconds));
            this.samplesChanged.set(true);
        }
        windowCounter.increment();
        return metric;
    }

    public List<MetricSample> collect() {
        ArrayList<MetricSample> list = new ArrayList<MetricSample>();
        if (!this.isCollectEnabled()) {
            return list;
        }
        this.collectRequests(list);
        this.collectQPS(list);
        this.collectRT(list);
        return list;
    }

    private void collectRequests(List<MetricSample> list) {
        this.collectBySide(list, "provider");
        this.collectBySide(list, "consumer");
    }

    private void collectBySide(List<MetricSample> list, String side) {
        this.collectMethod(list, side, MetricsKey.METRIC_REQUESTS_TOTAL_AGG);
        this.collectMethod(list, side, MetricsKey.METRIC_REQUESTS_SUCCEED_AGG);
        this.collectMethod(list, side, MetricsKey.METRIC_REQUESTS_FAILED_AGG);
        this.collectMethod(list, side, MetricsKey.METRIC_REQUEST_BUSINESS_FAILED_AGG);
        this.collectMethod(list, side, MetricsKey.METRIC_REQUESTS_TIMEOUT_AGG);
        this.collectMethod(list, side, MetricsKey.METRIC_REQUESTS_LIMIT_AGG);
        this.collectMethod(list, side, MetricsKey.METRIC_REQUESTS_TOTAL_FAILED_AGG);
        this.collectMethod(list, side, MetricsKey.METRIC_REQUESTS_NETWORK_FAILED_AGG);
        this.collectMethod(list, side, MetricsKey.METRIC_REQUESTS_CODEC_FAILED_AGG);
        this.collectMethod(list, side, MetricsKey.METRIC_REQUESTS_TOTAL_SERVICE_UNAVAILABLE_FAILED_AGG);
    }

    private void collectMethod(List<MetricSample> list, String side, MetricsKey metricsKey) {
        MetricsKeyWrapper metricsKeyWrapper = new MetricsKeyWrapper(metricsKey, MetricsPlaceValue.of((String)side, (MetricsLevel)MetricsLevel.SERVICE));
        ConcurrentHashMap<MethodMetric, TimeWindowCounter> windowCounter = this.methodTypeCounter.get(metricsKeyWrapper);
        if (windowCounter != null) {
            windowCounter.forEach((k, v) -> list.add((MetricSample)new GaugeMetricSample(metricsKey.getNameByType(k.getSide()), metricsKey.getDescription(), k.getTags(), MetricsCategory.REQUESTS, v, TimeWindowCounter::get)));
        }
    }

    private void collectQPS(List<MetricSample> list) {
        this.qps.forEach((k, v) -> list.add((MetricSample)new GaugeMetricSample(MetricsKey.METRIC_QPS.getNameByType(k.getSide()), MetricsKey.METRIC_QPS.getDescription(), k.getTags(), MetricsCategory.QPS, v, value -> {
            double total = value.get();
            long millSeconds = value.bucketLivedMillSeconds();
            return total / (double)millSeconds * 1000.0;
        })));
    }

    private void collectRT(List<MetricSample> list) {
        this.rt.forEach((k, v) -> {
            list.add((MetricSample)new GaugeMetricSample(MetricsKey.METRIC_RT_P99.getNameByType(k.getSide()), MetricsKey.METRIC_RT_P99.getDescription(), k.getTags(), MetricsCategory.RT, v, value -> value.quantile(0.99)));
            list.add((MetricSample)new GaugeMetricSample(MetricsKey.METRIC_RT_P95.getNameByType(k.getSide()), MetricsKey.METRIC_RT_P95.getDescription(), k.getTags(), MetricsCategory.RT, v, value -> value.quantile(0.95)));
            list.add((MetricSample)new GaugeMetricSample(MetricsKey.METRIC_RT_P90.getNameByType(k.getSide()), MetricsKey.METRIC_RT_P90.getDescription(), k.getTags(), MetricsCategory.RT, v, value -> value.quantile(0.9)));
            list.add((MetricSample)new GaugeMetricSample(MetricsKey.METRIC_RT_P50.getNameByType(k.getSide()), MetricsKey.METRIC_RT_P50.getDescription(), k.getTags(), MetricsCategory.RT, v, value -> value.quantile(0.5)));
        });
        this.rtAgr.forEach((k, v) -> {
            list.add((MetricSample)new GaugeMetricSample(MetricsKey.METRIC_RT_MIN_AGG.getNameByType(k.getSide()), MetricsKey.METRIC_RT_MIN_AGG.getDescription(), k.getTags(), MetricsCategory.RT, v, value -> v.get().getMin()));
            list.add((MetricSample)new GaugeMetricSample(MetricsKey.METRIC_RT_MAX_AGG.getNameByType(k.getSide()), MetricsKey.METRIC_RT_MAX_AGG.getDescription(), k.getTags(), MetricsCategory.RT, v, value -> v.get().getMax()));
            list.add((MetricSample)new GaugeMetricSample(MetricsKey.METRIC_RT_AVG_AGG.getNameByType(k.getSide()), MetricsKey.METRIC_RT_AVG_AGG.getDescription(), k.getTags(), MetricsCategory.RT, v, value -> v.get().getAvg()));
        });
    }

    private void registerListener() {
        ((DefaultMetricsCollector)((Object)this.applicationModel.getBeanFactory().getBean(DefaultMetricsCollector.class))).getEventMulticaster().addListener((MetricsListener)this);
    }

    public void initMetrics(MetricsEvent event) {
        MethodMetric metric = new MethodMetric(this.applicationModel, (Invocation)event.getAttachmentValue("metric_filter_invocation"), this.serviceLevel);
        if (this.enableQps) {
            this.initMethodMetric(event);
            this.initQpsMetric(metric);
        }
        if (this.enableRt) {
            this.initRtMetric(metric);
        }
        if (this.enableRtPxx) {
            this.initRtAgrMetric(metric);
        }
    }

    public void initMethodMetric(MetricsEvent event) {
        DefaultConstants.INIT_AGG_METHOD_KEYS.stream().forEach(key -> this.initWindowCounter(event, (MetricsKey)key));
    }

    public void initQpsMetric(MethodMetric metric) {
        ConcurrentHashMapUtils.computeIfAbsent(this.qps, (Object)metric, methodMetric -> new TimeWindowCounter(this.bucketNum, (long)this.timeWindowSeconds));
        this.samplesChanged.set(true);
    }

    public void initRtMetric(MethodMetric metric) {
        ConcurrentHashMapUtils.computeIfAbsent(this.rt, (Object)metric, k -> new TimeWindowQuantile((double)DEFAULT_COMPRESSION.intValue(), this.bucketNum, this.timeWindowSeconds));
        this.samplesChanged.set(true);
    }

    public void initRtAgrMetric(MethodMetric metric) {
        ConcurrentHashMapUtils.computeIfAbsent(this.rtAgr, (Object)metric, k -> new TimeWindowAggregator(this.bucketNum, this.timeWindowSeconds));
        this.samplesChanged.set(true);
    }

    public void initWindowCounter(MetricsEvent event, MetricsKey targetKey) {
        MetricsKeyWrapper metricsKeyWrapper = new MetricsKeyWrapper(targetKey, MetricsPlaceValue.of((String)((String)event.getAttachmentValue("metric_filter_side")), (MetricsLevel)MetricsLevel.SERVICE));
        MethodMetric metric = new MethodMetric(this.applicationModel, (Invocation)event.getAttachmentValue("metric_filter_invocation"), this.serviceLevel);
        ConcurrentMap counter = (ConcurrentMap)ConcurrentHashMapUtils.computeIfAbsent(this.methodTypeCounter, (Object)metricsKeyWrapper, k -> new ConcurrentHashMap());
        ConcurrentHashMapUtils.computeIfAbsent((ConcurrentMap)counter, (Object)metric, methodMetric -> new TimeWindowCounter(this.bucketNum, (long)this.timeWindowSeconds));
        this.samplesChanged.set(true);
    }

    public boolean calSamplesChanged() {
        return this.samplesChanged.compareAndSet(true, false);
    }
}

