/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.metrics.aggregate;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.dubbo.common.utils.Assert;
import org.apache.dubbo.metrics.aggregate.Pane;

public abstract class SlidingWindow<T> {
    protected int paneCount;
    protected long intervalInMs;
    protected long paneIntervalInMs;
    protected final AtomicReferenceArray<Pane<T>> referenceArray;
    private final ReentrantLock updateLock = new ReentrantLock();

    protected SlidingWindow(int paneCount, long intervalInMs) {
        Assert.assertTrue((paneCount > 0 ? 1 : 0) != 0, (String)("pane count is invalid: " + paneCount));
        Assert.assertTrue((intervalInMs > 0L ? 1 : 0) != 0, (String)"total time interval of the sliding window should be positive");
        Assert.assertTrue((intervalInMs % (long)paneCount == 0L ? 1 : 0) != 0, (String)"total time interval needs to be evenly divided");
        this.paneCount = paneCount;
        this.intervalInMs = intervalInMs;
        this.paneIntervalInMs = intervalInMs / (long)paneCount;
        this.referenceArray = new AtomicReferenceArray(paneCount);
    }

    public Pane<T> currentPane() {
        return this.currentPane(System.currentTimeMillis());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Pane<T> currentPane(long timeMillis) {
        if (timeMillis < 0L) {
            return null;
        }
        int paneIdx = this.calculatePaneIdx(timeMillis);
        long paneStartInMs = this.calculatePaneStart(timeMillis);
        while (true) {
            Pane<T> oldPane;
            if ((oldPane = this.referenceArray.get(paneIdx)) == null) {
                Pane<T> pane = new Pane<T>(this.paneIntervalInMs, paneStartInMs, this.newEmptyValue(timeMillis));
                if (this.referenceArray.compareAndSet(paneIdx, null, pane)) {
                    return pane;
                }
                Thread.yield();
                continue;
            }
            if (paneStartInMs == oldPane.getStartInMs()) {
                return oldPane;
            }
            if (paneStartInMs > oldPane.getStartInMs()) {
                if (this.updateLock.tryLock()) {
                    try {
                        Pane<T> pane = this.resetPaneTo(oldPane, paneStartInMs);
                        return pane;
                    }
                    finally {
                        this.updateLock.unlock();
                    }
                }
                Thread.yield();
                continue;
            }
            if (paneStartInMs < oldPane.getStartInMs()) break;
        }
        return new Pane<T>(this.paneIntervalInMs, paneStartInMs, this.newEmptyValue(timeMillis));
    }

    public T getPaneValue(long timeMillis) {
        if (timeMillis < 0L) {
            return null;
        }
        int paneIdx = this.calculatePaneIdx(timeMillis);
        Pane<T> pane = this.referenceArray.get(paneIdx);
        if (pane == null || !pane.isTimeInWindow(timeMillis)) {
            return null;
        }
        return pane.getValue();
    }

    public abstract T newEmptyValue(long var1);

    protected abstract Pane<T> resetPaneTo(Pane<T> var1, long var2);

    private int calculatePaneIdx(long timeMillis) {
        return (int)(timeMillis / this.paneIntervalInMs % (long)this.paneCount);
    }

    protected long calculatePaneStart(long timeMillis) {
        return timeMillis - timeMillis % this.paneIntervalInMs;
    }

    public boolean isPaneDeprecated(Pane<T> pane) {
        return this.isPaneDeprecated(System.currentTimeMillis(), pane);
    }

    public boolean isPaneDeprecated(long timeMillis, Pane<T> pane) {
        return timeMillis - pane.getStartInMs() > this.intervalInMs;
    }

    public List<Pane<T>> list() {
        return this.list(System.currentTimeMillis());
    }

    public List<Pane<T>> list(long timeMillis) {
        if (timeMillis < 0L) {
            return new ArrayList<Pane<T>>();
        }
        ArrayList<Pane<T>> result = new ArrayList<Pane<T>>(this.paneCount);
        for (int idx = 0; idx < this.paneCount; ++idx) {
            Pane<T> pane = this.referenceArray.get(idx);
            if (pane == null || this.isPaneDeprecated(timeMillis, pane)) continue;
            result.add(pane);
        }
        return result;
    }

    public List<T> values() {
        return this.values(System.currentTimeMillis());
    }

    public List<T> values(long timeMillis) {
        if (timeMillis < 0L) {
            return new ArrayList();
        }
        ArrayList<T> result = new ArrayList<T>(this.paneCount);
        for (int idx = 0; idx < this.paneCount; ++idx) {
            Pane<T> pane = this.referenceArray.get(idx);
            if (pane == null || this.isPaneDeprecated(timeMillis, pane)) continue;
            result.add(pane.getValue());
        }
        return result;
    }

    public long getIntervalInMs() {
        return this.intervalInMs;
    }

    public long getPaneIntervalInMs() {
        return this.paneIntervalInMs;
    }
}

