/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.metadata.annotation.processing.util;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.TypeElement;
import org.apache.dubbo.metadata.annotation.processing.util.AnnotationUtils;

public interface ServiceAnnotationUtils {
    @Deprecated
    public static final String SERVICE_ANNOTATION_TYPE = "org.apache.dubbo.config.annotation.Service";
    @Deprecated
    public static final String LEGACY_SERVICE_ANNOTATION_TYPE = "com.alibaba.dubbo.config.annotation.Service";
    public static final String DUBBO_SERVICE_ANNOTATION_TYPE = "org.apache.dubbo.config.annotation.DubboService";
    public static final String INTERFACE_CLASS_ATTRIBUTE_NAME = "interfaceClass";
    public static final String INTERFACE_NAME_ATTRIBUTE_NAME = "interfaceName";
    public static final String GROUP_ATTRIBUTE_NAME = "group";
    public static final String VERSION_ATTRIBUTE_NAME = "version";
    public static final Set<String> SUPPORTED_ANNOTATION_TYPES = Collections.unmodifiableSet(new LinkedHashSet<String>(Arrays.asList("org.apache.dubbo.config.annotation.DubboService", "org.apache.dubbo.config.annotation.Service", "com.alibaba.dubbo.config.annotation.Service")));

    public static boolean isServiceAnnotationPresent(TypeElement annotatedType) {
        return SUPPORTED_ANNOTATION_TYPES.stream().filter(type -> AnnotationUtils.isAnnotationPresent(annotatedType, type)).findFirst().isPresent();
    }

    public static AnnotationMirror getAnnotation(TypeElement annotatedClass) {
        return ServiceAnnotationUtils.getAnnotation(annotatedClass.getAnnotationMirrors());
    }

    public static AnnotationMirror getAnnotation(Iterable<? extends AnnotationMirror> annotationMirrors) {
        AnnotationMirror matchedAnnotationMirror = null;
        block0: for (String supportedAnnotationType : SUPPORTED_ANNOTATION_TYPES) {
            for (AnnotationMirror annotationMirror : annotationMirrors) {
                String annotationType = annotationMirror.getAnnotationType().toString();
                if (!Objects.equals(supportedAnnotationType, annotationType)) continue;
                matchedAnnotationMirror = annotationMirror;
                break block0;
            }
        }
        if (matchedAnnotationMirror == null) {
            throw new IllegalArgumentException("The annotated element must be annotated any of " + SUPPORTED_ANNOTATION_TYPES);
        }
        return matchedAnnotationMirror;
    }

    public static String resolveServiceInterfaceName(TypeElement annotatedClass, AnnotationMirror serviceAnnotation) {
        Object interfaceClass = AnnotationUtils.getAttribute(serviceAnnotation, INTERFACE_CLASS_ATTRIBUTE_NAME);
        if (interfaceClass == null) {
            interfaceClass = AnnotationUtils.getAttribute(serviceAnnotation, INTERFACE_NAME_ATTRIBUTE_NAME);
        }
        if (interfaceClass == null) {
            interfaceClass = annotatedClass.getInterfaces().get(0);
        }
        return String.valueOf(interfaceClass);
    }

    public static String getGroup(AnnotationMirror serviceAnnotation) {
        return (String)AnnotationUtils.getAttribute(serviceAnnotation, GROUP_ATTRIBUTE_NAME);
    }

    public static String getVersion(AnnotationMirror serviceAnnotation) {
        return (String)AnnotationUtils.getAttribute(serviceAnnotation, VERSION_ATTRIBUTE_NAME);
    }
}

