/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.metadata.definition.builder;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Map;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.metadata.definition.TypeDefinitionBuilder;
import org.apache.dubbo.metadata.definition.builder.TypeBuilder;
import org.apache.dubbo.metadata.definition.model.TypeDefinition;

public class EnumTypeBuilder
implements TypeBuilder {
    private static final Logger logger = LoggerFactory.getLogger(TypeDefinitionBuilder.class);

    @Override
    public boolean accept(Class<?> clazz) {
        if (clazz == null) {
            return false;
        }
        return clazz.isEnum();
    }

    @Override
    public TypeDefinition build(Type type, Class<?> clazz, Map<String, TypeDefinition> typeCache) {
        String canonicalName = clazz.getCanonicalName();
        TypeDefinition td = typeCache.get(canonicalName);
        if (td != null) {
            return td;
        }
        td = new TypeDefinition(canonicalName);
        typeCache.put(canonicalName, td);
        try {
            Method methodValues = clazz.getDeclaredMethod("values", new Class[0]);
            methodValues.setAccessible(true);
            for (Object value : (Object[])methodValues.invoke(clazz, new Object[0])) {
                td.getEnums().add(value.toString());
            }
            return td;
        }
        catch (Throwable t) {
            logger.error("There is an error while process class " + clazz, t);
            return td;
        }
    }
}

