/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.metadata;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import org.apache.dubbo.common.config.configcenter.DynamicConfiguration;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.metadata.MetadataService;
import org.apache.dubbo.metadata.ServiceNameMapping;
import org.apache.dubbo.rpc.model.ApplicationModel;

public class DynamicConfigurationServiceNameMapping
implements ServiceNameMapping {
    public static String DEFAULT_MAPPING_GROUP = "mapping";
    private static final List<String> IGNORED_SERVICE_INTERFACES = Arrays.asList(MetadataService.class.getName());
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public void map(String serviceInterface, String group, String version, String protocol) {
        if (IGNORED_SERVICE_INTERFACES.contains(serviceInterface)) {
            return;
        }
        DynamicConfiguration dynamicConfiguration = DynamicConfiguration.getDynamicConfiguration();
        String key = ApplicationModel.getName();
        String content = String.valueOf(System.currentTimeMillis());
        this.execute(() -> {
            dynamicConfiguration.publishConfig(key, DynamicConfigurationServiceNameMapping.buildGroup(serviceInterface, group, version, protocol), content);
            if (this.logger.isInfoEnabled()) {
                this.logger.info(String.format("Dubbo service[%s] mapped to interface name[%s].", group, serviceInterface, group));
            }
        });
    }

    @Override
    public Set<String> get(String serviceInterface, String group, String version, String protocol) {
        DynamicConfiguration dynamicConfiguration = DynamicConfiguration.getDynamicConfiguration();
        LinkedHashSet serviceNames = new LinkedHashSet();
        this.execute(() -> {
            SortedSet keys = dynamicConfiguration.getConfigKeys(DynamicConfigurationServiceNameMapping.buildGroup(serviceInterface, group, version, protocol));
            serviceNames.addAll(keys);
        });
        return Collections.unmodifiableSet(serviceNames);
    }

    protected static String buildGroup(String serviceInterface, String group, String version, String protocol) {
        return DEFAULT_MAPPING_GROUP + StringUtils.SLASH + serviceInterface;
    }

    private void execute(Runnable runnable) {
        block2: {
            try {
                runnable.run();
            }
            catch (Throwable e) {
                if (!this.logger.isWarnEnabled()) break block2;
                this.logger.warn(e.getMessage(), e);
            }
        }
    }
}

