/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.metadata.report.identifier;

import org.apache.dubbo.common.utils.PathUtils;
import org.apache.dubbo.metadata.report.identifier.KeyTypeEnum;

public class BaseApplicationMetadataIdentifier {
    String application;

    String getUniqueKey(KeyTypeEnum keyType, String ... params) {
        if (keyType == KeyTypeEnum.PATH) {
            return this.getFilePathKey(params);
        }
        return this.getIdentifierKey(params);
    }

    String getIdentifierKey(String ... params) {
        return this.application + this.joinParams(":", params);
    }

    private String joinParams(String joinChar, String ... params) {
        if (params == null || params.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (String param : params) {
            sb.append(joinChar);
            sb.append(param);
        }
        return sb.toString();
    }

    private String getFilePathKey(String ... params) {
        return this.getFilePathKey("metadata", params);
    }

    private String getFilePathKey(String pathTag, String ... params) {
        return PathUtils.buildPath((String)pathTag, (String[])new String[]{this.application, this.joinParams("/", params)});
    }
}

