/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.config.spring6.beans.factory.aot;

import java.lang.reflect.Field;
import java.util.LinkedHashSet;
import org.apache.dubbo.config.spring6.beans.factory.aot.AutowiredElementResolver;
import org.springframework.beans.BeansException;
import org.springframework.beans.TypeConverter;
import org.springframework.beans.factory.InjectionPoint;
import org.springframework.beans.factory.UnsatisfiedDependencyException;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.DependencyDescriptor;
import org.springframework.beans.factory.support.RegisteredBean;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.function.ThrowingConsumer;

public final class ReferencedFieldValueResolver
extends AutowiredElementResolver {
    private final String fieldName;
    private final boolean required;
    @Nullable
    private final String shortcut;

    private ReferencedFieldValueResolver(String fieldName, boolean required, @Nullable String shortcut) {
        Assert.hasText((String)fieldName, (String)"'fieldName' must not be empty");
        this.fieldName = fieldName;
        this.required = required;
        this.shortcut = shortcut;
    }

    public static ReferencedFieldValueResolver forField(String fieldName) {
        return new ReferencedFieldValueResolver(fieldName, false, null);
    }

    public static ReferencedFieldValueResolver forRequiredField(String fieldName) {
        return new ReferencedFieldValueResolver(fieldName, true, null);
    }

    public ReferencedFieldValueResolver withShortcut(String beanName) {
        return new ReferencedFieldValueResolver(this.fieldName, this.required, beanName);
    }

    public <T> void resolve(RegisteredBean registeredBean, ThrowingConsumer<T> action) {
        Assert.notNull((Object)registeredBean, (String)"'registeredBean' must not be null");
        Assert.notNull(action, (String)"'action' must not be null");
        T resolved = this.resolve(registeredBean);
        if (resolved != null) {
            action.accept(resolved);
        }
    }

    @Nullable
    public <T> T resolve(RegisteredBean registeredBean, Class<T> requiredType) {
        Object value = this.resolveObject(registeredBean);
        Assert.isInstanceOf(requiredType, (Object)value);
        return (T)value;
    }

    @Nullable
    public <T> T resolve(RegisteredBean registeredBean) {
        return (T)this.resolveObject(registeredBean);
    }

    @Nullable
    public Object resolveObject(RegisteredBean registeredBean) {
        Assert.notNull((Object)registeredBean, (String)"'registeredBean' must not be null");
        return this.resolveValue(registeredBean, this.getField(registeredBean));
    }

    public void resolveAndSet(RegisteredBean registeredBean, Object instance) {
        Assert.notNull((Object)registeredBean, (String)"'registeredBean' must not be null");
        Assert.notNull((Object)instance, (String)"'instance' must not be null");
        Field field = this.getField(registeredBean);
        Object resolved = this.resolveValue(registeredBean, field);
        if (resolved != null) {
            ReflectionUtils.makeAccessible((Field)field);
            ReflectionUtils.setField((Field)field, (Object)instance, (Object)resolved);
        }
    }

    @Nullable
    private Object resolveValue(RegisteredBean registeredBean, Field field) {
        String beanName = registeredBean.getBeanName();
        Class beanClass = registeredBean.getBeanClass();
        ConfigurableListableBeanFactory beanFactory = registeredBean.getBeanFactory();
        DependencyDescriptor descriptor = new DependencyDescriptor(field, this.required);
        descriptor.setContainingClass(beanClass);
        if (this.shortcut != null) {
            descriptor = new AutowiredElementResolver.ShortcutDependencyDescriptor(descriptor, this.shortcut, field.getType());
        }
        LinkedHashSet<String> autowiredBeanNames = new LinkedHashSet<String>(1);
        TypeConverter typeConverter = beanFactory.getTypeConverter();
        try {
            Assert.isInstanceOf(AutowireCapableBeanFactory.class, (Object)beanFactory);
            Object injectedObject = beanFactory.getBean(this.shortcut);
            Object value = ((AutowireCapableBeanFactory)beanFactory).resolveDependency(descriptor, beanName, autowiredBeanNames, typeConverter);
            this.registerDependentBeans((ConfigurableBeanFactory)beanFactory, beanName, autowiredBeanNames);
            return injectedObject;
        }
        catch (BeansException ex) {
            throw new UnsatisfiedDependencyException(null, beanName, new InjectionPoint(field), ex);
        }
    }

    private Field getField(RegisteredBean registeredBean) {
        Field field = ReflectionUtils.findField((Class)registeredBean.getBeanClass(), (String)this.fieldName);
        Assert.notNull((Object)field, () -> "No field '" + this.fieldName + "' found on " + registeredBean.getBeanClass().getName());
        return field;
    }
}

