/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.config.spring.context.annotation;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.dubbo.config.spring.context.annotation.ConfigurationBeanBindingPostProcessor;
import org.apache.dubbo.config.spring.context.annotation.EnableConfigurationBeanBinding;
import org.apache.dubbo.config.spring.util.AnnotationUtils;
import org.apache.dubbo.config.spring.util.DubboBeanUtils;
import org.apache.dubbo.config.spring.util.PropertySourcesUtils;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertyResolver;
import org.springframework.core.env.PropertySource;
import org.springframework.core.env.PropertySources;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class ConfigurationBeanBindingRegistrar
implements ImportBeanDefinitionRegistrar,
EnvironmentAware {
    static final Class ENABLE_CONFIGURATION_BINDING_CLASS = EnableConfigurationBeanBinding.class;
    private static final String ENABLE_CONFIGURATION_BINDING_CLASS_NAME = ENABLE_CONFIGURATION_BINDING_CLASS.getName();
    private final Log log = LogFactory.getLog(this.getClass());
    private ConfigurableEnvironment environment;

    public void registerBeanDefinitions(AnnotationMetadata metadata, BeanDefinitionRegistry registry) {
        Map attributes = metadata.getAnnotationAttributes(ENABLE_CONFIGURATION_BINDING_CLASS_NAME);
        this.registerConfigurationBeanDefinitions(attributes, registry);
    }

    public void registerConfigurationBeanDefinitions(Map<String, Object> attributes, BeanDefinitionRegistry registry) {
        String prefix = (String)AnnotationUtils.getRequiredAttribute(attributes, "prefix");
        prefix = this.environment.resolvePlaceholders(prefix);
        Class configClass = (Class)AnnotationUtils.getRequiredAttribute(attributes, "type");
        boolean multiple = AnnotationUtils.getAttribute(attributes, "multiple", Boolean.valueOf(false));
        boolean ignoreUnknownFields = AnnotationUtils.getAttribute(attributes, "ignoreUnknownFields", Boolean.valueOf(true));
        boolean ignoreInvalidFields = AnnotationUtils.getAttribute(attributes, "ignoreInvalidFields", Boolean.valueOf(true));
        this.registerConfigurationBeans(prefix, configClass, multiple, ignoreUnknownFields, ignoreInvalidFields, registry);
    }

    private void registerConfigurationBeans(String prefix, Class<?> configClass, boolean multiple, boolean ignoreUnknownFields, boolean ignoreInvalidFields, BeanDefinitionRegistry registry) {
        Map<String, Object> configurationProperties = PropertySourcesUtils.getSubProperties((PropertySources)this.environment.getPropertySources(), (PropertyResolver)this.environment, prefix);
        if (CollectionUtils.isEmpty(configurationProperties)) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("There is no property for binding to configuration class [" + configClass.getName() + "] within prefix [" + prefix + "]"));
            }
            return;
        }
        Set<String> beanNames = multiple ? this.resolveMultipleBeanNames(configurationProperties) : Collections.singleton(this.resolveSingleBeanName(configurationProperties, configClass, registry));
        for (String beanName : beanNames) {
            this.registerConfigurationBean(beanName, configClass, multiple, ignoreUnknownFields, ignoreInvalidFields, configurationProperties, registry);
        }
        this.registerConfigurationBindingBeanPostProcessor(registry);
    }

    private void registerConfigurationBean(String beanName, Class<?> configClass, boolean multiple, boolean ignoreUnknownFields, boolean ignoreInvalidFields, Map<String, Object> configurationProperties, BeanDefinitionRegistry registry) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition(configClass);
        AbstractBeanDefinition beanDefinition = builder.getBeanDefinition();
        this.setSource(beanDefinition);
        Map<String, Object> subProperties = this.resolveSubProperties(multiple, beanName, configurationProperties);
        ConfigurationBeanBindingPostProcessor.initBeanMetadataAttributes(beanDefinition, subProperties, ignoreUnknownFields, ignoreInvalidFields);
        registry.registerBeanDefinition(beanName, (BeanDefinition)beanDefinition);
        if (this.log.isInfoEnabled()) {
            this.log.info((Object)("The configuration bean definition [name : " + beanName + ", content : " + beanDefinition + "] has been registered."));
        }
    }

    private Map<String, Object> resolveSubProperties(boolean multiple, String beanName, Map<String, Object> configurationProperties) {
        if (!multiple) {
            return configurationProperties;
        }
        MutablePropertySources propertySources = new MutablePropertySources();
        propertySources.addLast((PropertySource)new MapPropertySource("_", configurationProperties));
        return PropertySourcesUtils.getSubProperties((PropertySources)propertySources, (PropertyResolver)this.environment, PropertySourcesUtils.normalizePrefix(beanName));
    }

    private void setSource(AbstractBeanDefinition beanDefinition) {
        beanDefinition.setSource((Object)ENABLE_CONFIGURATION_BINDING_CLASS);
    }

    private void registerConfigurationBindingBeanPostProcessor(BeanDefinitionRegistry registry) {
        DubboBeanUtils.registerInfrastructureBean(registry, "configurationBeanBindingPostProcessor", ConfigurationBeanBindingPostProcessor.class);
    }

    public void setEnvironment(Environment environment) {
        Assert.isInstanceOf(ConfigurableEnvironment.class, (Object)environment);
        this.environment = (ConfigurableEnvironment)environment;
    }

    private Set<String> resolveMultipleBeanNames(Map<String, Object> properties) {
        LinkedHashSet<String> beanNames = new LinkedHashSet<String>();
        for (String propertyName : properties.keySet()) {
            int index = propertyName.indexOf(".");
            if (index <= 0) continue;
            String beanName = propertyName.substring(0, index);
            beanNames.add(beanName);
        }
        return beanNames;
    }

    private String resolveSingleBeanName(Map<String, Object> properties, Class<?> configClass, BeanDefinitionRegistry registry) {
        String beanName = (String)properties.get("id");
        if (!StringUtils.hasText((String)beanName)) {
            BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition(configClass);
            beanName = BeanDefinitionReaderUtils.generateBeanName((BeanDefinition)builder.getRawBeanDefinition(), (BeanDefinitionRegistry)registry);
        }
        return beanName;
    }
}

