/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.config.deploy;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.config.ConfigurationUtils;
import org.apache.dubbo.common.config.Environment;
import org.apache.dubbo.common.config.ReferenceCache;
import org.apache.dubbo.common.config.configcenter.ConfigChangeType;
import org.apache.dubbo.common.config.configcenter.DynamicConfiguration;
import org.apache.dubbo.common.config.configcenter.DynamicConfigurationFactory;
import org.apache.dubbo.common.config.configcenter.wrapper.CompositeDynamicConfiguration;
import org.apache.dubbo.common.constants.CommonConstants;
import org.apache.dubbo.common.deploy.AbstractDeployer;
import org.apache.dubbo.common.deploy.ApplicationDeployListener;
import org.apache.dubbo.common.deploy.ApplicationDeployer;
import org.apache.dubbo.common.deploy.DeployListener;
import org.apache.dubbo.common.deploy.DeployState;
import org.apache.dubbo.common.deploy.ModuleDeployer;
import org.apache.dubbo.common.extension.ExtensionAccessor;
import org.apache.dubbo.common.extension.ExtensionLoader;
import org.apache.dubbo.common.lang.ShutdownHookCallbacks;
import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.threadpool.manager.ExecutorRepository;
import org.apache.dubbo.common.threadpool.manager.FrameworkExecutorRepository;
import org.apache.dubbo.common.utils.ArrayUtils;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.config.AbstractConfig;
import org.apache.dubbo.config.ApplicationConfig;
import org.apache.dubbo.config.ConfigCenterConfig;
import org.apache.dubbo.config.DubboShutdownHook;
import org.apache.dubbo.config.MetadataReportConfig;
import org.apache.dubbo.config.MetricsConfig;
import org.apache.dubbo.config.RegistryConfig;
import org.apache.dubbo.config.TracingConfig;
import org.apache.dubbo.config.context.ConfigManager;
import org.apache.dubbo.config.utils.CompositeReferenceCache;
import org.apache.dubbo.config.utils.ConfigValidationUtils;
import org.apache.dubbo.metadata.report.MetadataReportFactory;
import org.apache.dubbo.metadata.report.MetadataReportInstance;
import org.apache.dubbo.metrics.collector.DefaultMetricsCollector;
import org.apache.dubbo.metrics.config.event.ConfigCenterEvent;
import org.apache.dubbo.metrics.event.MetricsEvent;
import org.apache.dubbo.metrics.event.MetricsEventBus;
import org.apache.dubbo.metrics.report.DefaultMetricsReporterFactory;
import org.apache.dubbo.metrics.report.MetricsReporter;
import org.apache.dubbo.metrics.report.MetricsReporterFactory;
import org.apache.dubbo.metrics.service.MetricsServiceExporter;
import org.apache.dubbo.metrics.utils.MetricsSupportUtil;
import org.apache.dubbo.registry.Registry;
import org.apache.dubbo.registry.RegistryFactory;
import org.apache.dubbo.registry.client.metadata.ServiceInstanceMetadataUtils;
import org.apache.dubbo.registry.support.RegistryManager;
import org.apache.dubbo.rpc.model.ApplicationModel;
import org.apache.dubbo.rpc.model.ModuleModel;
import org.apache.dubbo.rpc.model.ModuleServiceRepository;
import org.apache.dubbo.rpc.model.ProviderModel;
import org.apache.dubbo.rpc.model.ScopeModel;
import org.apache.dubbo.rpc.model.ScopeModelUtil;
import org.apache.dubbo.tracing.DubboObservationRegistry;
import org.apache.dubbo.tracing.utils.ObservationSupportUtil;

public class DefaultApplicationDeployer
extends AbstractDeployer<ApplicationModel>
implements ApplicationDeployer {
    private static final ErrorTypeAwareLogger logger = LoggerFactory.getErrorTypeAwareLogger(DefaultApplicationDeployer.class);
    private final ApplicationModel applicationModel;
    private final ConfigManager configManager;
    private final Environment environment;
    private final ReferenceCache referenceCache;
    private final FrameworkExecutorRepository frameworkExecutorRepository;
    private final ExecutorRepository executorRepository;
    private final AtomicBoolean hasPreparedApplicationInstance = new AtomicBoolean(false);
    private volatile boolean hasPreparedInternalModule = false;
    private ScheduledFuture<?> asyncMetadataFuture;
    private volatile CompletableFuture<Boolean> startFuture;
    private final DubboShutdownHook dubboShutdownHook;
    private volatile MetricsServiceExporter metricsServiceExporter;
    private final Object stateLock = new Object();
    private final Object startLock = new Object();
    private final Object destroyLock = new Object();
    private final Object internalModuleLock = new Object();
    private volatile boolean registered;
    private final AtomicInteger instanceRefreshScheduleTimes = new AtomicInteger(0);
    private final AtomicInteger serviceRefreshState = new AtomicInteger(0);

    public DefaultApplicationDeployer(ApplicationModel applicationModel) {
        super((ScopeModel)applicationModel);
        this.applicationModel = applicationModel;
        this.configManager = applicationModel.getApplicationConfigManager();
        this.environment = applicationModel.modelEnvironment();
        this.referenceCache = new CompositeReferenceCache(applicationModel);
        this.frameworkExecutorRepository = (FrameworkExecutorRepository)applicationModel.getFrameworkModel().getBeanFactory().getBean(FrameworkExecutorRepository.class);
        this.executorRepository = ExecutorRepository.getInstance((ApplicationModel)applicationModel);
        this.dubboShutdownHook = new DubboShutdownHook(applicationModel);
        Set deployListeners = applicationModel.getExtensionLoader(ApplicationDeployListener.class).getSupportedExtensionInstances();
        for (ApplicationDeployListener listener : deployListeners) {
            this.addDeployListener((DeployListener)listener);
        }
    }

    public static ApplicationDeployer get(ScopeModel moduleOrApplicationModel) {
        ApplicationModel applicationModel = ScopeModelUtil.getApplicationModel((ScopeModel)moduleOrApplicationModel);
        ApplicationDeployer applicationDeployer = applicationModel.getDeployer();
        if (applicationDeployer == null) {
            applicationDeployer = (ApplicationDeployer)applicationModel.getBeanFactory().getOrRegisterBean(DefaultApplicationDeployer.class);
        }
        return applicationDeployer;
    }

    public ApplicationModel getApplicationModel() {
        return this.applicationModel;
    }

    private <T> ExtensionLoader<T> getExtensionLoader(Class<T> type) {
        return this.applicationModel.getExtensionLoader(type);
    }

    private void unRegisterShutdownHook() {
        this.dubboShutdownHook.unregister();
    }

    private boolean isRegisterConsumerInstance() {
        Boolean registerConsumer = this.getApplicationOrElseThrow().getRegisterConsumer();
        if (registerConsumer == null) {
            return false;
        }
        return Boolean.TRUE.equals(registerConsumer);
    }

    public ReferenceCache getReferenceCache() {
        return this.referenceCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize() {
        if (this.initialized) {
            return;
        }
        Object object = this.startLock;
        synchronized (object) {
            if (this.initialized) {
                return;
            }
            this.onInitialize();
            this.registerShutdownHook();
            this.startConfigCenter();
            this.loadApplicationConfigs();
            this.initModuleDeployers();
            this.initMetricsReporter();
            this.initMetricsService();
            this.initObservationRegistry();
            this.startMetadataCenter();
            this.initialized = true;
            if (logger.isInfoEnabled()) {
                logger.info(this.getIdentifier() + " has been initialized!");
            }
        }
    }

    private void registerShutdownHook() {
        this.dubboShutdownHook.register();
    }

    private void initModuleDeployers() {
        this.applicationModel.getDefaultModule();
        for (ModuleModel moduleModel : this.applicationModel.getModuleModels()) {
            moduleModel.getDeployer().initialize();
        }
    }

    private void loadApplicationConfigs() {
        this.configManager.loadConfigs();
    }

    private void startConfigCenter() {
        this.configManager.loadConfigsOfTypeFromProps(ApplicationConfig.class);
        if (StringUtils.isBlank((CharSequence)this.applicationModel.getModelName())) {
            this.applicationModel.setModelName(this.applicationModel.tryGetApplicationName());
        }
        this.configManager.loadConfigsOfTypeFromProps(ConfigCenterConfig.class);
        this.useRegistryAsConfigCenterIfNecessary();
        Collection configCenters = this.configManager.getConfigCenters();
        if (CollectionUtils.isEmpty((Collection)configCenters)) {
            ConfigCenterConfig configCenterConfig = new ConfigCenterConfig();
            configCenterConfig.setScopeModel((ScopeModel)this.applicationModel);
            configCenterConfig.refresh();
            ConfigValidationUtils.validateConfigCenterConfig(configCenterConfig);
            if (configCenterConfig.isValid()) {
                this.configManager.addConfigCenter(configCenterConfig);
                configCenters = this.configManager.getConfigCenters();
            }
        } else {
            for (ConfigCenterConfig configCenterConfig : configCenters) {
                configCenterConfig.refresh();
                ConfigValidationUtils.validateConfigCenterConfig(configCenterConfig);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)configCenters)) {
            CompositeDynamicConfiguration compositeDynamicConfiguration = new CompositeDynamicConfiguration();
            for (ConfigCenterConfig configCenter : configCenters) {
                this.environment.updateExternalConfigMap(configCenter.getExternalConfiguration());
                this.environment.updateAppExternalConfigMap(configCenter.getAppExternalConfiguration());
                compositeDynamicConfiguration.addConfiguration(this.prepareEnvironment(configCenter));
            }
            this.environment.setDynamicConfiguration((DynamicConfiguration)compositeDynamicConfiguration);
        }
    }

    private void startMetadataCenter() {
        this.useRegistryAsMetadataCenterIfNecessary();
        ApplicationConfig applicationConfig = this.getApplicationOrElseThrow();
        String metadataType = applicationConfig.getMetadataType();
        Collection metadataReportConfigs = this.configManager.getMetadataConfigs();
        if (CollectionUtils.isEmpty((Collection)metadataReportConfigs)) {
            if ("remote".equals(metadataType)) {
                throw new IllegalStateException("No MetadataConfig found, Metadata Center address is required when 'metadata=remote' is enabled.");
            }
            return;
        }
        MetadataReportInstance metadataReportInstance = (MetadataReportInstance)this.applicationModel.getBeanFactory().getBean(MetadataReportInstance.class);
        ArrayList<MetadataReportConfig> validMetadataReportConfigs = new ArrayList<MetadataReportConfig>(metadataReportConfigs.size());
        for (MetadataReportConfig metadataReportConfig : metadataReportConfigs) {
            if (!ConfigValidationUtils.isValidMetadataConfig(metadataReportConfig)) continue;
            ConfigValidationUtils.validateMetadataConfig(metadataReportConfig);
            validMetadataReportConfigs.add(metadataReportConfig);
        }
        metadataReportInstance.init(validMetadataReportConfigs);
        if (!metadataReportInstance.inited()) {
            throw new IllegalStateException(String.format("%s MetadataConfigs found, but none of them is valid.", metadataReportConfigs.size()));
        }
    }

    private void useRegistryAsConfigCenterIfNecessary() {
        if (this.environment.getDynamicConfiguration().isPresent()) {
            return;
        }
        if (CollectionUtils.isNotEmpty((Collection)this.configManager.getConfigCenters())) {
            return;
        }
        this.configManager.loadConfigsOfTypeFromProps(RegistryConfig.class);
        List defaultRegistries = this.configManager.getDefaultRegistries();
        if (!defaultRegistries.isEmpty()) {
            defaultRegistries.stream().filter(this::isUsedRegistryAsConfigCenter).map(this::registryAsConfigCenter).forEach(configCenter -> {
                if (this.configManager.getConfigCenter(configCenter.getId()).isPresent()) {
                    return;
                }
                this.configManager.addConfigCenter(configCenter);
                logger.info("use registry as config-center: " + configCenter);
            });
        }
    }

    private void initMetricsService() {
        this.metricsServiceExporter = (MetricsServiceExporter)this.getExtensionLoader(MetricsServiceExporter.class).getDefaultExtension();
        this.metricsServiceExporter.init();
    }

    private void initMetricsReporter() {
        if (!MetricsSupportUtil.isSupportMetrics()) {
            return;
        }
        DefaultMetricsCollector collector = (DefaultMetricsCollector)this.applicationModel.getBeanFactory().getBean(DefaultMetricsCollector.class);
        Optional configOptional = this.configManager.getMetrics();
        MetricsConfig metricsConfig = configOptional.orElse(new MetricsConfig(this.applicationModel));
        if (StringUtils.isBlank((CharSequence)metricsConfig.getProtocol())) {
            metricsConfig.setProtocol(MetricsSupportUtil.isSupportPrometheus() ? "prometheus" : "default");
        }
        collector.setCollectEnabled(Boolean.valueOf(true));
        collector.collectApplication();
        collector.setThreadpoolCollectEnabled(Optional.ofNullable(metricsConfig.getEnableThreadpool()).orElse(true).booleanValue());
        collector.setMetricsInitEnabled(Optional.ofNullable(metricsConfig.getEnableMetricsInit()).orElse(true).booleanValue());
        MetricsReporterFactory metricsReporterFactory = (MetricsReporterFactory)this.getExtensionLoader(MetricsReporterFactory.class).getAdaptiveExtension();
        MetricsReporter metricsReporter = null;
        try {
            metricsReporter = metricsReporterFactory.createMetricsReporter(metricsConfig.toUrl());
        }
        catch (IllegalStateException e) {
            if (e.getMessage().startsWith("No such extension org.apache.dubbo.metrics.report.MetricsReporterFactory")) {
                logger.warn("0-13", "", "", e.getMessage());
                return;
            }
            throw e;
        }
        metricsReporter.init();
        this.applicationModel.getBeanFactory().registerBean((Object)metricsReporter);
        if (!"default".equals(metricsConfig.getProtocol())) {
            DefaultMetricsReporterFactory defaultMetricsReporterFactory = new DefaultMetricsReporterFactory(this.applicationModel);
            MetricsReporter defaultMetricsReporter = defaultMetricsReporterFactory.createMetricsReporter(metricsConfig.toUrl());
            defaultMetricsReporter.init();
            this.applicationModel.getBeanFactory().registerBean((Object)defaultMetricsReporter);
        }
    }

    private void initObservationRegistry() {
        if (!ObservationSupportUtil.isSupportObservation()) {
            if (logger.isDebugEnabled()) {
                logger.debug("Not found micrometer-observation or plz check the version of micrometer-observation version if already introduced, need > 1.10.0");
            }
            return;
        }
        if (!ObservationSupportUtil.isSupportTracing()) {
            if (logger.isDebugEnabled()) {
                logger.debug("Not found micrometer-tracing dependency, skip init ObservationRegistry.");
            }
            return;
        }
        Optional configOptional = this.configManager.getTracing();
        if (!configOptional.isPresent() || !((TracingConfig)configOptional.get()).getEnabled().booleanValue()) {
            return;
        }
        DubboObservationRegistry dubboObservationRegistry = new DubboObservationRegistry(this.applicationModel, (TracingConfig)configOptional.get());
        dubboObservationRegistry.initObservationRegistry();
    }

    private boolean isUsedRegistryAsConfigCenter(RegistryConfig registryConfig) {
        return this.isUsedRegistryAsCenter(registryConfig, () -> ((RegistryConfig)registryConfig).getUseAsConfigCenter(), "config", DynamicConfigurationFactory.class);
    }

    private ConfigCenterConfig registryAsConfigCenter(RegistryConfig registryConfig) {
        String protocol = registryConfig.getProtocol();
        Integer port = registryConfig.getPort();
        URL url = URL.valueOf((String)registryConfig.getAddress(), (ScopeModel)registryConfig.getScopeModel());
        String id = "config-center-" + protocol + "-" + url.getHost() + "-" + port;
        ConfigCenterConfig cc = new ConfigCenterConfig();
        cc.setId(id);
        cc.setScopeModel((ScopeModel)this.applicationModel);
        if (cc.getParameters() == null) {
            cc.setParameters(new HashMap());
        }
        if (CollectionUtils.isNotEmptyMap((Map)registryConfig.getParameters())) {
            cc.getParameters().putAll(registryConfig.getParameters());
        }
        cc.getParameters().put("client", registryConfig.getClient());
        cc.setProtocol(protocol);
        cc.setPort(port);
        if (StringUtils.isNotEmpty((String)registryConfig.getGroup())) {
            cc.setGroup(registryConfig.getGroup());
        }
        cc.setAddress(this.getRegistryCompatibleAddress(registryConfig));
        cc.setNamespace(registryConfig.getGroup());
        cc.setUsername(registryConfig.getUsername());
        cc.setPassword(registryConfig.getPassword());
        if (registryConfig.getTimeout() != null) {
            cc.setTimeout(Long.valueOf(registryConfig.getTimeout().longValue()));
        }
        cc.setHighestPriority(Boolean.valueOf(false));
        return cc;
    }

    private void useRegistryAsMetadataCenterIfNecessary() {
        Collection originMetadataConfigs = this.configManager.getMetadataConfigs();
        if (originMetadataConfigs.stream().anyMatch(m -> Objects.nonNull(m.getAddress()))) {
            return;
        }
        Collection metadataConfigsToOverride = originMetadataConfigs.stream().filter(m -> Objects.isNull(m.getAddress())).collect(Collectors.toList());
        if (metadataConfigsToOverride.size() > 1) {
            return;
        }
        MetadataReportConfig metadataConfigToOverride = metadataConfigsToOverride.stream().findFirst().orElse(null);
        List defaultRegistries = this.configManager.getDefaultRegistries();
        if (!defaultRegistries.isEmpty()) {
            defaultRegistries.stream().filter(this::isUsedRegistryAsMetadataCenter).map(registryConfig -> this.registryAsMetadataCenter((RegistryConfig)registryConfig, metadataConfigToOverride)).forEach(metadataReportConfig -> this.overrideMetadataReportConfig(metadataConfigToOverride, (MetadataReportConfig)metadataReportConfig));
        }
    }

    private void overrideMetadataReportConfig(MetadataReportConfig metadataConfigToOverride, MetadataReportConfig metadataReportConfig) {
        if (metadataReportConfig.getId() == null) {
            Collection metadataReportConfigs = this.configManager.getMetadataConfigs();
            if (CollectionUtils.isNotEmpty((Collection)metadataReportConfigs)) {
                for (MetadataReportConfig existedConfig : metadataReportConfigs) {
                    if (existedConfig.getId() != null || !existedConfig.getAddress().equals(metadataReportConfig.getAddress())) continue;
                    return;
                }
            }
            this.configManager.removeConfig((AbstractConfig)metadataConfigToOverride);
            this.configManager.addMetadataReport(metadataReportConfig);
        } else {
            Optional configOptional = this.configManager.getConfig(MetadataReportConfig.class, metadataReportConfig.getId());
            if (configOptional.isPresent()) {
                return;
            }
            this.configManager.removeConfig((AbstractConfig)metadataConfigToOverride);
            this.configManager.addMetadataReport(metadataReportConfig);
        }
        logger.info("use registry as metadata-center: " + metadataReportConfig);
    }

    private boolean isUsedRegistryAsMetadataCenter(RegistryConfig registryConfig) {
        return this.isUsedRegistryAsCenter(registryConfig, () -> ((RegistryConfig)registryConfig).getUseAsMetadataCenter(), "metadata", MetadataReportFactory.class);
    }

    private boolean isUsedRegistryAsCenter(RegistryConfig registryConfig, Supplier<Boolean> usedRegistryAsCenter, String centerType, Class<?> extensionClass) {
        boolean supported;
        Boolean configuredValue = usedRegistryAsCenter.get();
        if (configuredValue != null) {
            supported = configuredValue;
        } else {
            String protocol = registryConfig.getProtocol();
            supported = this.supportsExtension(extensionClass, protocol);
            if (logger.isInfoEnabled()) {
                logger.info(String.format("No value is configured in the registry, the %s extension[name : %s] %s as the %s center", extensionClass.getSimpleName(), protocol, supported ? "supports" : "does not support", centerType));
            }
        }
        if (logger.isInfoEnabled()) {
            logger.info(String.format("The registry[%s] will be %s as the %s center", registryConfig, supported ? "used" : "not used", centerType));
        }
        return supported;
    }

    private boolean supportsExtension(Class<?> extensionClass, String name) {
        if (StringUtils.isNotEmpty((String)name)) {
            ExtensionLoader<?> extensionLoader = this.getExtensionLoader(extensionClass);
            return extensionLoader.hasExtension(name);
        }
        return false;
    }

    private MetadataReportConfig registryAsMetadataCenter(RegistryConfig registryConfig, MetadataReportConfig originMetadataReportConfig) {
        MetadataReportConfig metadataReportConfig;
        MetadataReportConfig metadataReportConfig2 = metadataReportConfig = originMetadataReportConfig == null ? new MetadataReportConfig(registryConfig.getApplicationModel()) : originMetadataReportConfig;
        if (metadataReportConfig.getId() == null) {
            metadataReportConfig.setId(registryConfig.getId());
        }
        metadataReportConfig.setScopeModel((ScopeModel)this.applicationModel);
        if (metadataReportConfig.getParameters() == null) {
            metadataReportConfig.setParameters(new HashMap());
        }
        if (CollectionUtils.isNotEmptyMap((Map)registryConfig.getParameters())) {
            for (Map.Entry entry : registryConfig.getParameters().entrySet()) {
                metadataReportConfig.getParameters().putIfAbsent((String)entry.getKey(), (String)entry.getValue());
            }
        }
        metadataReportConfig.getParameters().put("client", registryConfig.getClient());
        if (metadataReportConfig.getGroup() == null) {
            metadataReportConfig.setGroup(registryConfig.getGroup());
        }
        if (metadataReportConfig.getAddress() == null) {
            metadataReportConfig.setAddress(this.getRegistryCompatibleAddress(registryConfig));
        }
        if (metadataReportConfig.getUsername() == null) {
            metadataReportConfig.setUsername(registryConfig.getUsername());
        }
        if (metadataReportConfig.getPassword() == null) {
            metadataReportConfig.setPassword(registryConfig.getPassword());
        }
        if (metadataReportConfig.getTimeout() == null) {
            metadataReportConfig.setTimeout(registryConfig.getTimeout());
        }
        return metadataReportConfig;
    }

    private String getRegistryCompatibleAddress(RegistryConfig registryConfig) {
        String registryAddress = registryConfig.getAddress();
        Object[] addresses = CommonConstants.REGISTRY_SPLIT_PATTERN.split(registryAddress);
        if (ArrayUtils.isEmpty((Object[])addresses)) {
            throw new IllegalStateException("Invalid registry address found.");
        }
        Object address = addresses[0];
        StringBuilder metadataAddressBuilder = new StringBuilder();
        URL url = URL.valueOf((String)address, (ScopeModel)registryConfig.getScopeModel());
        String protocolFromAddress = url.getProtocol();
        if (StringUtils.isEmpty((String)protocolFromAddress)) {
            String protocolFromConfig = registryConfig.getProtocol();
            metadataAddressBuilder.append(protocolFromConfig).append("://");
        }
        metadataAddressBuilder.append((String)address);
        return metadataAddressBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Future start() {
        Object object = this.startLock;
        synchronized (object) {
            if (this.isStopping() || this.isStopped() || this.isFailed()) {
                throw new IllegalStateException(this.getIdentifier() + " is stopping or stopped, can not start again");
            }
            try {
                boolean hasPendingModule = this.hasPendingModule();
                if (this.isStarting()) {
                    if (hasPendingModule) {
                        this.startModules();
                    }
                    return this.startFuture;
                }
                if ((this.isStarted() || this.isCompletion()) && !hasPendingModule) {
                    return CompletableFuture.completedFuture(false);
                }
                this.onStarting();
                this.initialize();
                this.doStart();
            }
            catch (Throwable e) {
                this.onFailed(this.getIdentifier() + " start failure", e);
                throw e;
            }
            return this.startFuture;
        }
    }

    private boolean hasPendingModule() {
        boolean found = false;
        for (ModuleModel moduleModel : this.applicationModel.getModuleModels()) {
            if (!moduleModel.getDeployer().isPending()) continue;
            found = true;
            break;
        }
        return found;
    }

    public Future getStartFuture() {
        return this.startFuture;
    }

    private void doStart() {
        this.startModules();
    }

    private void startModules() {
        this.prepareInternalModule();
        for (ModuleModel moduleModel : this.applicationModel.getModuleModels()) {
            if (!moduleModel.getDeployer().isPending()) continue;
            moduleModel.getDeployer().start();
        }
    }

    public void prepareApplicationInstance(ModuleModel moduleModel) {
        ApplicationConfig applicationConfig;
        if (this.hasPreparedApplicationInstance.get()) {
            return;
        }
        this.exportMetricsService();
        if (moduleModel.getDeployer().hasRegistryInteraction() && "DEFAULT_DUBBO_APP".equals((applicationConfig = this.configManager.getApplicationOrElseThrow()).getName())) {
            throw new IllegalStateException("Application name must be set when registry is enabled.");
        }
        if ((this.isRegisterConsumerInstance() || moduleModel.getDeployer().hasRegistryInteraction()) && this.hasPreparedApplicationInstance.compareAndSet(false, true)) {
            this.registerServiceInstance();
        }
    }

    public synchronized void exportMetadataService() {
        this.doExportMetadataService();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepareInternalModule() {
        if (this.hasPreparedInternalModule) {
            return;
        }
        Object object = this.internalModuleLock;
        synchronized (object) {
            if (this.hasPreparedInternalModule) {
                return;
            }
            ModuleDeployer internalModuleDeployer = this.applicationModel.getInternalModule().getDeployer();
            if (!internalModuleDeployer.isCompletion()) {
                Future future = internalModuleDeployer.start();
                try {
                    future.get(5L, TimeUnit.SECONDS);
                    this.hasPreparedInternalModule = true;
                }
                catch (Exception e) {
                    logger.warn("5-14", "", "", "wait for internal module startup failed: " + e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    private void exportMetricsService() {
        boolean exportMetrics = this.applicationModel.getApplicationConfigManager().getMetrics().map(MetricsConfig::getExportMetricsService).orElse(true);
        if (exportMetrics) {
            try {
                this.metricsServiceExporter.export();
            }
            catch (Exception e) {
                logger.error("0-13", "", "", "exportMetricsService an exception occurred when handle starting event", (Throwable)e);
            }
        }
    }

    private void unexportMetricsService() {
        if (this.metricsServiceExporter != null) {
            try {
                this.metricsServiceExporter.unexport();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private boolean hasExportedServices() {
        for (ModuleModel moduleModel : this.applicationModel.getModuleModels()) {
            if (!CollectionUtils.isNotEmpty((Collection)moduleModel.getConfigManager().getServices())) continue;
            return true;
        }
        return false;
    }

    public boolean isBackground() {
        for (ModuleModel moduleModel : this.applicationModel.getModuleModels()) {
            if (!moduleModel.getDeployer().isBackground()) continue;
            return true;
        }
        return false;
    }

    private DynamicConfiguration prepareEnvironment(ConfigCenterConfig configCenter) {
        if (configCenter.isValid()) {
            DynamicConfiguration dynamicConfiguration;
            if (!configCenter.checkOrUpdateInitialized(true)) {
                return null;
            }
            try {
                dynamicConfiguration = this.getDynamicConfiguration(configCenter.toUrl());
            }
            catch (Exception e) {
                if (!configCenter.isCheck().booleanValue()) {
                    logger.warn("5-22", "", "", "The configuration center failed to initialize", (Throwable)e);
                    configCenter.setInitialized(false);
                    return null;
                }
                throw new IllegalStateException(e);
            }
            ApplicationModel applicationModel = this.getApplicationModel();
            if (StringUtils.isNotEmpty((String)configCenter.getConfigFile())) {
                String configContent = dynamicConfiguration.getProperties(configCenter.getConfigFile(), configCenter.getGroup());
                if (StringUtils.isNotEmpty((String)configContent)) {
                    logger.info(String.format("Got global remote configuration from config center with key-%s and group-%s: \n %s", configCenter.getConfigFile(), configCenter.getGroup(), configContent));
                }
                String appGroup = "";
                String appConfigContent = null;
                String appConfigFile = null;
                Optional<ApplicationConfig> applicationOptional = this.getApplication();
                if (applicationOptional.isPresent() && StringUtils.isNotEmpty((String)(appGroup = applicationOptional.get().getName())) && StringUtils.isNotEmpty((String)(appConfigContent = dynamicConfiguration.getProperties(appConfigFile = StringUtils.isNotEmpty((String)configCenter.getAppConfigFile()) ? configCenter.getAppConfigFile() : configCenter.getConfigFile(), appGroup)))) {
                    logger.info(String.format("Got application specific remote configuration from config center with key %s and group %s: \n %s", appConfigFile, appGroup, appConfigContent));
                }
                try {
                    Map configMap = ConfigurationUtils.parseProperties((String)configContent);
                    Map appConfigMap = ConfigurationUtils.parseProperties(appConfigContent);
                    this.environment.updateExternalConfigMap(configMap);
                    this.environment.updateAppExternalConfigMap(appConfigMap);
                    MetricsEventBus.publish((MetricsEvent)ConfigCenterEvent.toChangeEvent((ApplicationModel)applicationModel, (String)configCenter.getConfigFile(), (String)configCenter.getGroup(), (String)configCenter.getProtocol(), (String)ConfigChangeType.ADDED.name(), (int)configMap.size()));
                    if (StringUtils.isNotEmpty((String)appGroup)) {
                        MetricsEventBus.publish((MetricsEvent)ConfigCenterEvent.toChangeEvent((ApplicationModel)applicationModel, (String)appConfigFile, (String)appGroup, (String)configCenter.getProtocol(), (String)ConfigChangeType.ADDED.name(), (int)appConfigMap.size()));
                    }
                }
                catch (IOException e) {
                    throw new IllegalStateException("Failed to parse configurations from Config Center.", e);
                }
            }
            return dynamicConfiguration;
        }
        return null;
    }

    private DynamicConfiguration getDynamicConfiguration(URL connectionURL) {
        String protocol = connectionURL.getProtocol();
        DynamicConfigurationFactory factory = ConfigurationUtils.getDynamicConfigurationFactory((ExtensionAccessor)this.applicationModel, (String)protocol);
        return factory.getDynamicConfiguration(connectionURL);
    }

    private void registerServiceInstance() {
        try {
            this.registered = true;
            ServiceInstanceMetadataUtils.registerMetadataAndInstance((ApplicationModel)this.applicationModel);
        }
        catch (Exception e) {
            logger.error("5-11", "configuration server disconnected", "", "Register instance error.", (Throwable)e);
        }
        if (this.registered) {
            this.asyncMetadataFuture = this.frameworkExecutorRepository.getSharedScheduledExecutor().scheduleWithFixedDelay(() -> {
                block6: {
                    if (this.applicationModel.isDestroyed()) {
                        return;
                    }
                    if (this.instanceRefreshScheduleTimes.incrementAndGet() % 30 != 0 && !this.isCompletion()) {
                        return;
                    }
                    if (this.serviceRefreshState.get() != 0 && this.instanceRefreshScheduleTimes.get() % 5 != 0) {
                        return;
                    }
                    try {
                        if (!this.applicationModel.isDestroyed() && this.registered) {
                            ServiceInstanceMetadataUtils.refreshMetadataAndInstance((ApplicationModel)this.applicationModel);
                        }
                    }
                    catch (Exception e) {
                        if (this.applicationModel.isDestroyed()) break block6;
                        logger.error("5-12", "", "", "Refresh instance and metadata error.", (Throwable)e);
                    }
                }
            }, 0L, ConfigurationUtils.get((ScopeModel)this.applicationModel, (String)"dubbo.application.metadata.publish.delay", (int)1000), TimeUnit.MILLISECONDS);
        }
    }

    public void refreshServiceInstance() {
        if (this.registered) {
            try {
                ServiceInstanceMetadataUtils.refreshMetadataAndInstance((ApplicationModel)this.applicationModel);
            }
            catch (Exception e) {
                logger.error("5-12", "", "", "Refresh instance and metadata error.", (Throwable)e);
            }
        }
    }

    public void increaseServiceRefreshCount() {
        this.serviceRefreshState.incrementAndGet();
    }

    public void decreaseServiceRefreshCount() {
        this.serviceRefreshState.decrementAndGet();
    }

    private void unregisterServiceInstance() {
        if (this.registered) {
            ServiceInstanceMetadataUtils.unregisterMetadataAndInstance((ApplicationModel)this.applicationModel);
        }
    }

    public void stop() {
        this.applicationModel.destroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preDestroy() {
        Object object = this.destroyLock;
        synchronized (object) {
            if (this.isStopping() || this.isStopped()) {
                return;
            }
            this.onStopping();
            this.offline();
            this.unregisterServiceInstance();
            this.unexportMetricsService();
            this.unRegisterShutdownHook();
            if (this.asyncMetadataFuture != null) {
                this.asyncMetadataFuture.cancel(true);
            }
        }
    }

    private void offline() {
        try {
            for (ModuleModel moduleModel : this.applicationModel.getModuleModels()) {
                ModuleServiceRepository serviceRepository = moduleModel.getServiceRepository();
                List exportedServices = serviceRepository.getExportedServices();
                for (ProviderModel exportedService : exportedServices) {
                    List statedUrls = exportedService.getStatedUrl();
                    for (ProviderModel.RegisterStatedURL statedURL : statedUrls) {
                        if (!statedURL.isRegistered()) continue;
                        this.doOffline(statedURL);
                    }
                }
            }
        }
        catch (Throwable t) {
            logger.error("99-0", "", "", "Exceptions occurred when unregister services.", t);
        }
    }

    private void doOffline(ProviderModel.RegisterStatedURL statedURL) {
        RegistryFactory registryFactory = (RegistryFactory)statedURL.getRegistryUrl().getOrDefaultApplicationModel().getExtensionLoader(RegistryFactory.class).getAdaptiveExtension();
        Registry registry = registryFactory.getRegistry(statedURL.getRegistryUrl());
        registry.unregister(statedURL.getProviderUrl());
        statedURL.setRegistered(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postDestroy() {
        Object object = this.destroyLock;
        synchronized (object) {
            if (this.isStopped()) {
                return;
            }
            try {
                this.destroyRegistries();
                this.destroyMetadataReports();
                this.executeShutdownCallbacks();
                this.destroyExecutorRepository();
                this.onStopped();
            }
            catch (Throwable ex) {
                String msg = this.getIdentifier() + " an error occurred while stopping application: " + ex.getMessage();
                this.onFailed(msg, ex);
            }
        }
    }

    private void executeShutdownCallbacks() {
        ShutdownHookCallbacks shutdownHookCallbacks = (ShutdownHookCallbacks)this.applicationModel.getBeanFactory().getBean(ShutdownHookCallbacks.class);
        shutdownHookCallbacks.callback();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyModuleChanged(ModuleModel moduleModel, DeployState state) {
        this.checkState(moduleModel, state);
        Object object = this.stateLock;
        synchronized (object) {
            this.stateLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkState(ModuleModel moduleModel, DeployState moduleState) {
        Object object = this.stateLock;
        synchronized (object) {
            if (!moduleModel.isInternal() && moduleState == DeployState.STARTED) {
                this.prepareApplicationInstance(moduleModel);
            }
            DeployState newState = this.calculateState();
            switch (newState) {
                case STARTED: {
                    this.onStarted();
                    break;
                }
                case COMPLETION: {
                    this.onCompletion();
                    break;
                }
                case STARTING: {
                    this.onStarting();
                    break;
                }
                case STOPPING: {
                    this.onStopping();
                    break;
                }
                case STOPPED: {
                    this.onStopped();
                    break;
                }
                case FAILED: {
                    Throwable error = null;
                    ModuleModel errorModule = null;
                    for (ModuleModel module : this.applicationModel.getModuleModels()) {
                        ModuleDeployer deployer = module.getDeployer();
                        if (!deployer.isFailed() || deployer.getError() == null) continue;
                        error = deployer.getError();
                        errorModule = module;
                        break;
                    }
                    this.onFailed(this.getIdentifier() + " found failed module: " + errorModule.getDesc(), error);
                    break;
                }
                case PENDING: {
                    break;
                }
            }
        }
    }

    private DeployState calculateState() {
        int total = 0;
        int pending = 0;
        int starting = 0;
        int started = 0;
        int completion = 0;
        int stopping = 0;
        int stopped = 0;
        int failed = 0;
        for (ModuleModel moduleModel : this.applicationModel.getModuleModels()) {
            ModuleDeployer deployer = moduleModel.getDeployer();
            if (deployer == null) {
                ++pending;
            } else if (deployer.isPending()) {
                ++pending;
            } else if (deployer.isStarting()) {
                ++starting;
            } else if (deployer.isCompletion()) {
                ++completion;
            } else if (deployer.isStarted()) {
                ++started;
            } else if (deployer.isStopping()) {
                ++stopping;
            } else if (deployer.isStopped()) {
                ++stopped;
            } else if (deployer.isFailed()) {
                ++failed;
            }
            ++total;
        }
        if (failed > 0) {
            return DeployState.FAILED;
        }
        if (pending == total) {
            return DeployState.PENDING;
        }
        if (completion == total) {
            return DeployState.COMPLETION;
        }
        if (stopped == total) {
            return DeployState.STOPPED;
        }
        if (starting > 0 || pending > 0) {
            return DeployState.STARTING;
        }
        if (stopping > 0 || stopped > 0) {
            return DeployState.STOPPING;
        }
        if (started > 0) {
            return DeployState.STARTED;
        }
        return DeployState.UNKNOWN;
    }

    private void onInitialize() {
        for (DeployListener listener : this.listeners) {
            try {
                listener.onInitialize((ScopeModel)this.applicationModel);
            }
            catch (Throwable e) {
                logger.error("5-14", "", "", this.getIdentifier() + " an exception occurred when handle initialize event", e);
            }
        }
    }

    private void doExportMetadataService() {
        if (!(this.isStarting() || this.isStarted() || this.isCompletion())) {
            return;
        }
        for (DeployListener listener : this.listeners) {
            try {
                if (!(listener instanceof ApplicationDeployListener)) continue;
                ((ApplicationDeployListener)listener).onModuleStarted(this.applicationModel);
            }
            catch (Throwable e) {
                logger.error("5-14", "", "", this.getIdentifier() + " an exception occurred when handle starting event", e);
            }
        }
    }

    private void onStarting() {
        if (!(this.isPending() || this.isStarted() || this.isCompletion())) {
            return;
        }
        this.setStarting();
        this.startFuture = new CompletableFuture();
        if (logger.isInfoEnabled()) {
            logger.info(this.getIdentifier() + " is starting.");
        }
    }

    private void onStarted() {
        if (!this.isStarting()) {
            return;
        }
        this.setStarted();
        this.startMetricsCollector();
        if (logger.isInfoEnabled()) {
            logger.info(this.getIdentifier() + " is ready.");
        }
        try {
            if (this.registered) {
                ServiceInstanceMetadataUtils.refreshMetadataAndInstance((ApplicationModel)this.applicationModel);
            }
        }
        catch (Exception e) {
            logger.error("5-12", "", "", "Refresh instance and metadata error.", (Throwable)e);
        }
    }

    private void onCompletion() {
        try {
            if (!this.isStarted()) {
                return;
            }
            this.setCompletion();
            if (logger.isInfoEnabled()) {
                logger.info(this.getIdentifier() + " has completed.");
            }
        }
        finally {
            this.completeStartFuture(true);
        }
    }

    private void startMetricsCollector() {
        DefaultMetricsCollector collector = (DefaultMetricsCollector)this.applicationModel.getBeanFactory().getBean(DefaultMetricsCollector.class);
        if (Objects.nonNull(collector) && collector.isThreadpoolCollectEnabled()) {
            collector.registryDefaultSample();
        }
    }

    private void completeStartFuture(boolean success) {
        if (this.startFuture != null) {
            this.startFuture.complete(success);
        }
    }

    private void onStopping() {
        try {
            if (this.isStopping() || this.isStopped()) {
                return;
            }
            this.setStopping();
            if (logger.isInfoEnabled()) {
                logger.info(this.getIdentifier() + " is stopping.");
            }
        }
        finally {
            this.completeStartFuture(false);
        }
    }

    private void onStopped() {
        try {
            if (this.isStopped()) {
                return;
            }
            this.setStopped();
            if (logger.isInfoEnabled()) {
                logger.info(this.getIdentifier() + " has stopped.");
            }
        }
        finally {
            this.completeStartFuture(false);
        }
    }

    private void onFailed(String msg, Throwable ex) {
        try {
            this.setFailed(ex);
            logger.error("5-14", "", "", msg, ex);
        }
        finally {
            this.completeStartFuture(false);
        }
    }

    private void destroyExecutorRepository() {
        this.executorRepository.shutdownServiceExportExecutor();
        this.executorRepository.shutdownServiceReferExecutor();
        ExecutorRepository.getInstance((ApplicationModel)this.applicationModel).destroyAll();
    }

    private void destroyRegistries() {
        RegistryManager.getInstance((ApplicationModel)this.applicationModel).destroyAll();
    }

    private void destroyServiceDiscoveries() {
        RegistryManager.getInstance((ApplicationModel)this.applicationModel).getServiceDiscoveries().forEach(serviceDiscovery -> {
            try {
                serviceDiscovery.destroy();
            }
            catch (Throwable ignored) {
                logger.warn("5-21", "", "", ignored.getMessage(), ignored);
            }
        });
        if (logger.isDebugEnabled()) {
            logger.debug(this.getIdentifier() + "'s all ServiceDiscoveries have been destroyed.");
        }
    }

    private void destroyMetadataReports() {
        List metadataReportFactories = this.getExtensionLoader(MetadataReportFactory.class).getLoadedExtensionInstances();
        for (MetadataReportFactory metadataReportFactory : metadataReportFactories) {
            metadataReportFactory.destroy();
        }
    }

    private ApplicationConfig getApplicationOrElseThrow() {
        return this.configManager.getApplicationOrElseThrow();
    }

    private Optional<ApplicationConfig> getApplication() {
        return this.configManager.getApplication();
    }
}

