/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dubbo.rpc;

import com.alibaba.dubbo.common.DelegateURL;
import com.alibaba.dubbo.common.URL;
import com.alibaba.dubbo.rpc.Invocation;
import com.alibaba.dubbo.rpc.Invoker;
import com.alibaba.dubbo.rpc.RpcException;
import com.alibaba.dubbo.rpc.protocol.dubbo.FutureAdapter;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.rpc.FutureContext;

@Deprecated
public class RpcContext {
    private org.apache.dubbo.rpc.RpcContext newRpcContext;

    public static RpcContext getContext() {
        return new RpcContext(org.apache.dubbo.rpc.RpcContext.getContext());
    }

    public static RpcContext getServerContext() {
        return new RpcContext((org.apache.dubbo.rpc.RpcContext)org.apache.dubbo.rpc.RpcContext.getServerContext());
    }

    public static RpcContext getClientResponseContext() {
        return new RpcContext((org.apache.dubbo.rpc.RpcContext)org.apache.dubbo.rpc.RpcContext.getClientResponseContext());
    }

    public static RpcContext getServerResponseContext() {
        return new RpcContext((org.apache.dubbo.rpc.RpcContext)org.apache.dubbo.rpc.RpcContext.getServerResponseContext());
    }

    public static void removeClientResponseContext() {
        org.apache.dubbo.rpc.RpcContext.removeClientResponseContext();
    }

    public static void removeServerResponseContext() {
        org.apache.dubbo.rpc.RpcContext.removeServerResponseContext();
    }

    public static void removeServerContext() {
        org.apache.dubbo.rpc.RpcContext.removeServerContext();
    }

    public static void removeContext() {
        org.apache.dubbo.rpc.RpcContext.removeContext();
    }

    public RpcContext(org.apache.dubbo.rpc.RpcContext newRpcContext) {
        this.newRpcContext = newRpcContext;
    }

    public Object getRequest() {
        return this.newRpcContext.getRequest();
    }

    public <T> T getRequest(Class<T> clazz) {
        return (T)this.newRpcContext.getRequest(clazz);
    }

    public void setRequest(Object request) {
        this.newRpcContext.setRequest(request);
    }

    public Object getResponse() {
        return this.newRpcContext.getResponse();
    }

    public <T> T getResponse(Class<T> clazz) {
        return (T)this.newRpcContext.getResponse(clazz);
    }

    public void setResponse(Object response) {
        this.newRpcContext.setResponse(response);
    }

    public boolean isProviderSide() {
        return this.newRpcContext.isProviderSide();
    }

    public boolean isConsumerSide() {
        return this.newRpcContext.isConsumerSide();
    }

    public List<URL> getUrls() {
        List newUrls = this.newRpcContext.getUrls();
        if (CollectionUtils.isNotEmpty((Collection)newUrls)) {
            ArrayList<URL> urls = new ArrayList<URL>(newUrls.size());
            for (org.apache.dubbo.common.URL newUrl : newUrls) {
                urls.add(new DelegateURL(newUrl));
            }
            return urls;
        }
        return Collections.emptyList();
    }

    public void setUrls(List<URL> urls) {
        if (CollectionUtils.isNotEmpty(urls)) {
            ArrayList<org.apache.dubbo.common.URL> newUrls = new ArrayList<org.apache.dubbo.common.URL>(urls.size());
            for (URL url : urls) {
                newUrls.add(url.getOriginalURL());
            }
            this.newRpcContext.setUrls(newUrls);
        }
    }

    public URL getUrl() {
        return new DelegateURL(this.newRpcContext.getUrl());
    }

    public void setUrl(URL url) {
        this.newRpcContext.setUrl(url.getOriginalURL());
    }

    public String getMethodName() {
        return this.newRpcContext.getMethodName();
    }

    public void setMethodName(String methodName) {
        this.newRpcContext.setMethodName(methodName);
    }

    public Class<?>[] getParameterTypes() {
        return this.newRpcContext.getParameterTypes();
    }

    public void setParameterTypes(Class<?>[] parameterTypes) {
        this.newRpcContext.setParameterTypes((Class[])parameterTypes);
    }

    public Object[] getArguments() {
        return this.newRpcContext.getArguments();
    }

    public void setArguments(Object[] arguments) {
        this.newRpcContext.setArguments(arguments);
    }

    public RpcContext setLocalAddress(String host, int port) {
        this.newRpcContext.setLocalAddress(host, port);
        return this;
    }

    public InetSocketAddress getLocalAddress() {
        return this.newRpcContext.getLocalAddress();
    }

    public RpcContext setLocalAddress(InetSocketAddress address) {
        this.newRpcContext.setLocalAddress(address);
        return this;
    }

    public String getLocalAddressString() {
        return this.newRpcContext.getLocalAddressString();
    }

    public String getLocalHostName() {
        return this.newRpcContext.getLocalHostName();
    }

    public RpcContext setRemoteAddress(String host, int port) {
        this.newRpcContext.setRemoteAddress(host, port);
        return this;
    }

    public InetSocketAddress getRemoteAddress() {
        return this.newRpcContext.getRemoteAddress();
    }

    public RpcContext setRemoteAddress(InetSocketAddress address) {
        this.newRpcContext.setRemoteAddress(address);
        return this;
    }

    public String getRemoteAddressString() {
        return this.newRpcContext.getRemoteAddressString();
    }

    public String getRemoteHostName() {
        return this.newRpcContext.getRemoteHostName();
    }

    public String getLocalHost() {
        return this.newRpcContext.getLocalHost();
    }

    public int getLocalPort() {
        return this.newRpcContext.getLocalPort();
    }

    public String getRemoteHost() {
        return this.newRpcContext.getRemoteHost();
    }

    public int getRemotePort() {
        return this.newRpcContext.getRemotePort();
    }

    public String getAttachment(String key) {
        return this.newRpcContext.getAttachment(key);
    }

    public RpcContext setAttachment(String key, String value) {
        this.newRpcContext.setAttachment(key, value);
        return this;
    }

    public RpcContext removeAttachment(String key) {
        this.newRpcContext.removeAttachment(key);
        return this;
    }

    public Map<String, String> getAttachments() {
        return this.newRpcContext.getAttachments();
    }

    public RpcContext setAttachments(Map<String, String> attachment) {
        this.newRpcContext.setAttachments(attachment);
        return this;
    }

    public void clearAttachments() {
        this.newRpcContext.clearAttachments();
    }

    public Map<String, Object> get() {
        return this.newRpcContext.get();
    }

    public RpcContext set(String key, Object value) {
        this.newRpcContext.set(key, value);
        return this;
    }

    public RpcContext remove(String key) {
        this.newRpcContext.remove(key);
        return this;
    }

    public Object get(String key) {
        return this.newRpcContext.get(key);
    }

    public Invocation getInvocation() {
        return new Invocation.CompatibleInvocation(this.newRpcContext.getInvocation());
    }

    @Deprecated
    public boolean isServerSide() {
        return this.isProviderSide();
    }

    @Deprecated
    public boolean isClientSide() {
        return this.isConsumerSide();
    }

    @Deprecated
    public Invoker<?> getInvoker() {
        org.apache.dubbo.rpc.Invoker invoker = this.newRpcContext.getInvoker();
        if (invoker == null) {
            return null;
        }
        return new Invoker.CompatibleInvoker(invoker);
    }

    @Deprecated
    public List<Invoker<?>> getInvokers() {
        List invokers = this.newRpcContext.getInvokers();
        if (CollectionUtils.isEmpty((Collection)invokers)) {
            return Collections.emptyList();
        }
        return invokers.stream().map(Invoker.CompatibleInvoker::new).collect(Collectors.toList());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> Future<T> asyncCall(Callable<T> callable) {
        try {
            try {
                this.setAttachment("async", Boolean.TRUE.toString());
                final T o = callable.call();
                if (o == null) return RpcContext.getContext().getFuture();
                FutureTask f = new FutureTask(new Callable<T>(){

                    @Override
                    public T call() throws Exception {
                        return o;
                    }
                });
                f.run();
                FutureTask futureTask = f;
                return futureTask;
            }
            catch (Exception e) {
                throw new RpcException(e);
            }
            finally {
                this.removeAttachment("async");
            }
        }
        catch (RpcException e) {
            return new Future<T>(){

                @Override
                public boolean cancel(boolean mayInterruptIfRunning) {
                    return false;
                }

                @Override
                public boolean isCancelled() {
                    return false;
                }

                @Override
                public boolean isDone() {
                    return true;
                }

                @Override
                public T get() throws InterruptedException, ExecutionException {
                    throw new ExecutionException(e.getCause());
                }

                @Override
                public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
                    return this.get();
                }
            };
        }
    }

    public void asyncCall(Runnable runnable) {
        try {
            this.setAttachment("return", Boolean.FALSE.toString());
            runnable.run();
        }
        catch (Throwable e) {
            throw new RpcException("oneway call error ." + e.getMessage(), e);
        }
        finally {
            this.removeAttachment("return");
        }
    }

    public <T> Future<T> getFuture() {
        CompletableFuture completableFuture = FutureContext.getContext().getCompatibleCompletableFuture();
        if (completableFuture == null) {
            return null;
        }
        return new FutureAdapter(completableFuture);
    }

    public void setFuture(CompletableFuture<?> future) {
        FutureContext.getContext().setCompatibleFuture(future);
    }
}

