/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.config;

import java.lang.reflect.Field;
import java.util.Map;
import java.util.Optional;
import org.apache.dubbo.common.serialization.PreferSerializationProvider;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.config.AbstractConfig;
import org.apache.dubbo.config.nested.TripleConfig;
import org.apache.dubbo.config.support.Nested;
import org.apache.dubbo.config.support.Parameter;
import org.apache.dubbo.rpc.model.ApplicationModel;

public class ProtocolConfig
extends AbstractConfig {
    private static final long serialVersionUID = 6913423882496634749L;
    private String name;
    private String host;
    private Integer port;
    private String contextpath;
    private String threadpool;
    private Integer corethreads;
    private Integer threads;
    private Integer iothreads;
    private Integer alive;
    private Integer queues;
    private String threadPoolExhaustedListeners;
    private Integer accepts;
    private String codec;
    private String serialization;
    private String preferSerialization;
    private String charset;
    private Integer payload;
    private Integer buffer;
    private Integer heartbeat;
    private String accesslog;
    private String transporter;
    private String exchanger;
    private String dispatcher;
    private String networker;
    private String server;
    private String client;
    private String telnet;
    private String prompt;
    private String status;
    private Boolean register;
    private Boolean keepAlive;
    private String optimizer;
    private String extension;
    private Map<String, String> parameters;
    private Boolean sslEnabled;
    private String extProtocol;
    private String preferredProtocol;
    private String jsonCheckLevel;
    private Boolean noInterfaceSupport;
    @Nested
    private TripleConfig triple;

    public ProtocolConfig() {
    }

    public ProtocolConfig(ApplicationModel applicationModel) {
        super(applicationModel);
    }

    public ProtocolConfig(String name) {
        this.setName(name);
    }

    public ProtocolConfig(ApplicationModel applicationModel, String name) {
        super(applicationModel);
        this.setName(name);
    }

    public ProtocolConfig(String name, int port) {
        this.setName(name);
        this.setPort(port);
    }

    public ProtocolConfig(ApplicationModel applicationModel, String name, int port) {
        super(applicationModel);
        this.setName(name);
        this.setPort(port);
    }

    @Override
    protected void checkDefault() {
        super.checkDefault();
        if (this.name == null) {
            this.name = "dubbo";
        }
        if (StringUtils.isBlank(this.preferSerialization)) {
            this.preferSerialization = this.serialization != null ? this.serialization : this.getScopeModel().getBeanFactory().getBean(PreferSerializationProvider.class).getPreferSerialization();
        }
    }

    @Parameter(excluded=true)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Parameter(excluded=true)
    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    @Parameter(excluded=true)
    public Integer getPort() {
        return this.port;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    @Deprecated
    @Parameter(excluded=true, attribute=false)
    public String getPath() {
        return this.getContextpath();
    }

    @Deprecated
    public void setPath(String path) {
        this.setContextpath(path);
    }

    @Parameter(excluded=true)
    public String getContextpath() {
        return this.contextpath;
    }

    public void setContextpath(String contextpath) {
        this.contextpath = contextpath;
    }

    public String getThreadpool() {
        return this.threadpool;
    }

    public void setThreadpool(String threadpool) {
        this.threadpool = threadpool;
    }

    @Parameter(key="jsonCheckLevel")
    public String getJsonCheckLevel() {
        return this.jsonCheckLevel;
    }

    public void setJsonCheckLevel(String jsonCheckLevel) {
        this.jsonCheckLevel = jsonCheckLevel;
    }

    @Parameter(key="thread-pool-exhausted-listeners")
    public String getThreadPoolExhaustedListeners() {
        return this.threadPoolExhaustedListeners;
    }

    public void setThreadPoolExhaustedListeners(String threadPoolExhaustedListeners) {
        this.threadPoolExhaustedListeners = threadPoolExhaustedListeners;
    }

    public Integer getCorethreads() {
        return this.corethreads;
    }

    public void setCorethreads(Integer corethreads) {
        this.corethreads = corethreads;
    }

    public Integer getThreads() {
        return this.threads;
    }

    public void setThreads(Integer threads) {
        this.threads = threads;
    }

    public Integer getIothreads() {
        return this.iothreads;
    }

    public void setIothreads(Integer iothreads) {
        this.iothreads = iothreads;
    }

    public Integer getAlive() {
        return this.alive;
    }

    public void setAlive(Integer alive) {
        this.alive = alive;
    }

    public Integer getQueues() {
        return this.queues;
    }

    public void setQueues(Integer queues) {
        this.queues = queues;
    }

    public Integer getAccepts() {
        return this.accepts;
    }

    public void setAccepts(Integer accepts) {
        this.accepts = accepts;
    }

    public String getCodec() {
        return this.codec;
    }

    public void setCodec(String codec) {
        this.codec = codec;
    }

    public String getSerialization() {
        return this.serialization;
    }

    public void setSerialization(String serialization) {
        this.serialization = serialization;
    }

    public String getPreferSerialization() {
        return this.preferSerialization;
    }

    public void setPreferSerialization(String preferSerialization) {
        this.preferSerialization = preferSerialization;
    }

    public String getCharset() {
        return this.charset;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public Integer getPayload() {
        return this.payload;
    }

    public void setPayload(Integer payload) {
        this.payload = payload;
    }

    public Integer getBuffer() {
        return this.buffer;
    }

    public void setBuffer(Integer buffer) {
        this.buffer = buffer;
    }

    public Integer getHeartbeat() {
        return this.heartbeat;
    }

    public void setHeartbeat(Integer heartbeat) {
        this.heartbeat = heartbeat;
    }

    public String getServer() {
        return this.server;
    }

    public void setServer(String server) {
        this.server = server;
    }

    public String getClient() {
        return this.client;
    }

    public void setClient(String client) {
        this.client = client;
    }

    public String getAccesslog() {
        return this.accesslog;
    }

    public void setAccesslog(String accesslog) {
        this.accesslog = accesslog;
    }

    public String getTelnet() {
        return this.telnet;
    }

    public void setTelnet(String telnet) {
        this.telnet = telnet;
    }

    @Parameter(escaped=true)
    public String getPrompt() {
        return this.prompt;
    }

    public void setPrompt(String prompt) {
        this.prompt = prompt;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public Boolean isRegister() {
        return this.register;
    }

    public void setRegister(Boolean register) {
        this.register = register;
    }

    public String getTransporter() {
        return this.transporter;
    }

    public void setTransporter(String transporter) {
        this.transporter = transporter;
    }

    public String getExchanger() {
        return this.exchanger;
    }

    public void setExchanger(String exchanger) {
        this.exchanger = exchanger;
    }

    @Deprecated
    @Parameter(excluded=true, attribute=false)
    public String getDispather() {
        return this.getDispatcher();
    }

    @Deprecated
    public void setDispather(String dispather) {
        this.setDispatcher(dispather);
    }

    public String getDispatcher() {
        return this.dispatcher;
    }

    public void setDispatcher(String dispatcher) {
        this.dispatcher = dispatcher;
    }

    public String getNetworker() {
        return this.networker;
    }

    public void setNetworker(String networker) {
        this.networker = networker;
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public void setParameters(Map<String, String> parameters) {
        this.parameters = parameters;
    }

    @Parameter(key="ssl-enabled")
    public Boolean getSslEnabled() {
        return this.sslEnabled;
    }

    public void setSslEnabled(Boolean sslEnabled) {
        this.sslEnabled = sslEnabled;
    }

    public Boolean getKeepAlive() {
        return this.keepAlive;
    }

    public void setKeepAlive(Boolean keepAlive) {
        this.keepAlive = keepAlive;
    }

    public String getOptimizer() {
        return this.optimizer;
    }

    public void setOptimizer(String optimizer) {
        this.optimizer = optimizer;
    }

    public String getExtension() {
        return this.extension;
    }

    public void setExtension(String extension) {
        this.extension = extension;
    }

    @Override
    @Parameter(excluded=true, attribute=false)
    public boolean isValid() {
        return StringUtils.isNotEmpty(this.name);
    }

    public String getExtProtocol() {
        return this.extProtocol;
    }

    public void setExtProtocol(String extProtocol) {
        this.extProtocol = extProtocol;
    }

    public String getPreferredProtocol() {
        return this.preferredProtocol;
    }

    public void setPreferredProtocol(String preferredProtocol) {
        this.preferredProtocol = preferredProtocol;
    }

    public Boolean isNoInterfaceSupport() {
        return this.noInterfaceSupport;
    }

    public void setNoInterfaceSupport(Boolean noInterfaceSupport) {
        this.noInterfaceSupport = noInterfaceSupport;
    }

    public TripleConfig getTriple() {
        return this.triple;
    }

    @Parameter(excluded=true)
    public TripleConfig getTripleOrDefault() {
        if (this.triple == null) {
            this.triple = new TripleConfig();
        }
        return this.triple;
    }

    public void setTriple(TripleConfig triple) {
        this.triple = triple;
    }

    public void mergeProtocol(ProtocolConfig sourceConfig) {
        if (sourceConfig == null) {
            return;
        }
        Field[] targetFields = this.getClass().getDeclaredFields();
        try {
            Map protocolConfigMap = CollectionUtils.objToMap(sourceConfig);
            for (Field targetField : targetFields) {
                Optional.ofNullable(protocolConfigMap.get(targetField.getName())).ifPresent(value -> {
                    try {
                        targetField.setAccessible(true);
                        if (targetField.get(this) == null) {
                            targetField.set(this, value);
                        }
                    }
                    catch (IllegalAccessException e) {
                        throw new RuntimeException(e);
                    }
                });
            }
        }
        catch (Exception e) {
            logger.error("0-12", "", "", "merge protocol config fail, error: ", e);
        }
    }
}

