/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common.serialization;

import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.dubbo.common.utils.ConcurrentHashMapUtils;
import org.apache.dubbo.common.utils.ConcurrentHashSet;

public class ClassHolder {
    private final ConcurrentHashMap<String, Set<Class<?>>> classCache = new ConcurrentHashMap();

    public void storeClass(Class<?> clazz) {
        ConcurrentHashMapUtils.computeIfAbsent(this.classCache, clazz.getName(), k -> new ConcurrentHashSet()).add(clazz);
    }

    public Class<?> loadClass(String className, ClassLoader classLoader) {
        Set<Class<?>> classList = this.classCache.get(className);
        if (classList == null) {
            return null;
        }
        for (Class<?> clazz : classList) {
            if (!classLoader.equals(clazz.getClassLoader())) continue;
            return clazz;
        }
        return null;
    }
}

