/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common.config;

import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.dubbo.common.config.Configuration;
import org.apache.dubbo.common.utils.StringUtils;

public class EnvironmentConfiguration
implements Configuration {
    @Override
    public Object getInternalProperty(String key) {
        if (StringUtils.isEmpty(key)) {
            return null;
        }
        String value = this.getenv().get(key);
        if (value != null) {
            return value;
        }
        for (String candidateKey : this.generateCandidateEnvironmentKeys(key)) {
            value = this.getenv().get(candidateKey);
            if (value == null) continue;
            return value;
        }
        String osStyleKey = StringUtils.toOSStyleKey(key);
        value = this.getenv().get(osStyleKey);
        return value;
    }

    private Set<String> generateCandidateEnvironmentKeys(String originalKey) {
        LinkedHashSet<String> candidates = new LinkedHashSet<String>();
        String dotsToUnderscores = originalKey.replace(".", "_");
        String normalizedKey = dotsToUnderscores.replace("-", "_");
        candidates.add(normalizedKey.toUpperCase(Locale.ROOT));
        String springLikeNoHyphens = dotsToUnderscores.replace("-", "").toUpperCase(Locale.ROOT);
        candidates.add(springLikeNoHyphens);
        String dotsToUnderscoresUpper = dotsToUnderscores.toUpperCase(Locale.ROOT);
        candidates.add(dotsToUnderscoresUpper);
        candidates.add(normalizedKey);
        return candidates;
    }

    public Map<String, String> getProperties() {
        return this.getenv();
    }

    protected Map<String, String> getenv() {
        return System.getenv();
    }
}

