/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.config;

import java.util.Map;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.common.utils.PojoUtils;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.config.AbstractConfig;
import org.apache.dubbo.config.support.Parameter;
import org.apache.dubbo.rpc.model.ApplicationModel;

public class RegistryConfig
extends AbstractConfig {
    private static final long serialVersionUID = 5508512956753757169L;
    public static final String NO_AVAILABLE = "N/A";
    private String address;
    private String username;
    private String password;
    private Integer port;
    private String protocol;
    private String transporter;
    private String server;
    private String client;
    private String cluster;
    private String zone;
    private String group;
    private String version;
    private Integer timeout;
    private Integer session;
    private String file;
    private Integer wait;
    private Boolean check;
    private Boolean dynamic;
    private Boolean register;
    private Boolean subscribe;
    private Map<String, String> parameters;
    private Boolean simplified;
    private String extraKeys;
    private Boolean useAsConfigCenter;
    private Boolean useAsMetadataCenter;
    private String accepts;
    private Boolean preferred;
    private Integer weight;
    private String registerMode;
    private Boolean enableEmptyProtection;
    private String secure;

    public String getSecure() {
        return this.secure;
    }

    public void setSecure(String secure) {
        this.secure = secure;
    }

    public RegistryConfig() {
    }

    public RegistryConfig(ApplicationModel applicationModel) {
        super(applicationModel);
    }

    public RegistryConfig(String address) {
        this.setAddress(address);
    }

    public RegistryConfig(ApplicationModel applicationModel, String address) {
        super(applicationModel);
        this.setAddress(address);
    }

    public RegistryConfig(String address, String protocol) {
        this.setAddress(address);
        this.setProtocol(protocol);
    }

    public RegistryConfig(ApplicationModel applicationModel, String address, String protocol) {
        super(applicationModel);
        this.setAddress(address);
        this.setProtocol(protocol);
    }

    @Override
    public String getId() {
        return super.getId();
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    @Parameter(excluded=true)
    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
        if (address != null) {
            try {
                URL url = URL.valueOf(address);
                PojoUtils.updatePropertyIfAbsent(this::getUsername, this::setUsername, url.getUsername());
                PojoUtils.updatePropertyIfAbsent(this::getPassword, this::setPassword, url.getPassword());
                PojoUtils.updatePropertyIfAbsent(this::getProtocol, this::setProtocol, url.getProtocol());
                PojoUtils.updatePropertyIfAbsent(this::getPort, this::setPort, url.getPort());
                Map<String, String> params = url.getParameters();
                if (CollectionUtils.isNotEmptyMap(params)) {
                    params.remove("backup");
                }
                this.updateParameters(params);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public Integer getPort() {
        return this.port;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    @Deprecated
    public Integer getWait() {
        return this.wait;
    }

    @Deprecated
    public void setWait(Integer wait) {
        this.wait = wait;
        if (wait != null && wait > 0) {
            System.setProperty("dubbo.service.shutdown.wait", String.valueOf(wait));
        }
    }

    public Boolean isCheck() {
        return this.check;
    }

    public void setCheck(Boolean check) {
        this.check = check;
    }

    public String getFile() {
        return this.file;
    }

    public void setFile(String file) {
        this.file = file;
    }

    @Deprecated
    @Parameter(excluded=true, attribute=false)
    public String getTransport() {
        return this.getTransporter();
    }

    @Deprecated
    public void setTransport(String transport) {
        this.setTransporter(transport);
    }

    public String getTransporter() {
        return this.transporter;
    }

    public void setTransporter(String transporter) {
        this.transporter = transporter;
    }

    public String getServer() {
        return this.server;
    }

    public void setServer(String server) {
        this.server = server;
    }

    public String getClient() {
        return this.client;
    }

    public void setClient(String client) {
        this.client = client;
    }

    public Integer getTimeout() {
        return this.timeout;
    }

    public void setTimeout(Integer timeout) {
        this.timeout = timeout;
    }

    public Integer getSession() {
        return this.session;
    }

    public void setSession(Integer session) {
        this.session = session;
    }

    public Boolean isDynamic() {
        return this.dynamic;
    }

    public void setDynamic(Boolean dynamic) {
        this.dynamic = dynamic;
    }

    public Boolean isRegister() {
        return this.register;
    }

    public void setRegister(Boolean register) {
        this.register = register;
    }

    public Boolean isSubscribe() {
        return this.subscribe;
    }

    public void setSubscribe(Boolean subscribe) {
        this.subscribe = subscribe;
    }

    public String getCluster() {
        return this.cluster;
    }

    public void setCluster(String cluster) {
        this.cluster = cluster;
    }

    public String getZone() {
        return this.zone;
    }

    public void setZone(String zone) {
        this.zone = zone;
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public void setParameters(Map<String, String> parameters) {
        this.parameters = parameters;
    }

    public void updateParameters(Map<String, String> parameters) {
        if (CollectionUtils.isEmptyMap(parameters)) {
            return;
        }
        if (this.parameters == null) {
            this.parameters = parameters;
        } else {
            this.parameters.putAll(parameters);
        }
    }

    public Boolean getSimplified() {
        return this.simplified;
    }

    public void setSimplified(Boolean simplified) {
        this.simplified = simplified;
    }

    @Parameter(key="extra-keys")
    public String getExtraKeys() {
        return this.extraKeys;
    }

    public void setExtraKeys(String extraKeys) {
        this.extraKeys = extraKeys;
    }

    @Parameter(excluded=true)
    public Boolean getUseAsConfigCenter() {
        return this.useAsConfigCenter;
    }

    public void setUseAsConfigCenter(Boolean useAsConfigCenter) {
        this.useAsConfigCenter = useAsConfigCenter;
    }

    @Parameter(excluded=true)
    public Boolean getUseAsMetadataCenter() {
        return this.useAsMetadataCenter;
    }

    public void setUseAsMetadataCenter(Boolean useAsMetadataCenter) {
        this.useAsMetadataCenter = useAsMetadataCenter;
    }

    public String getAccepts() {
        return this.accepts;
    }

    public void setAccepts(String accepts) {
        this.accepts = accepts;
    }

    public Boolean getPreferred() {
        return this.preferred;
    }

    public void setPreferred(Boolean preferred) {
        this.preferred = preferred;
    }

    public Integer getWeight() {
        return this.weight;
    }

    public void setWeight(Integer weight) {
        this.weight = weight;
    }

    @Parameter(key="register-mode")
    public String getRegisterMode() {
        return this.registerMode;
    }

    public void setRegisterMode(String registerMode) {
        this.registerMode = registerMode;
    }

    @Parameter(key="enable-empty-protection")
    public Boolean getEnableEmptyProtection() {
        return this.enableEmptyProtection;
    }

    public void setEnableEmptyProtection(Boolean enableEmptyProtection) {
        this.enableEmptyProtection = enableEmptyProtection;
    }

    @Override
    @Parameter(excluded=true, attribute=false)
    public boolean isValid() {
        return !StringUtils.isEmpty(this.address) || !StringUtils.isEmpty(this.protocol);
    }

    @Override
    @Parameter(excluded=true)
    public Boolean isDefault() {
        return this.isDefault;
    }
}

