/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common.url.component;

import java.util.AbstractMap;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.StringJoiner;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.URLStrParser;
import org.apache.dubbo.common.url.component.param.DynamicParamTable;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.common.utils.StringUtils;

public class URLParam {
    private static final int ADD_PARAMETER_ON_MOVE_THRESHOLD = 1;
    private final String rawParam;
    private final BitSet KEY;
    private final int[] VALUE;
    private final Map<String, String> EXTRA_PARAMS;
    private final Map<String, Map<String, String>> METHOD_PARAMETERS;
    private transient long timestamp;
    protected boolean enableCompressed;
    private static final URLParam EMPTY_PARAM = new URLParam(new BitSet(0), Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap(), "");
    private int hashCodeCache = -1;

    protected URLParam() {
        this.rawParam = null;
        this.KEY = null;
        this.VALUE = null;
        this.EXTRA_PARAMS = null;
        this.METHOD_PARAMETERS = null;
        this.enableCompressed = true;
    }

    protected URLParam(BitSet key, Map<Integer, Integer> value, Map<String, String> extraParams, Map<String, Map<String, String>> methodParameters, String rawParam) {
        this.KEY = key;
        this.VALUE = new int[value.size()];
        int i = key.nextSetBit(0);
        int offset = 0;
        while (i >= 0) {
            if (!value.containsKey(i)) {
                throw new IllegalArgumentException();
            }
            this.VALUE[offset++] = value.get(i);
            i = key.nextSetBit(i + 1);
        }
        this.EXTRA_PARAMS = Collections.unmodifiableMap(extraParams == null ? new HashMap() : new HashMap<String, String>(extraParams));
        this.METHOD_PARAMETERS = Collections.unmodifiableMap(methodParameters == null ? Collections.emptyMap() : new LinkedHashMap<String, Map<String, String>>(methodParameters));
        this.rawParam = rawParam;
        this.timestamp = System.currentTimeMillis();
        this.enableCompressed = true;
    }

    protected URLParam(BitSet key, int[] value, Map<String, String> extraParams, Map<String, Map<String, String>> methodParameters, String rawParam) {
        this.KEY = key;
        this.VALUE = value;
        this.EXTRA_PARAMS = Collections.unmodifiableMap(extraParams == null ? new HashMap() : new HashMap<String, String>(extraParams));
        this.METHOD_PARAMETERS = Collections.unmodifiableMap(methodParameters == null ? Collections.emptyMap() : new LinkedHashMap<String, Map<String, String>>(methodParameters));
        this.rawParam = rawParam;
        this.timestamp = System.currentTimeMillis();
        this.enableCompressed = true;
    }

    public boolean hasMethodParameter(String method) {
        if (method == null) {
            return false;
        }
        String methodsString = this.getParameter("methods");
        if (StringUtils.isNotEmpty(methodsString) && !methodsString.contains(method)) {
            return false;
        }
        for (Map.Entry<String, Map<String, String>> methods : this.METHOD_PARAMETERS.entrySet()) {
            if (!methods.getValue().containsKey(method)) continue;
            return true;
        }
        return false;
    }

    public String getMethodParameter(String method, String key) {
        String strictResult = this.getMethodParameterStrict(method, key);
        return StringUtils.isNotEmpty(strictResult) ? strictResult : this.getParameter(key);
    }

    public String getMethodParameterStrict(String method, String key) {
        String methodsString = this.getParameter("methods");
        if (StringUtils.isNotEmpty(methodsString) && !methodsString.contains(method)) {
            return null;
        }
        Map<String, String> methodMap = this.METHOD_PARAMETERS.get(key);
        if (CollectionUtils.isNotEmptyMap(methodMap)) {
            return methodMap.get(method);
        }
        return null;
    }

    public static Map<String, Map<String, String>> initMethodParameters(Map<String, String> parameters) {
        HashMap<String, Map<String, String>> methodParameters = new HashMap<String, Map<String, String>>();
        if (parameters == null) {
            return methodParameters;
        }
        String methodsString = parameters.get("methods");
        if (StringUtils.isNotEmpty(methodsString)) {
            String[] methods = methodsString.split(",");
            for (Map.Entry<String, String> entry : parameters.entrySet()) {
                String key = entry.getKey();
                for (String method : methods) {
                    String methodPrefix = method + '.';
                    if (!key.startsWith(methodPrefix)) continue;
                    String realKey = key.substring(methodPrefix.length());
                    URL.putMethodParameter(method, realKey, entry.getValue(), methodParameters);
                }
            }
        } else {
            for (Map.Entry<String, String> entry : parameters.entrySet()) {
                String key = entry.getKey();
                int methodSeparator = key.indexOf(46);
                if (methodSeparator <= 0) continue;
                String method = key.substring(0, methodSeparator);
                String realKey = key.substring(methodSeparator + 1);
                URL.putMethodParameter(method, realKey, entry.getValue(), methodParameters);
            }
        }
        return methodParameters;
    }

    public Map<String, String> getParameters() {
        return new URLParamMap(this);
    }

    public String getAnyMethodParameter(String key) {
        Map<String, String> methodMap = this.METHOD_PARAMETERS.get(key);
        if (CollectionUtils.isNotEmptyMap(methodMap)) {
            String methods = this.getParameter("methods");
            if (StringUtils.isNotEmpty(methods)) {
                for (String method : methods.split(",")) {
                    String value = methodMap.get(method);
                    if (!StringUtils.isNotEmpty(value)) continue;
                    return value;
                }
            } else {
                return methodMap.values().iterator().next();
            }
        }
        return null;
    }

    public URLParam addParameter(String key, String value) {
        if (StringUtils.isEmpty(key) || StringUtils.isEmpty(value)) {
            return this;
        }
        return this.addParameters(Collections.singletonMap(key, value));
    }

    public URLParam addParameterIfAbsent(String key, String value) {
        if (StringUtils.isEmpty(key) || StringUtils.isEmpty(value)) {
            return this;
        }
        if (this.hasParameter(key)) {
            return this;
        }
        return this.addParametersIfAbsent(Collections.singletonMap(key, value));
    }

    public URLParam addParameters(Map<String, String> parameters) {
        if (CollectionUtils.isEmptyMap(parameters)) {
            return this;
        }
        boolean hasAndEqual = true;
        Map<String, String> urlParamMap = this.getParameters();
        for (Map.Entry<String, String> entry : parameters.entrySet()) {
            String value = urlParamMap.get(entry.getKey());
            if (value == null) {
                if (entry.getValue() == null) continue;
                hasAndEqual = false;
                break;
            }
            if (value.equals(entry.getValue())) continue;
            hasAndEqual = false;
            break;
        }
        if (hasAndEqual) {
            return this;
        }
        return this.doAddParameters(parameters, false);
    }

    public URLParam addParametersIfAbsent(Map<String, String> parameters) {
        if (CollectionUtils.isEmptyMap(parameters)) {
            return this;
        }
        return this.doAddParameters(parameters, true);
    }

    private URLParam doAddParameters(Map<String, String> parameters, boolean skipIfPresent) {
        BitSet newKey = null;
        int[] newValueArray = null;
        Map<Integer, Integer> newValueMap = null;
        Map<String, String> newExtraParams = null;
        Map<String, Map<String, String>> newMethodParams = null;
        for (Map.Entry<String, String> entry : parameters.entrySet()) {
            if (skipIfPresent && this.hasParameter(entry.getKey()) || entry.getKey() == null || entry.getValue() == null) continue;
            int keyIndex = DynamicParamTable.getKeyIndex(this.enableCompressed, entry.getKey());
            if (keyIndex < 0) {
                if (newExtraParams == null) {
                    newExtraParams = new HashMap<String, String>(this.EXTRA_PARAMS);
                }
                newExtraParams.put(entry.getKey(), entry.getValue());
                String[] methodSplit = entry.getKey().split("\\.");
                if (methodSplit.length != 2) continue;
                if (newMethodParams == null) {
                    newMethodParams = new HashMap<String, Map<String, String>>(this.METHOD_PARAMETERS);
                }
                Map methodMap = newMethodParams.computeIfAbsent(methodSplit[1], k -> new HashMap());
                methodMap.put(methodSplit[0], entry.getValue());
                continue;
            }
            if (this.KEY.get(keyIndex)) {
                if (parameters.size() > 1) {
                    if (newValueMap == null) {
                        newValueMap = this.recoverValue();
                    }
                    newValueMap.put(keyIndex, DynamicParamTable.getValueIndex(entry.getKey(), entry.getValue()));
                    continue;
                }
                newValueArray = this.replaceOffset(this.VALUE, this.keyIndexToIndex(this.KEY, keyIndex), DynamicParamTable.getValueIndex(entry.getKey(), entry.getValue()));
                continue;
            }
            if (newKey == null) {
                newKey = (BitSet)this.KEY.clone();
            }
            newKey.set(keyIndex);
            if (parameters.size() > 1) {
                if (newValueMap == null) {
                    newValueMap = this.recoverValue();
                }
                newValueMap.put(keyIndex, DynamicParamTable.getValueIndex(entry.getKey(), entry.getValue()));
                continue;
            }
            newValueArray = this.addByMove(this.VALUE, this.keyIndexToIndex(newKey, keyIndex), DynamicParamTable.getValueIndex(entry.getKey(), entry.getValue()));
        }
        if (newKey == null) {
            newKey = this.KEY;
        }
        if (newValueArray == null && newValueMap == null) {
            newValueArray = this.VALUE;
        }
        if (newExtraParams == null) {
            newExtraParams = this.EXTRA_PARAMS;
        }
        if (newMethodParams == null) {
            newMethodParams = this.METHOD_PARAMETERS;
        }
        if (newValueMap == null) {
            return new URLParam(newKey, newValueArray, newExtraParams, newMethodParams, null);
        }
        return new URLParam(newKey, newValueMap, newExtraParams, newMethodParams, null);
    }

    private Map<Integer, Integer> recoverValue() {
        HashMap<Integer, Integer> map = new HashMap<Integer, Integer>((int)((double)this.KEY.size() / 0.75) + 1);
        int i = this.KEY.nextSetBit(0);
        int offset = 0;
        while (i >= 0) {
            map.put(i, this.VALUE[offset++]);
            i = this.KEY.nextSetBit(i + 1);
        }
        return map;
    }

    private int[] addByMove(int[] array, int index, Integer value) {
        if (index < 0 || index > array.length) {
            throw new IllegalArgumentException();
        }
        int[] result = new int[array.length + 1];
        System.arraycopy(array, 0, result, 0, index);
        result[index] = value;
        System.arraycopy(array, index, result, index + 1, array.length - index);
        return result;
    }

    private int[] replaceOffset(int[] array, int index, Integer value) {
        if (index < 0 || index > array.length) {
            throw new IllegalArgumentException();
        }
        int[] result = new int[array.length];
        System.arraycopy(array, 0, result, 0, array.length);
        result[index] = value;
        return result;
    }

    public URLParam removeParameters(String ... keys) {
        if (keys == null || keys.length == 0) {
            return this;
        }
        BitSet newKey = null;
        int[] newValueArray = null;
        Map<String, String> newExtraParams = null;
        Map<String, Map<String, String>> newMethodParams = null;
        for (String key : keys) {
            Map<String, String> methodMap;
            int keyIndex = DynamicParamTable.getKeyIndex(this.enableCompressed, key);
            if (keyIndex >= 0 && this.KEY.get(keyIndex)) {
                if (newKey == null) {
                    newKey = (BitSet)this.KEY.clone();
                }
                newKey.clear(keyIndex);
                if (newValueArray == null) {
                    newValueArray = new int[this.VALUE.length];
                    System.arraycopy(this.VALUE, 0, newValueArray, 0, this.VALUE.length);
                }
                newValueArray[this.keyIndexToIndex((BitSet)this.KEY, (int)keyIndex)] = -1;
            }
            if (!this.EXTRA_PARAMS.containsKey(key)) continue;
            if (newExtraParams == null) {
                newExtraParams = new HashMap<String, String>(this.EXTRA_PARAMS);
            }
            newExtraParams.remove(key);
            String[] methodSplit = key.split("\\.");
            if (methodSplit.length != 2) continue;
            if (newMethodParams == null) {
                newMethodParams = new HashMap<String, Map<String, String>>(this.METHOD_PARAMETERS);
            }
            if (!CollectionUtils.isNotEmptyMap(methodMap = newMethodParams.get(methodSplit[1]))) continue;
            methodMap.remove(methodSplit[0]);
        }
        if (newKey == null) {
            newKey = this.KEY;
        }
        newValueArray = newValueArray == null ? this.VALUE : this.compressArray(newValueArray);
        if (newExtraParams == null) {
            newExtraParams = this.EXTRA_PARAMS;
        }
        if (newMethodParams == null) {
            newMethodParams = this.METHOD_PARAMETERS;
        }
        if (newKey.cardinality() + newExtraParams.size() == 0) {
            return EMPTY_PARAM;
        }
        return new URLParam(newKey, newValueArray, newExtraParams, newMethodParams, null);
    }

    private int[] compressArray(int[] array) {
        int total = 0;
        for (int i : array) {
            if (i <= -1) continue;
            ++total;
        }
        if (total == 0) {
            return new int[0];
        }
        int[] result = new int[total];
        int offset = 0;
        for (int i = 0; i < array.length; ++i) {
            if (array[i] <= -1) continue;
            result[offset++] = array[i];
        }
        return result;
    }

    public URLParam clearParameters() {
        return EMPTY_PARAM;
    }

    public boolean hasParameter(String key) {
        int keyIndex = DynamicParamTable.getKeyIndex(this.enableCompressed, key);
        if (keyIndex < 0) {
            return this.EXTRA_PARAMS.containsKey(key);
        }
        return this.KEY.get(keyIndex);
    }

    public String getParameter(String key) {
        int keyIndex = DynamicParamTable.getKeyIndex(this.enableCompressed, key);
        if (keyIndex < 0) {
            return this.EXTRA_PARAMS.get(key);
        }
        if (this.KEY.get(keyIndex)) {
            int offset = this.keyIndexToOffset(keyIndex);
            String value = DynamicParamTable.getValue(keyIndex, offset);
            return value;
        }
        return null;
    }

    private int keyIndexToIndex(BitSet key, int keyIndex) {
        return key.get(0, keyIndex).cardinality();
    }

    private int keyIndexToOffset(int keyIndex) {
        int arrayOffset = this.keyIndexToIndex(this.KEY, keyIndex);
        return this.VALUE[arrayOffset];
    }

    public String getRawParam() {
        return this.toString();
    }

    protected Map<String, Map<String, String>> getMethodParameters() {
        return this.METHOD_PARAMETERS;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        URLParam urlParam = (URLParam)o;
        if (Objects.equals(this.KEY, urlParam.KEY) && Arrays.equals(this.VALUE, urlParam.VALUE)) {
            if (CollectionUtils.isNotEmptyMap(this.EXTRA_PARAMS)) {
                if (CollectionUtils.isEmptyMap(urlParam.EXTRA_PARAMS) || this.EXTRA_PARAMS.size() != urlParam.EXTRA_PARAMS.size()) {
                    return false;
                }
                for (Map.Entry<String, String> entry : this.EXTRA_PARAMS.entrySet()) {
                    if ("timestamp".equals(entry.getKey()) || entry.getValue().equals(urlParam.EXTRA_PARAMS.get(entry.getKey()))) continue;
                    return false;
                }
                return true;
            }
            return CollectionUtils.isEmptyMap(urlParam.EXTRA_PARAMS);
        }
        return false;
    }

    public int hashCode() {
        if (this.hashCodeCache == -1) {
            for (Map.Entry<String, String> entry : this.EXTRA_PARAMS.entrySet()) {
                if ("timestamp".equals(entry.getKey())) continue;
                this.hashCodeCache = this.hashCodeCache * 31 + Objects.hashCode(entry);
            }
            Object object = this.VALUE;
            int n = ((Object)object).length;
            for (int i = 0; i < n; ++i) {
                Integer value = (int)object[i];
                this.hashCodeCache = this.hashCodeCache * 31 + value;
            }
            this.hashCodeCache = this.hashCodeCache * 31 + (this.KEY == null ? 0 : this.KEY.hashCode());
        }
        return this.hashCodeCache;
    }

    public String toString() {
        if (StringUtils.isNotEmpty(this.rawParam)) {
            return this.rawParam;
        }
        if (this.KEY.cardinality() + this.EXTRA_PARAMS.size() == 0) {
            return "";
        }
        StringJoiner stringJoiner = new StringJoiner("&");
        int i = this.KEY.nextSetBit(0);
        while (i >= 0) {
            String key = DynamicParamTable.getKey(i);
            String value = DynamicParamTable.getValue(i, this.keyIndexToOffset(i));
            value = value == null ? "" : value.trim();
            stringJoiner.add(String.format("%s=%s", key, value));
            i = this.KEY.nextSetBit(i + 1);
        }
        for (Map.Entry<String, String> entry : this.EXTRA_PARAMS.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            value = value == null ? "" : value.trim();
            stringJoiner.add(String.format("%s=%s", key, value));
        }
        return stringJoiner.toString();
    }

    public static URLParam parse(Map<String, String> params) {
        return URLParam.parse(params, null);
    }

    public static URLParam parse(String rawParam, boolean encoded, Map<String, String> extraParameters) {
        Map<String, String> parameters = URLStrParser.parseParams(rawParam, encoded);
        if (CollectionUtils.isNotEmptyMap(extraParameters)) {
            parameters.putAll(extraParameters);
        }
        return URLParam.parse(parameters, rawParam);
    }

    public static URLParam parse(String rawParam) {
        String[] parts = rawParam.split("&");
        int capacity = (int)((float)parts.length / 0.75f) + 1;
        BitSet keyBit = new BitSet(capacity);
        HashMap<Integer, Integer> valueMap = new HashMap<Integer, Integer>(capacity);
        HashMap<String, String> extraParam = new HashMap<String, String>(capacity);
        HashMap<String, Map<String, String>> methodParameters = new HashMap<String, Map<String, String>>(capacity);
        for (String part : parts) {
            if ((part = part.trim()).length() <= 0) continue;
            int j = part.indexOf(61);
            if (j >= 0) {
                String key = part.substring(0, j);
                String value = part.substring(j + 1);
                URLParam.addParameter(keyBit, valueMap, extraParam, methodParameters, key, value, false);
                if (!key.startsWith("default.")) continue;
                URLParam.addParameter(keyBit, valueMap, extraParam, methodParameters, key.substring("default.".length()), value, true);
                continue;
            }
            URLParam.addParameter(keyBit, valueMap, extraParam, methodParameters, part, part, false);
        }
        return new URLParam(keyBit, valueMap, extraParam, methodParameters, rawParam);
    }

    public static URLParam parse(Map<String, String> params, String rawParam) {
        if (CollectionUtils.isNotEmptyMap(params)) {
            int capacity = (int)((float)params.size() / 0.75f) + 1;
            BitSet keyBit = new BitSet(capacity);
            HashMap<Integer, Integer> valueMap = new HashMap<Integer, Integer>(capacity);
            HashMap<String, String> extraParam = new HashMap<String, String>(capacity);
            HashMap<String, Map<String, String>> methodParameters = new HashMap<String, Map<String, String>>(capacity);
            for (Map.Entry<String, String> entry : params.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                URLParam.addParameter(keyBit, valueMap, extraParam, methodParameters, key, value, false);
                if (!key.startsWith("default.")) continue;
                URLParam.addParameter(keyBit, valueMap, extraParam, methodParameters, key.substring("default.".length()), value, true);
            }
            return new URLParam(keyBit, valueMap, extraParam, methodParameters, rawParam);
        }
        return EMPTY_PARAM;
    }

    private static void addParameter(BitSet keyBit, Map<Integer, Integer> valueMap, Map<String, String> extraParam, Map<String, Map<String, String>> methodParameters, String key, String value, boolean skipIfPresent) {
        int keyIndex = DynamicParamTable.getKeyIndex(true, key);
        if (skipIfPresent && (keyIndex < 0 ? extraParam.containsKey(key) : keyBit.get(keyIndex))) {
            return;
        }
        if (keyIndex < 0) {
            extraParam.put(key, value);
            String[] methodSplit = key.split("\\.", 2);
            if (methodSplit.length == 2) {
                Map methodMap = methodParameters.computeIfAbsent(methodSplit[1], k -> new HashMap());
                methodMap.put(methodSplit[0], value);
            }
        } else {
            valueMap.put(keyIndex, DynamicParamTable.getValueIndex(key, value));
            keyBit.set(keyIndex);
        }
    }

    public static class URLParamMap
    extends AbstractMap<String, String> {
        private URLParam urlParam;

        public URLParamMap(URLParam urlParam) {
            this.urlParam = urlParam;
        }

        @Override
        public int size() {
            return this.urlParam.KEY.cardinality() + this.urlParam.EXTRA_PARAMS.size();
        }

        @Override
        public boolean isEmpty() {
            return this.size() == 0;
        }

        @Override
        public boolean containsKey(Object key) {
            if (key instanceof String) {
                return this.urlParam.hasParameter((String)key);
            }
            return false;
        }

        @Override
        public boolean containsValue(Object value) {
            return this.values().contains(value);
        }

        @Override
        public String get(Object key) {
            if (key instanceof String) {
                return this.urlParam.getParameter((String)key);
            }
            return null;
        }

        @Override
        public String put(String key, String value) {
            String previous = this.urlParam.getParameter(key);
            this.urlParam = this.urlParam.addParameter(key, value);
            return previous;
        }

        @Override
        public String remove(Object key) {
            if (key instanceof String) {
                String previous = this.urlParam.getParameter((String)key);
                this.urlParam = this.urlParam.removeParameters((String)key);
                return previous;
            }
            return null;
        }

        @Override
        public void putAll(Map<? extends String, ? extends String> m) {
            this.urlParam = this.urlParam.addParameters(m);
        }

        @Override
        public void clear() {
            this.urlParam = this.urlParam.clearParameters();
        }

        @Override
        public Set<String> keySet() {
            LinkedHashSet<String> set = new LinkedHashSet<String>((int)((double)(this.urlParam.VALUE.length + this.urlParam.EXTRA_PARAMS.size()) / 0.75) + 1);
            int i = this.urlParam.KEY.nextSetBit(0);
            while (i >= 0) {
                set.add(DynamicParamTable.getKey(i));
                i = this.urlParam.KEY.nextSetBit(i + 1);
            }
            for (Map.Entry entry : this.urlParam.EXTRA_PARAMS.entrySet()) {
                set.add((String)entry.getKey());
            }
            return Collections.unmodifiableSet(set);
        }

        @Override
        public Collection<String> values() {
            LinkedHashSet<String> set = new LinkedHashSet<String>((int)((double)(this.urlParam.VALUE.length + this.urlParam.EXTRA_PARAMS.size()) / 0.75) + 1);
            int i = this.urlParam.KEY.nextSetBit(0);
            while (i >= 0) {
                int offset = this.urlParam.keyIndexToOffset(i);
                String value = DynamicParamTable.getValue(i, offset);
                set.add(value);
                i = this.urlParam.KEY.nextSetBit(i + 1);
            }
            for (Map.Entry entry : this.urlParam.EXTRA_PARAMS.entrySet()) {
                set.add((String)entry.getValue());
            }
            return Collections.unmodifiableSet(set);
        }

        @Override
        public Set<Map.Entry<String, String>> entrySet() {
            LinkedHashSet<Node> set = new LinkedHashSet<Node>((int)((double)(this.urlParam.KEY.cardinality() + this.urlParam.EXTRA_PARAMS.size()) / 0.75) + 1);
            int i = this.urlParam.KEY.nextSetBit(0);
            while (i >= 0) {
                int offset = this.urlParam.keyIndexToOffset(i);
                String value = DynamicParamTable.getValue(i, offset);
                set.add(new Node(DynamicParamTable.getKey(i), value));
                i = this.urlParam.KEY.nextSetBit(i + 1);
            }
            for (Map.Entry entry : this.urlParam.EXTRA_PARAMS.entrySet()) {
                set.add(new Node((String)entry.getKey(), (String)entry.getValue()));
            }
            return Collections.unmodifiableSet(set);
        }

        public URLParam getUrlParam() {
            return this.urlParam;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            URLParamMap that = (URLParamMap)o;
            return Objects.equals(this.urlParam, that.urlParam);
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.urlParam);
        }

        public static class Node
        implements Map.Entry<String, String> {
            private final String key;
            private String value;

            public Node(String key, String value) {
                this.key = key;
                this.value = value;
            }

            @Override
            public String getKey() {
                return this.key;
            }

            @Override
            public String getValue() {
                return this.value;
            }

            @Override
            public String setValue(String value) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                Node node = (Node)o;
                return Objects.equals(this.key, node.key) && Objects.equals(this.value, node.value);
            }

            @Override
            public int hashCode() {
                return Objects.hash(this.key, this.value);
            }
        }
    }
}

