/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.config;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.MethodDescriptor;
import java.beans.PropertyDescriptor;
import java.beans.Transient;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.config.ConfigurationUtils;
import org.apache.dubbo.common.config.Environment;
import org.apache.dubbo.common.config.InmemoryConfiguration;
import org.apache.dubbo.common.extension.ExtensionLoader;
import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.ClassUtils;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.common.utils.ConcurrentHashMapUtils;
import org.apache.dubbo.common.utils.FieldUtils;
import org.apache.dubbo.common.utils.MethodUtils;
import org.apache.dubbo.common.utils.ReflectUtils;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.common.utils.ToStringUtils;
import org.apache.dubbo.config.Constants;
import org.apache.dubbo.config.context.ConfigManager;
import org.apache.dubbo.config.context.ConfigMode;
import org.apache.dubbo.config.support.Nested;
import org.apache.dubbo.config.support.Parameter;
import org.apache.dubbo.rpc.model.ApplicationModel;
import org.apache.dubbo.rpc.model.FrameworkModel;
import org.apache.dubbo.rpc.model.ModuleModel;
import org.apache.dubbo.rpc.model.ScopeModel;
import org.apache.dubbo.rpc.model.ScopeModelUtil;

public abstract class AbstractConfig
implements Serializable {
    private static final long serialVersionUID = 4267533505537413570L;
    protected static final ErrorTypeAwareLogger logger = LoggerFactory.getErrorTypeAwareLogger(AbstractConfig.class);
    private static final ConcurrentMap<Class, String> tagNameCache = new ConcurrentHashMap<Class, String>();
    private static final ConcurrentMap<Class, List<Method>> attributedMethodCache = new ConcurrentHashMap<Class, List<Method>>();
    private static final String[] SUFFIXES = new String[]{"Config", "Bean", "ConfigBase"};
    private String id;
    protected final AtomicBoolean refreshed = new AtomicBoolean(false);
    protected volatile transient boolean needRefresh = true;
    protected Boolean isDefault;
    private volatile transient ScopeModel scopeModel;

    public AbstractConfig() {
        this(null);
    }

    public AbstractConfig(ScopeModel scopeModel) {
        this.setScopeModel(scopeModel);
    }

    public static String getTagName(Class<?> cls) {
        return ConcurrentHashMapUtils.computeIfAbsent(tagNameCache, cls, key -> {
            String tag = cls.getSimpleName();
            for (String suffix : SUFFIXES) {
                if (!tag.endsWith(suffix)) continue;
                tag = tag.substring(0, tag.length() - suffix.length());
                break;
            }
            return StringUtils.camelToSplitName(tag, "-");
        });
    }

    public static String getPluralTagName(Class<?> cls) {
        String tagName = AbstractConfig.getTagName(cls);
        if (tagName.endsWith("y")) {
            return tagName.substring(0, tagName.length() - 1) + "ies";
        }
        if (tagName.endsWith("s")) {
            return tagName + "es";
        }
        return tagName + "s";
    }

    public static void appendParameters(Map<String, String> parameters, Object config) {
        AbstractConfig.appendParameters(parameters, config, null);
    }

    public static void appendParameters(Map<String, String> parameters, Object config, String prefix) {
        AbstractConfig.appendParameters0(parameters, config, prefix, true);
    }

    public static void appendAttributes(Map<String, String> parameters, Object config) {
        AbstractConfig.appendParameters0(parameters, config, null, false);
    }

    public static void appendAttributes(Map<String, String> parameters, Object config, String prefix) {
        AbstractConfig.appendParameters0(parameters, config, prefix, false);
    }

    private static void appendParameters0(Map<String, String> parameters, Object config, String prefix, boolean asParameters) {
        if (config == null) {
            return;
        }
        BeanInfo beanInfo = AbstractConfig.getBeanInfo(config.getClass());
        for (MethodDescriptor methodDescriptor : beanInfo.getMethodDescriptors()) {
            Method method = methodDescriptor.getMethod();
            try {
                String name = method.getName();
                if (MethodUtils.isGetter(method)) {
                    String key;
                    if (method.getReturnType() == Object.class) continue;
                    Parameter parameter = method.getAnnotation(Parameter.class);
                    if (asParameters) {
                        if (parameter != null && parameter.excluded()) continue;
                        key = parameter != null && parameter.key().length() > 0 ? parameter.key() : AbstractConfig.calculatePropertyFromGetter(name);
                    } else {
                        if (parameter != null && !parameter.attribute()) continue;
                        String propertyName = AbstractConfig.calculateAttributeFromGetter(name);
                        key = StringUtils.convertToSplitName(propertyName, "-");
                    }
                    Object value = method.invoke(config, new Object[0]);
                    String str = String.valueOf(value).trim();
                    if (value != null && str.length() > 0) {
                        String pre;
                        if (asParameters && parameter != null && parameter.escaped()) {
                            str = URL.encode(str);
                        }
                        if (parameter != null && parameter.append() && (pre = parameters.get(key)) != null && pre.length() > 0) {
                            str = pre + "," + str;
                            Set<String> set = StringUtils.splitToSet(str, ',');
                            str = StringUtils.join(set, ",");
                        }
                        if (prefix != null && prefix.length() > 0) {
                            key = prefix + "." + key;
                        }
                        parameters.put(key, str);
                        continue;
                    }
                    if (!asParameters || parameter == null || !parameter.required()) continue;
                    throw new IllegalStateException(config.getClass().getSimpleName() + "." + key + " == null");
                }
                if (AbstractConfig.isParametersGetter(method)) {
                    Map<String, String> map = (Map<String, String>)method.invoke(config, new Object[0]);
                    map = AbstractConfig.convert(map, prefix);
                    if (asParameters) {
                        parameters.putAll(map);
                        continue;
                    }
                    String key = AbstractConfig.calculatePropertyFromGetter(name);
                    String encodeParameters = StringUtils.encodeParameters(map);
                    if (encodeParameters == null) continue;
                    parameters.put(key, encodeParameters);
                    continue;
                }
                if (!AbstractConfig.isNestedGetter(config, method)) continue;
                Object inner = method.invoke(config, new Object[0]);
                String fieldName = MethodUtils.extractFieldName(method);
                String nestedPrefix = prefix == null ? fieldName : prefix + "." + fieldName;
                AbstractConfig.appendParameters0(parameters, inner, nestedPrefix, asParameters);
            }
            catch (Exception e) {
                throw new IllegalStateException("Append parameters failed: " + e.getMessage(), e);
            }
        }
    }

    protected static String extractPropertyName(String setter) {
        String propertyName = setter.substring("set".length());
        propertyName = propertyName.substring(0, 1).toLowerCase() + propertyName.substring(1);
        return propertyName;
    }

    private static String calculatePropertyToGetter(String name) {
        return "get" + name.substring(0, 1).toUpperCase() + name.substring(1);
    }

    private static String calculatePropertyToSetter(String name) {
        return "set" + name.substring(0, 1).toUpperCase() + name.substring(1);
    }

    private static String calculatePropertyFromGetter(String name) {
        int i = name.startsWith("get") ? 3 : 2;
        return StringUtils.camelToSplitName(name.substring(i, i + 1).toLowerCase() + name.substring(i + 1), ".");
    }

    private static String calculateAttributeFromGetter(String getter) {
        int i = getter.startsWith("get") ? 3 : 2;
        return getter.substring(i, i + 1).toLowerCase() + getter.substring(i + 1);
    }

    private static void invokeSetParameters(Class c, Object o, Map map) {
        try {
            Method method = ReflectUtils.findMethodByMethodSignature(c, "setParameters", new String[]{Map.class.getName()});
            if (method != null && AbstractConfig.isParametersSetter(method)) {
                method.invoke(o, map);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static Map<String, String> invokeGetParameters(Class c, Object o) {
        try {
            Method method = ReflectUtils.findMethodByMethodSignature(c, "getParameters", null);
            if (method != null && AbstractConfig.isParametersGetter(method)) {
                return (Map)method.invoke(o, new Object[0]);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    private static boolean isParametersGetter(Method method) {
        String name = method.getName();
        return "getParameters".equals(name) && Modifier.isPublic(method.getModifiers()) && method.getParameterTypes().length == 0 && method.getReturnType() == Map.class;
    }

    private static boolean isPropertySetter(Method method) {
        String name = method.getName();
        if (name.startsWith("set") && name.length() > 3 && Modifier.isPublic(method.getModifiers()) && method.getParameterCount() == 1) {
            Class<?> paramType = method.getParameterTypes()[0];
            if (paramType.isArray()) {
                Class<?> componentType = paramType.getComponentType();
                return componentType.isPrimitive() || ClassUtils.isSimpleType(componentType);
            }
            return paramType.isPrimitive() || ClassUtils.isSimpleType(paramType);
        }
        return false;
    }

    private static boolean isParametersSetter(Method method) {
        return "setParameters".equals(method.getName()) && Modifier.isPublic(method.getModifiers()) && method.getParameterCount() == 1 && Map.class == method.getParameterTypes()[0] && method.getReturnType() == Void.TYPE;
    }

    private static boolean isNestedGetter(Object obj, Method method) {
        boolean isGetter;
        String name = method.getName();
        boolean bl = isGetter = (name.startsWith("get") || name.startsWith("is")) && !"get".equals(name) && !"is".equals(name) && !"getClass".equals(name) && !"getObject".equals(name) && Modifier.isPublic(method.getModifiers()) && method.getParameterTypes().length == 0 && !method.getReturnType().isPrimitive() && !ClassUtils.isSimpleType(method.getReturnType());
        if (!isGetter) {
            return false;
        }
        String fieldName = MethodUtils.extractFieldName(method);
        Field field = FieldUtils.getDeclaredField(obj.getClass(), fieldName);
        return field != null && field.isAnnotationPresent(Nested.class);
    }

    private static boolean isNestedSetter(Object obj, Method method) {
        boolean isSetter;
        boolean bl = isSetter = method.getName().startsWith("set") && !"set".equals(method.getName()) && Modifier.isPublic(method.getModifiers()) && method.getParameterCount() == 1 && method.getParameterTypes()[0] != null && !method.getParameterTypes()[0].isPrimitive() && !ClassUtils.isSimpleType(method.getParameterTypes()[0]);
        if (!isSetter) {
            return false;
        }
        String fieldName = MethodUtils.extractFieldName(method);
        Field field = FieldUtils.getDeclaredField(obj.getClass(), fieldName);
        return field != null && field.isAnnotationPresent(Nested.class);
    }

    protected static Map<String, String> convert(Map<String, String> parameters, String prefix) {
        if (parameters == null || parameters.isEmpty()) {
            return new HashMap<String, String>();
        }
        HashMap<String, String> result = new HashMap<String, String>();
        String pre = StringUtils.isNotEmpty(prefix) ? prefix + "." : "";
        for (Map.Entry<String, String> entry : parameters.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            result.put(pre + key, value);
            if (Arrays.binarySearch(Constants.DOT_COMPATIBLE_KEYS, key) < 0) continue;
            result.put(pre + key.replace('-', '.'), value);
        }
        return result;
    }

    @Transient
    public ApplicationModel getApplicationModel() {
        if (this.scopeModel == null) {
            this.setScopeModel(this.getDefaultModel());
        }
        if (this.scopeModel instanceof ApplicationModel) {
            return (ApplicationModel)this.scopeModel;
        }
        if (this.scopeModel instanceof ModuleModel) {
            return ((ModuleModel)this.scopeModel).getApplicationModel();
        }
        throw new IllegalStateException("scope model is invalid: " + this.scopeModel);
    }

    @Transient
    public ScopeModel getScopeModel() {
        if (this.scopeModel == null) {
            this.setScopeModel(this.getDefaultModel());
        }
        return this.scopeModel;
    }

    @Transient
    protected ScopeModel getDefaultModel() {
        return ApplicationModel.defaultModel();
    }

    public final void setScopeModel(ScopeModel scopeModel) {
        if (scopeModel != null && this.scopeModel != scopeModel) {
            this.checkScopeModel(scopeModel);
            ScopeModel oldScopeModel = this.scopeModel;
            this.scopeModel = scopeModel;
            this.postProcessAfterScopeModelChanged(oldScopeModel, this.scopeModel);
        }
    }

    protected void checkScopeModel(ScopeModel scopeModel) {
        if (!(scopeModel instanceof ApplicationModel)) {
            throw new IllegalArgumentException("Invalid scope model, expect to be a ApplicationModel but got: " + scopeModel);
        }
    }

    protected void postProcessAfterScopeModelChanged(ScopeModel oldScopeModel, ScopeModel newScopeModel) {
    }

    protected <T> ExtensionLoader<T> getExtensionLoader(Class<T> type) {
        if (this.scopeModel == null) {
            this.setScopeModel(this.getScopeModel());
        }
        return this.scopeModel.getExtensionLoader(type);
    }

    @Parameter(excluded=true)
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    protected void appendAnnotation(Class<?> annotationClass, Object annotation) {
        Method[] methods;
        for (Method method : methods = annotationClass.getMethods()) {
            if (method.getDeclaringClass() == Object.class || method.getDeclaringClass() == Annotation.class || method.getReturnType() == Void.TYPE || method.getParameterTypes().length != 0 || !Modifier.isPublic(method.getModifiers()) || Modifier.isStatic(method.getModifiers())) continue;
            try {
                String property = method.getName();
                if ("interfaceClass".equals(property) || "interfaceName".equals(property)) {
                    property = "interface";
                }
                String setter = AbstractConfig.calculatePropertyToSetter(property);
                Map<String, String> value = method.invoke(annotation, new Object[0]);
                if (value == null || ((Object)value).equals(method.getDefaultValue())) continue;
                Class<Object> parameterType = ReflectUtils.getBoxedClass(method.getReturnType());
                if ("filter".equals(property) || "listener".equals(property)) {
                    parameterType = String.class;
                    value = StringUtils.join((String[])value, ",");
                } else if ("parameters".equals(property)) {
                    parameterType = Map.class;
                    value = CollectionUtils.toStringMap((String[])value);
                }
                try {
                    Method setterMethod = this.getClass().getMethod(setter, parameterType);
                    setterMethod.invoke((Object)this, value);
                }
                catch (NoSuchMethodException noSuchMethodException) {}
            }
            catch (Throwable e) {
                logger.error("0-8", "", "", e.getMessage(), e);
            }
        }
    }

    @Transient
    public Map<String, String> getMetaData() {
        return this.getMetaData(null);
    }

    @Transient
    public Map<String, String> getMetaData(String prefix) {
        HashMap<String, String> metaData = new HashMap<String, String>();
        AbstractConfig.appendAttributes(metaData, this, prefix);
        return metaData;
    }

    private static BeanInfo getBeanInfo(Class cls) {
        BeanInfo beanInfo;
        try {
            beanInfo = Introspector.getBeanInfo(cls);
        }
        catch (IntrospectionException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
        return beanInfo;
    }

    private static boolean isWritableProperty(BeanInfo beanInfo, String key) {
        for (PropertyDescriptor propertyDescriptor : beanInfo.getPropertyDescriptors()) {
            if (!key.equals(propertyDescriptor.getName())) continue;
            return propertyDescriptor.getWriteMethod() != null;
        }
        return false;
    }

    @Parameter(excluded=true, attribute=false)
    @Transient
    public List<String> getPrefixes() {
        String prefix;
        String name;
        ArrayList<String> prefixes = new ArrayList<String>();
        if (StringUtils.hasText(this.getId())) {
            prefixes.add("dubbo." + AbstractConfig.getPluralTagName(this.getClass()) + "." + this.getId());
        }
        if (StringUtils.hasText(name = (String)ReflectUtils.getProperty(this, "getName")) && !prefixes.contains(prefix = "dubbo." + AbstractConfig.getPluralTagName(this.getClass()) + "." + name)) {
            prefixes.add(prefix);
        }
        prefixes.add(AbstractConfig.getTypePrefix(this.getClass()));
        return prefixes;
    }

    public static String getTypePrefix(Class<? extends AbstractConfig> cls) {
        return "dubbo." + AbstractConfig.getTagName(cls);
    }

    @Transient
    public ConfigMode getConfigMode() {
        return this.getApplicationModel().getApplicationConfigManager().getConfigMode();
    }

    public void overrideWithConfig(AbstractConfig newOne, boolean overrideAll) {
        if (!Objects.equals(this.getClass(), newOne.getClass())) {
            return;
        }
        List<Method> methods = MethodUtils.getMethods(this.getClass(), method -> method.getDeclaringClass() != Object.class);
        for (Method method2 : methods) {
            try {
                Object newResult;
                Object oldOne;
                Method getterMethod;
                try {
                    String propertyName = AbstractConfig.extractPropertyName(method2.getName());
                    String getterName = AbstractConfig.calculatePropertyToGetter(propertyName);
                    getterMethod = this.getClass().getMethod(getterName, new Class[0]);
                }
                catch (Exception ignore) {
                    continue;
                }
                if (MethodUtils.isSetter(method2)) {
                    oldOne = getterMethod.invoke((Object)this, new Object[0]);
                    if (!overrideAll && oldOne != null || (newResult = getterMethod.invoke((Object)newOne, new Object[0])) == null || Objects.equals(newResult, oldOne)) continue;
                    method2.invoke((Object)this, newResult);
                    continue;
                }
                if (AbstractConfig.isParametersSetter(method2)) {
                    oldOne = getterMethod.invoke((Object)this, new Object[0]);
                    newResult = getterMethod.invoke((Object)newOne, new Object[0]);
                    Map oldMap = null;
                    if (oldOne instanceof Map) {
                        oldMap = (Map)oldOne;
                    }
                    Map newMap = null;
                    if (newResult instanceof Map) {
                        newMap = (Map)newResult;
                    }
                    if (newMap == null) continue;
                    if (oldMap == null) {
                        this.invokeSetParameters(newMap, this);
                        continue;
                    }
                    if (overrideAll) {
                        oldMap.forEach(newMap::putIfAbsent);
                    } else {
                        newMap.putAll(oldMap);
                    }
                    this.invokeSetParameters(newMap, this);
                    continue;
                }
                if (!AbstractConfig.isNestedSetter(this, method2)) continue;
            }
            catch (Throwable t) {
                logger.error("0-24", "", "", "Failed to override field value of config bean: " + this, t);
                throw new IllegalStateException("Failed to override field value of config bean: " + this, t);
            }
        }
    }

    public void refresh() {
        if (this.needRefresh) {
            try {
                this.preProcessRefresh();
                this.refreshWithPrefixes(this.getPrefixes(), this.getConfigMode());
            }
            catch (Exception e) {
                logger.error("0-24", "", "", "Failed to override field value of config bean: " + this, e);
                throw new IllegalStateException("Failed to override field value of config bean: " + this, e);
            }
            this.postProcessRefresh();
        }
        this.refreshed.set(true);
    }

    protected void refreshWithPrefixes(List<String> prefixes, ConfigMode configMode) {
        Environment environment = this.getScopeModel().modelEnvironment();
        List configurationMaps = environment.getConfigurationMaps();
        String preferredPrefix = null;
        for (String prefix : prefixes) {
            if (!ConfigurationUtils.hasSubProperties(configurationMaps, prefix)) continue;
            preferredPrefix = prefix;
            break;
        }
        if (preferredPrefix == null) {
            preferredPrefix = prefixes.get(0);
        }
        List instanceConfigMaps = environment.getConfigurationMaps(this, preferredPrefix);
        Map<String, String> subProperties = ConfigurationUtils.getSubProperties(instanceConfigMaps, preferredPrefix);
        InmemoryConfiguration subPropsConfiguration = new InmemoryConfiguration(subProperties);
        if (logger.isDebugEnabled()) {
            String idOrName = "";
            if (StringUtils.hasText(this.getId())) {
                idOrName = "[id=" + this.getId() + "]";
            } else {
                String name = (String)ReflectUtils.getProperty(this, "getName");
                if (StringUtils.hasText(name)) {
                    idOrName = "[name=" + name + "]";
                }
            }
            logger.debug("Refreshing " + this.getClass().getSimpleName() + idOrName + " with prefix [" + preferredPrefix + "], extracted props: " + subProperties);
        }
        this.assignProperties(this, environment, subProperties, subPropsConfiguration, configMode);
        this.processExtraRefresh(preferredPrefix, subPropsConfiguration);
    }

    private void assignProperties(Object obj, Environment environment, Map<String, String> properties, InmemoryConfiguration configuration, ConfigMode configMode) {
        boolean overrideIfAbsent = configMode == ConfigMode.OVERRIDE_IF_ABSENT;
        boolean overrideAll = configMode == ConfigMode.OVERRIDE_ALL;
        FrameworkModel frameworkModel = ScopeModelUtil.getFrameworkModel(this.getScopeModel());
        List<Method> methods = MethodUtils.getMethods(obj.getClass(), method -> method.getDeclaringClass() != Object.class);
        for (Method method2 : methods) {
            String propertyName;
            Parameter parameter = method2.getAnnotation(Parameter.class);
            if (parameter != null && !parameter.attribute()) continue;
            if (AbstractConfig.isPropertySetter(method2)) {
                propertyName = AbstractConfig.extractPropertyName(method2.getName());
                if (overrideIfAbsent && this.isPropertySet(methods, propertyName)) continue;
                String kebabPropertyName = StringUtils.convertToSplitName(propertyName, "-");
                try {
                    Object arg;
                    String value = StringUtils.trim(configuration.getString(kebabPropertyName));
                    Class<?> paramType = method2.getParameterTypes()[0];
                    if (paramType.isArray()) {
                        int len;
                        if (this.isIgnoredAttribute(obj.getClass(), propertyName)) continue;
                        Class<?> itemType = paramType.getComponentType();
                        ArrayList<Object> items = new ArrayList<Object>();
                        if (StringUtils.hasText(value)) {
                            if (StringUtils.hasText(value = environment.resolvePlaceholders(value))) {
                                for (String item : StringUtils.tokenize(value, ',')) {
                                    items.add(ClassUtils.convertPrimitive(frameworkModel, itemType, item));
                                }
                            }
                        } else {
                            int i = 0;
                            while ((value = StringUtils.trim(configuration.getString(kebabPropertyName + '[' + i + ']'))) != null) {
                                if (StringUtils.hasText(value) && StringUtils.hasText(value = environment.resolvePlaceholders(value))) {
                                    items.add(ClassUtils.convertPrimitive(frameworkModel, itemType, value));
                                }
                                ++i;
                            }
                        }
                        if ((len = items.size()) <= 0) continue;
                        Object array = Array.newInstance(itemType, len);
                        for (int i = 0; i < len; ++i) {
                            Array.set(array, i, items.get(i));
                        }
                        method2.invoke(obj, array);
                        continue;
                    }
                    if (!StringUtils.hasText(value) || !ClassUtils.isTypeMatch(paramType, value) || this.isIgnoredAttribute(obj.getClass(), propertyName) || !StringUtils.hasText(value = environment.resolvePlaceholders(value)) || (arg = ClassUtils.convertPrimitive(frameworkModel, paramType, value)) == null) continue;
                    method2.invoke(obj, arg);
                }
                catch (Exception e) {
                    logger.info("Failed to override the property " + method2.getName() + " in " + obj.getClass().getSimpleName() + ", please make sure every property has getter/setter method provided.");
                }
                continue;
            }
            if (AbstractConfig.isParametersSetter(method2)) {
                propertyName = AbstractConfig.extractPropertyName(method2.getName());
                String value = StringUtils.trim(configuration.getString(propertyName));
                Map<String, String> parameterMap = StringUtils.hasText(value) ? StringUtils.parseParameters(value) : ConfigurationUtils.getSubProperties(properties, "parameters");
                Map<String, String> newMap = AbstractConfig.convert(parameterMap, "");
                if (CollectionUtils.isEmptyMap(newMap)) continue;
                Map oldMap = null;
                try {
                    String getterName = AbstractConfig.calculatePropertyToGetter(propertyName);
                    Method getterMethod = this.getClass().getMethod(getterName, new Class[0]);
                    Object oldOne = getterMethod.invoke((Object)this, new Object[0]);
                    if (oldOne instanceof Map) {
                        oldMap = (Map)oldOne;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (oldMap == null) {
                    this.invokeSetParameters(newMap, obj);
                    continue;
                }
                if (overrideIfAbsent) {
                    newMap.putAll(oldMap);
                } else if (overrideAll) {
                    oldMap.forEach(newMap::putIfAbsent);
                }
                this.invokeSetParameters(newMap, obj);
                continue;
            }
            if (!AbstractConfig.isNestedSetter(obj, method2)) continue;
            try {
                Class<?> clazz = method2.getParameterTypes()[0];
                Object inner = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                String fieldName = MethodUtils.extractFieldName(method2);
                Map<String, String> subProperties = ConfigurationUtils.getSubProperties(properties, fieldName);
                InmemoryConfiguration subPropsConfiguration = new InmemoryConfiguration(subProperties);
                this.assignProperties(inner, environment, subProperties, subPropsConfiguration, configMode);
                method2.invoke(obj, inner);
            }
            catch (ReflectiveOperationException e) {
                throw new IllegalStateException("Cannot assign nested class when refreshing config: " + obj.getClass().getName(), e);
            }
        }
    }

    private boolean isPropertySet(List<Method> methods, String propertyName) {
        try {
            String getterName = AbstractConfig.calculatePropertyToGetter(propertyName);
            Method getterMethod = this.findGetMethod(methods, getterName);
            if (getterMethod == null) {
                return false;
            }
            Object oldOne = getterMethod.invoke((Object)this, new Object[0]);
            if (oldOne != null) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private Method findGetMethod(List<Method> methods, String methodName) {
        for (Method method : methods) {
            if (!method.getName().equals(methodName) || method.getParameterCount() != 0) continue;
            return method;
        }
        return null;
    }

    private void invokeSetParameters(Map<String, String> values, Object obj) {
        if (CollectionUtils.isEmptyMap(values)) {
            return;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        Map<String, String> getParametersMap = AbstractConfig.invokeGetParameters(obj.getClass(), obj);
        if (getParametersMap != null && !getParametersMap.isEmpty()) {
            map.putAll(getParametersMap);
        }
        map.putAll(values);
        AbstractConfig.invokeSetParameters(obj.getClass(), obj, map);
    }

    private boolean isIgnoredAttribute(Class<?> clazz, String propertyName) {
        Method getter = null;
        String capitalizePropertyName = propertyName.substring(0, 1).toUpperCase() + propertyName.substring(1);
        try {
            getter = clazz.getMethod("get" + capitalizePropertyName, new Class[0]);
        }
        catch (NoSuchMethodException e) {
            try {
                getter = clazz.getMethod("is" + capitalizePropertyName, new Class[0]);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        if (getter == null) {
            return true;
        }
        Parameter parameter = getter.getAnnotation(Parameter.class);
        return parameter != null && !parameter.attribute();
    }

    protected void processExtraRefresh(String preferredPrefix, InmemoryConfiguration subPropsConfiguration) {
    }

    protected void preProcessRefresh() {
    }

    protected void postProcessRefresh() {
        this.checkDefault();
    }

    protected void checkDefault() {
    }

    @Parameter(excluded=true, attribute=false)
    public boolean isRefreshed() {
        return this.refreshed.get();
    }

    @Parameter(excluded=true, attribute=false)
    public boolean isValid() {
        return true;
    }

    @Parameter(excluded=true, attribute=false)
    public Boolean isDefault() {
        return this.isDefault;
    }

    public void setDefault(Boolean isDefault) {
        this.isDefault = isDefault;
    }

    @Transient
    @Parameter(excluded=true, attribute=false)
    public boolean isNeedRefresh() {
        return this.needRefresh;
    }

    @Transient
    public void setNeedRefresh(boolean needRefresh) {
        this.needRefresh = needRefresh;
    }

    public String toString() {
        try {
            StringBuilder buf = new StringBuilder();
            buf.append("<dubbo:");
            buf.append(AbstractConfig.getTagName(this.getClass()));
            for (Method method : this.getAttributedMethods()) {
                try {
                    String name = method.getName();
                    String key = AbstractConfig.calculateAttributeFromGetter(name);
                    Object value = method.invoke((Object)this, new Object[0]);
                    if (value == null) continue;
                    buf.append(' ');
                    buf.append(key);
                    buf.append("=\"");
                    buf.append(key.equals("password") ? "******" : ToStringUtils.toString(value));
                    buf.append('\"');
                }
                catch (Exception e) {
                    logger.warn("0-12", "", "", e.getMessage(), e);
                }
            }
            buf.append(" />");
            return buf.toString();
        }
        catch (Throwable t) {
            logger.warn("0-12", "", "", t.getMessage(), t);
            return super.toString();
        }
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        for (Method method : this.getAttributedMethods()) {
            if ("getId".equals(method.getName())) continue;
            try {
                Object value2;
                Object value1 = method.invoke((Object)this, new Object[0]);
                if (Objects.equals(value1, value2 = method.invoke(obj, new Object[0]))) continue;
                return false;
            }
            catch (Exception e) {
                throw new IllegalStateException("compare config instances failed", e);
            }
        }
        return true;
    }

    public int hashCode() {
        int hashCode = 1;
        for (Method method : this.getAttributedMethods()) {
            if ("getId".equals(method.getName())) continue;
            try {
                Object value = method.invoke((Object)this, new Object[0]);
                if (value == null) continue;
                hashCode = 31 * hashCode + value.hashCode();
            }
            catch (Exception exception) {}
        }
        if (hashCode == 0) {
            hashCode = 1;
        }
        return hashCode;
    }

    @Transient
    private List<Method> getAttributedMethods() {
        Class<?> cls = this.getClass();
        return ConcurrentHashMapUtils.computeIfAbsent(attributedMethodCache, cls, key -> this.computeAttributedMethods());
    }

    protected List<Method> computeAttributedMethods() {
        Class<?> cls = this.getClass();
        BeanInfo beanInfo = AbstractConfig.getBeanInfo(cls);
        ArrayList<Method> methods = new ArrayList<Method>(beanInfo.getMethodDescriptors().length);
        for (MethodDescriptor methodDescriptor : beanInfo.getMethodDescriptors()) {
            String propertyName;
            Parameter parameter;
            Method method = methodDescriptor.getMethod();
            if (!MethodUtils.isGetter(method) && !AbstractConfig.isParametersGetter(method) || (parameter = method.getAnnotation(Parameter.class)) != null && !parameter.attribute() || !AbstractConfig.isWritableProperty(beanInfo, propertyName = AbstractConfig.calculateAttributeFromGetter(method.getName()))) continue;
            methods.add(method);
        }
        return methods;
    }

    @Transient
    protected ConfigManager getConfigManager() {
        return this.getApplicationModel().getApplicationConfigManager();
    }
}

