/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common.url.component;

import java.util.Map;
import org.apache.dubbo.common.utils.LRUCache;
import org.apache.dubbo.common.utils.StringUtils;

public class URLItemCache {
    private static final Map<String, String> PARAM_KEY_CACHE = new LRUCache<String, String>(10000);
    private static final Map<String, String> PARAM_VALUE_CACHE = new LRUCache<String, String>(50000);
    private static final Map<String, String> PATH_CACHE = new LRUCache<String, String>(10000);
    private static final Map<String, String> REVISION_CACHE = new LRUCache<String, String>(10000);

    public static void putParams(Map<String, String> params, String key, String value) {
        String cachedValue;
        String cachedKey = PARAM_KEY_CACHE.get(key);
        if (StringUtils.isBlank(cachedKey)) {
            cachedKey = key;
            PARAM_KEY_CACHE.put(key, key);
        }
        if (StringUtils.isBlank(cachedValue = PARAM_VALUE_CACHE.get(value))) {
            cachedValue = value;
            PARAM_VALUE_CACHE.put(value, value);
        }
        params.put(cachedKey, cachedValue);
    }

    public static String checkPath(String path) {
        if (StringUtils.isBlank(path)) {
            return path;
        }
        String cachedPath = PATH_CACHE.putIfAbsent(path, path);
        if (StringUtils.isNotBlank(cachedPath)) {
            return cachedPath;
        }
        return path;
    }

    public static String checkRevision(String revision) {
        if (StringUtils.isBlank(revision)) {
            return revision;
        }
        String cachedRevision = REVISION_CACHE.putIfAbsent(revision, revision);
        if (StringUtils.isNotBlank(cachedRevision)) {
            return cachedRevision;
        }
        return revision;
    }

    public static String intern(String protocol) {
        if (StringUtils.isBlank(protocol)) {
            return protocol;
        }
        return protocol.intern();
    }

    public static void putParamsIntern(Map<String, String> params, String key, String value) {
        if (StringUtils.isBlank(key) || StringUtils.isBlank(value)) {
            params.put(key, value);
            return;
        }
        key = key.intern();
        value = value.intern();
        params.put(key, value);
    }
}

