/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common.deploy;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.dubbo.common.deploy.DeployListener;
import org.apache.dubbo.common.deploy.DeployState;
import org.apache.dubbo.common.deploy.Deployer;
import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.rpc.model.ScopeModel;

public abstract class AbstractDeployer<E extends ScopeModel>
implements Deployer<E> {
    private static final ErrorTypeAwareLogger logger = LoggerFactory.getErrorTypeAwareLogger(AbstractDeployer.class);
    private volatile DeployState state = DeployState.PENDING;
    private volatile Throwable lastError;
    protected volatile boolean initialized = false;
    protected List<DeployListener<E>> listeners = new CopyOnWriteArrayList<DeployListener<E>>();
    private E scopeModel;

    public AbstractDeployer(E scopeModel) {
        this.scopeModel = scopeModel;
    }

    @Override
    public boolean isPending() {
        return this.state == DeployState.PENDING;
    }

    @Override
    public boolean isRunning() {
        return this.state == DeployState.STARTING || this.state == DeployState.STARTED;
    }

    @Override
    public boolean isStarted() {
        return this.state == DeployState.STARTED;
    }

    @Override
    public boolean isStarting() {
        return this.state == DeployState.STARTING;
    }

    @Override
    public boolean isStopping() {
        return this.state == DeployState.STOPPING;
    }

    @Override
    public boolean isStopped() {
        return this.state == DeployState.STOPPED;
    }

    @Override
    public boolean isFailed() {
        return this.state == DeployState.FAILED;
    }

    @Override
    public DeployState getState() {
        return this.state;
    }

    @Override
    public void addDeployListener(DeployListener<E> listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeDeployListener(DeployListener<E> listener) {
        this.listeners.remove(listener);
    }

    public void setPending() {
        this.state = DeployState.PENDING;
    }

    protected void setStarting() {
        this.state = DeployState.STARTING;
        for (DeployListener<E> listener : this.listeners) {
            try {
                listener.onStarting(this.scopeModel);
            }
            catch (Throwable e) {
                logger.error("0-14", "", "", this.getIdentifier() + " an exception occurred when handle starting event", e);
            }
        }
    }

    protected void setStarted() {
        this.state = DeployState.STARTED;
        for (DeployListener<E> listener : this.listeners) {
            try {
                listener.onStarted(this.scopeModel);
            }
            catch (Throwable e) {
                logger.error("0-14", "", "", this.getIdentifier() + " an exception occurred when handle started event", e);
            }
        }
    }

    protected void setStopping() {
        this.state = DeployState.STOPPING;
        for (DeployListener<E> listener : this.listeners) {
            try {
                listener.onStopping(this.scopeModel);
            }
            catch (Throwable e) {
                logger.error("0-14", "", "", this.getIdentifier() + " an exception occurred when handle stopping event", e);
            }
        }
    }

    protected void setStopped() {
        this.state = DeployState.STOPPED;
        for (DeployListener<E> listener : this.listeners) {
            try {
                listener.onStopped(this.scopeModel);
            }
            catch (Throwable e) {
                logger.error("0-14", "", "", this.getIdentifier() + " an exception occurred when handle stopped event", e);
            }
        }
    }

    protected void setFailed(Throwable error) {
        this.state = DeployState.FAILED;
        this.lastError = error;
        for (DeployListener<E> listener : this.listeners) {
            try {
                listener.onFailure(this.scopeModel, error);
            }
            catch (Throwable e) {
                logger.error("0-14", "", "", this.getIdentifier() + " an exception occurred when handle failed event", e);
            }
        }
    }

    @Override
    public Throwable getError() {
        return this.lastError;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    protected String getIdentifier() {
        return ((ScopeModel)this.scopeModel).getDesc();
    }
}

