/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common.config.configcenter;

import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.config.Configuration;
import org.apache.dubbo.common.config.configcenter.ConfigItem;
import org.apache.dubbo.common.config.configcenter.ConfigurationListener;

public interface DynamicConfiguration
extends Configuration,
AutoCloseable {
    public static final String DEFAULT_GROUP = "dubbo";

    default public void addListener(String key, ConfigurationListener listener) {
        this.addListener(key, this.getDefaultGroup(), listener);
    }

    default public void removeListener(String key, ConfigurationListener listener) {
        this.removeListener(key, this.getDefaultGroup(), listener);
    }

    public void addListener(String var1, String var2, ConfigurationListener var3);

    public void removeListener(String var1, String var2, ConfigurationListener var3);

    default public String getConfig(String key, String group) {
        return this.getConfig(key, group, this.getDefaultTimeout());
    }

    default public ConfigItem getConfigItem(String key, String group) {
        String content = this.getConfig(key, group);
        return new ConfigItem(content, null);
    }

    public String getConfig(String var1, String var2, long var3) throws IllegalStateException;

    default public String getProperties(String key, String group) throws IllegalStateException {
        return this.getProperties(key, group, this.getDefaultTimeout());
    }

    default public String getProperties(String key, String group, long timeout) throws IllegalStateException {
        return this.getConfig(key, group, timeout);
    }

    default public boolean publishConfig(String key, String content) throws UnsupportedOperationException {
        return this.publishConfig(key, this.getDefaultGroup(), content);
    }

    default public boolean publishConfig(String key, String group, String content) throws UnsupportedOperationException {
        return false;
    }

    default public boolean publishConfigCas(String key, String group, String content, Object ticket) throws UnsupportedOperationException {
        return false;
    }

    default public String getDefaultGroup() {
        return DEFAULT_GROUP;
    }

    default public long getDefaultTimeout() {
        return -1L;
    }

    @Override
    default public void close() throws Exception {
        throw new UnsupportedOperationException();
    }

    public static String getRuleKey(URL url) {
        return url.getColonSeparatedKey();
    }

    default public boolean removeConfig(String key, String group) {
        return true;
    }
}

