/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.model;

import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.dubbo.common.beans.factory.ScopeBeanFactory;
import org.apache.dubbo.common.config.Environment;
import org.apache.dubbo.common.extension.ExtensionAccessor;
import org.apache.dubbo.common.extension.ExtensionDirector;
import org.apache.dubbo.common.extension.ExtensionScope;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.ConcurrentHashSet;
import org.apache.dubbo.rpc.model.ScopeModelAwareExtensionProcessor;
import org.apache.dubbo.rpc.model.ScopeModelDestroyListener;

public abstract class ScopeModel
implements ExtensionAccessor {
    protected static final Logger LOGGER = LoggerFactory.getLogger(ScopeModel.class);
    private String internalName;
    private String modelName;
    private Set<ClassLoader> classLoaders;
    private final ScopeModel parent;
    private final ExtensionScope scope;
    private ExtensionDirector extensionDirector;
    private ScopeBeanFactory beanFactory;
    private List<ScopeModelDestroyListener> destroyListeners;
    private Map<String, Object> attributes;
    private AtomicBoolean destroyed = new AtomicBoolean(false);

    public ScopeModel(ScopeModel parent, ExtensionScope scope) {
        this.parent = parent;
        this.scope = scope;
    }

    protected void initialize() {
        this.extensionDirector = new ExtensionDirector(this.parent != null ? this.parent.getExtensionDirector() : null, this.scope, this);
        this.extensionDirector.addExtensionPostProcessor(new ScopeModelAwareExtensionProcessor(this));
        this.beanFactory = new ScopeBeanFactory(this.parent != null ? this.parent.getBeanFactory() : null, this.extensionDirector);
        this.destroyListeners = new LinkedList<ScopeModelDestroyListener>();
        this.attributes = new ConcurrentHashMap<String, Object>();
        this.classLoaders = new ConcurrentHashSet<ClassLoader>();
        ClassLoader dubboClassLoader = ScopeModel.class.getClassLoader();
        if (dubboClassLoader != null) {
            this.addClassLoader(dubboClassLoader);
        }
    }

    public void destroy() {
        if (this.destroyed.compareAndSet(false, true)) {
            try {
                this.onDestroy();
                HashSet<ClassLoader> copyOfClassLoaders = new HashSet<ClassLoader>(this.classLoaders);
                for (ClassLoader classLoader : copyOfClassLoaders) {
                    this.removeClassLoader(classLoader);
                }
            }
            catch (Throwable t) {
                LOGGER.error("Error happened when destroying ScopeModel.", t);
            }
        }
    }

    public boolean isDestroyed() {
        return this.destroyed.get();
    }

    protected void notifyDestroy() {
        for (ScopeModelDestroyListener destroyListener : this.destroyListeners) {
            destroyListener.onDestroy(this);
        }
    }

    protected abstract void onDestroy();

    public final void addDestroyListener(ScopeModelDestroyListener listener) {
        this.destroyListeners.add(listener);
    }

    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    public <T> T getAttribute(String key, Class<T> type) {
        return (T)this.attributes.get(key);
    }

    public Object getAttribute(String key) {
        return this.attributes.get(key);
    }

    public void setAttribute(String key, Object value) {
        this.attributes.put(key, value);
    }

    @Override
    public ExtensionDirector getExtensionDirector() {
        return this.extensionDirector;
    }

    public ScopeBeanFactory getBeanFactory() {
        return this.beanFactory;
    }

    public ScopeModel getParent() {
        return this.parent;
    }

    public String getInternalName() {
        return this.internalName;
    }

    protected void setInternalName(String internalName) {
        this.internalName = internalName;
        this.modelName = internalName;
    }

    public void addClassLoader(ClassLoader classLoader) {
        this.classLoaders.add(classLoader);
        if (this.parent != null) {
            this.parent.addClassLoader(classLoader);
        }
        this.extensionDirector.removeAllCachedLoader();
    }

    public void removeClassLoader(ClassLoader classLoader) {
        if (this.checkIfClassLoaderCanRemoved(classLoader)) {
            this.classLoaders.remove(classLoader);
            if (this.parent != null) {
                this.parent.removeClassLoader(classLoader);
            }
            this.extensionDirector.removeAllCachedLoader();
        }
    }

    protected boolean checkIfClassLoaderCanRemoved(ClassLoader classLoader) {
        return classLoader != null && !classLoader.equals(ScopeModel.class.getClassLoader());
    }

    public Set<ClassLoader> getClassLoaders() {
        return Collections.unmodifiableSet(this.classLoaders);
    }

    public abstract Environment getModelEnvironment();

    public String getInternalId() {
        if (this.internalName == null) {
            return null;
        }
        return this.internalName.substring(this.internalName.indexOf(45) + 1);
    }

    protected String buildInternalName(String type, String parentInternalId, long childIndex) {
        if (parentInternalId != null) {
            return type + "-" + parentInternalId + "." + childIndex;
        }
        return type + "-" + childIndex;
    }

    public String getModelName() {
        return this.modelName;
    }

    public void setModelName(String modelName) {
        this.modelName = modelName;
    }
}

