/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.dubbo.common.config.Environment;
import org.apache.dubbo.common.extension.ExtensionLoader;
import org.apache.dubbo.common.extension.ExtensionScope;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.resource.GlobalResourcesRepository;
import org.apache.dubbo.rpc.model.ApplicationModel;
import org.apache.dubbo.rpc.model.FrameworkServiceRepository;
import org.apache.dubbo.rpc.model.ScopeModel;
import org.apache.dubbo.rpc.model.ScopeModelInitializer;

public class FrameworkModel
extends ScopeModel {
    protected static final Logger LOGGER = LoggerFactory.getLogger(FrameworkModel.class);
    public static final String NAME = "FrameworkModel";
    private static final AtomicLong index = new AtomicLong(1L);
    private final AtomicLong appIndex = new AtomicLong(1L);
    private static volatile FrameworkModel defaultInstance;
    private static List<FrameworkModel> allInstances;
    private List<ApplicationModel> applicationModels = Collections.synchronizedList(new ArrayList());
    private FrameworkServiceRepository serviceRepository;

    public FrameworkModel() {
        super(null, ExtensionScope.FRAMEWORK);
        this.initialize();
        this.setInternalName(this.buildInternalName(NAME, null, index.getAndIncrement()));
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.serviceRepository = new FrameworkServiceRepository(this);
        allInstances.add(this);
        ExtensionLoader<ScopeModelInitializer> initializerExtensionLoader = this.getExtensionLoader(ScopeModelInitializer.class);
        Set<ScopeModelInitializer> initializers = initializerExtensionLoader.getSupportedExtensionInstances();
        for (ScopeModelInitializer initializer : initializers) {
            initializer.initializeFrameworkModel(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void onDestroy() {
        for (ApplicationModel applicationModel : new ArrayList<ApplicationModel>(this.applicationModels)) {
            applicationModel.destroy();
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Dubbo framework[" + this.getInternalId() + "] is destroying ...");
        }
        Class<FrameworkModel> clazz = FrameworkModel.class;
        synchronized (FrameworkModel.class) {
            allInstances.remove(this);
            if (defaultInstance == this) {
                defaultInstance = null;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            this.notifyDestroy();
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Dubbo framework[" + this.getInternalId() + "] is destroyed");
            }
            if (allInstances.isEmpty()) {
                this.destroyGlobalResources();
            }
            return;
        }
    }

    private void destroyGlobalResources() {
        GlobalResourcesRepository.getInstance().destroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static FrameworkModel defaultModel() {
        if (defaultInstance != null) return defaultInstance;
        Class<FrameworkModel> clazz = FrameworkModel.class;
        synchronized (FrameworkModel.class) {
            if (defaultInstance != null) return defaultInstance;
            defaultInstance = new FrameworkModel();
            // ** MonitorExit[var0] (shouldn't be in output)
            return defaultInstance;
        }
    }

    public static List<FrameworkModel> getAllInstances() {
        return Collections.unmodifiableList(allInstances);
    }

    public static void destroyAll() {
        for (FrameworkModel frameworkModel : new ArrayList<FrameworkModel>(allInstances)) {
            frameworkModel.destroy();
        }
    }

    public ApplicationModel newApplication() {
        return new ApplicationModel(this);
    }

    synchronized void addApplication(ApplicationModel applicationModel) {
        if (!this.applicationModels.contains(applicationModel)) {
            this.applicationModels.add(applicationModel);
            applicationModel.setInternalName(this.buildInternalName("ApplicationModel", this.getInternalId(), this.appIndex.getAndIncrement()));
        }
    }

    synchronized void removeApplication(ApplicationModel model) {
        this.applicationModels.remove(model);
    }

    synchronized void tryDestroy() {
        if (this.applicationModels.size() == 0) {
            this.destroy();
        }
    }

    public List<ApplicationModel> getApplicationModels() {
        return Collections.unmodifiableList(this.applicationModels);
    }

    public FrameworkServiceRepository getServiceRepository() {
        return this.serviceRepository;
    }

    @Override
    public Environment getModelEnvironment() {
        throw new UnsupportedOperationException("Environment is inaccessible for FrameworkModel");
    }

    @Override
    protected boolean checkIfClassLoaderCanRemoved(ClassLoader classLoader) {
        return super.checkIfClassLoaderCanRemoved(classLoader) && this.applicationModels.stream().noneMatch(applicationModel -> applicationModel.containsClassLoader(classLoader));
    }

    static {
        allInstances = Collections.synchronizedList(new ArrayList());
    }
}

