/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common.resource;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.resource.Disposable;
import org.apache.dubbo.common.utils.NamedThreadFactory;

public class GlobalResourcesRepository {
    private static final Logger logger = LoggerFactory.getLogger(GlobalResourcesRepository.class);
    private static volatile GlobalResourcesRepository instance;
    private volatile ExecutorService executorService;
    private final List<Disposable> oneoffDisposables = Collections.synchronizedList(new ArrayList());
    private final List<Disposable> reusedDisposables = Collections.synchronizedList(new ArrayList());

    private GlobalResourcesRepository() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static GlobalResourcesRepository getInstance() {
        if (instance != null) return instance;
        Class<GlobalResourcesRepository> clazz = GlobalResourcesRepository.class;
        synchronized (GlobalResourcesRepository.class) {
            if (instance != null) return instance;
            instance = new GlobalResourcesRepository();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public static ExecutorService getGlobalExecutorService() {
        return GlobalResourcesRepository.getInstance().getExecutorService();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExecutorService getExecutorService() {
        if (this.executorService == null || this.executorService.isShutdown()) {
            GlobalResourcesRepository globalResourcesRepository = this;
            synchronized (globalResourcesRepository) {
                if (this.executorService == null || this.executorService.isShutdown()) {
                    this.executorService = Executors.newCachedThreadPool(new NamedThreadFactory("Dubbo-global-shared-handler", true));
                }
            }
        }
        return this.executorService;
    }

    public void destroy() {
        if (logger.isInfoEnabled()) {
            logger.info("Destroying global resources ...");
        }
        if (this.executorService != null) {
            this.executorService.shutdownNow();
            this.executorService = null;
        }
        for (Disposable disposable : new ArrayList<Disposable>(this.reusedDisposables)) {
            try {
                disposable.destroy();
            }
            catch (Exception e) {
                logger.warn("destroy resources failed: " + e.getMessage(), e);
            }
        }
        for (Disposable disposable : new ArrayList<Disposable>(this.oneoffDisposables)) {
            try {
                disposable.destroy();
            }
            catch (Exception e) {
                logger.warn("destroy resources failed: " + e.getMessage(), e);
            }
        }
        this.oneoffDisposables.clear();
        if (logger.isInfoEnabled()) {
            logger.info("Dubbo is completely destroyed");
        }
    }

    public void registerDisposable(Disposable disposable) {
        this.registerDisposable(disposable, false);
    }

    public void registerDisposable(Disposable disposable, boolean reused) {
        List<Disposable> disposables;
        List<Disposable> list = disposables = reused ? this.reusedDisposables : this.oneoffDisposables;
        if (!disposables.contains(disposable)) {
            disposables.add(disposable);
        }
    }

    public void removeDisposable(Disposable disposable) {
        this.reusedDisposables.remove(disposable);
        this.oneoffDisposables.remove(disposable);
    }
}

