/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common.extension;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.dubbo.common.extension.ExtensionAccessor;
import org.apache.dubbo.common.extension.ExtensionLoader;
import org.apache.dubbo.common.extension.ExtensionPostProcessor;
import org.apache.dubbo.common.extension.ExtensionScope;
import org.apache.dubbo.common.extension.SPI;
import org.apache.dubbo.rpc.model.ScopeModel;

public class ExtensionDirector
implements ExtensionAccessor {
    private final ConcurrentMap<Class<?>, ExtensionLoader<?>> extensionLoadersMap = new ConcurrentHashMap(64);
    private ExtensionDirector parent;
    private final ExtensionScope scope;
    private List<ExtensionPostProcessor> extensionPostProcessors = new ArrayList<ExtensionPostProcessor>();
    private ScopeModel scopeModel;

    public ExtensionDirector(ExtensionDirector parent, ExtensionScope scope, ScopeModel scopeModel) {
        this.parent = parent;
        this.scope = scope;
        this.scopeModel = scopeModel;
    }

    public void addExtensionPostProcessor(ExtensionPostProcessor processor) {
        if (!this.extensionPostProcessors.contains(processor)) {
            this.extensionPostProcessors.add(processor);
        }
    }

    public List<ExtensionPostProcessor> getExtensionPostProcessors() {
        return this.extensionPostProcessors;
    }

    @Override
    public ExtensionDirector getExtensionDirector() {
        return this;
    }

    @Override
    public <T> ExtensionLoader<T> getExtensionLoader(Class<T> type) {
        if (type == null) {
            throw new IllegalArgumentException("Extension type == null");
        }
        if (!type.isInterface()) {
            throw new IllegalArgumentException("Extension type (" + type + ") is not an interface!");
        }
        if (!ExtensionDirector.withExtensionAnnotation(type)) {
            throw new IllegalArgumentException("Extension type (" + type + ") is not an extension, because it is NOT annotated with @" + SPI.class.getSimpleName() + "!");
        }
        ExtensionLoader<T> loader = (ExtensionLoader<T>)this.extensionLoadersMap.get(type);
        SPI annotation = type.getAnnotation(SPI.class);
        ExtensionScope scope = annotation.scope();
        if (loader == null && scope == ExtensionScope.SELF) {
            loader = this.createExtensionLoader0(type);
        }
        if (loader == null && this.parent != null) {
            loader = this.parent.getExtensionLoader(type);
        }
        if (loader == null) {
            loader = this.createExtensionLoader(type);
        }
        return loader;
    }

    private <T> ExtensionLoader<T> createExtensionLoader(Class<T> type) {
        ExtensionLoader<T> loader = null;
        if (this.isScopeMatched(type)) {
            loader = this.createExtensionLoader0(type);
        }
        return loader;
    }

    private <T> ExtensionLoader<T> createExtensionLoader0(Class<T> type) {
        this.extensionLoadersMap.putIfAbsent(type, new ExtensionLoader(type, this, this.scopeModel));
        ExtensionLoader loader = (ExtensionLoader)this.extensionLoadersMap.get(type);
        return loader;
    }

    private boolean isScopeMatched(Class<?> type) {
        SPI defaultAnnotation = type.getAnnotation(SPI.class);
        return defaultAnnotation.scope().equals((Object)this.scope);
    }

    private static boolean withExtensionAnnotation(Class<?> type) {
        return type.isAnnotationPresent(SPI.class);
    }

    public ExtensionDirector getParent() {
        return this.parent;
    }

    public void removeAllCachedLoader() {
    }
}

