/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common.config;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.apache.dubbo.common.config.Configuration;
import org.apache.dubbo.common.config.ConfigurationUtils;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;

public class CompositeConfiguration
implements Configuration {
    private Logger logger = LoggerFactory.getLogger(CompositeConfiguration.class);
    private List<Configuration> configList = new LinkedList<Configuration>();
    private boolean dynamicIncluded;

    public CompositeConfiguration() {
    }

    public CompositeConfiguration(Configuration ... configurations) {
        this();
        if (configurations != null && configurations.length > 0) {
            Arrays.stream(configurations).filter(config -> !this.configList.contains(config)).forEach(this.configList::add);
        }
    }

    public void setDynamicIncluded(boolean dynamicIncluded) {
        this.dynamicIncluded = dynamicIncluded;
    }

    public boolean isDynamicIncluded() {
        return this.dynamicIncluded;
    }

    public void addConfiguration(Configuration configuration) {
        if (this.configList.contains(configuration)) {
            return;
        }
        this.configList.add(configuration);
    }

    public void addConfigurationFirst(Configuration configuration) {
        this.addConfiguration(0, configuration);
    }

    public void addConfiguration(int pos, Configuration configuration) {
        this.configList.add(pos, configuration);
    }

    @Override
    public Object getInternalProperty(String key) {
        for (Configuration config : this.configList) {
            try {
                Object value = config.getProperty(key);
                if (ConfigurationUtils.isEmptyValue(value)) continue;
                return value;
            }
            catch (Exception e) {
                this.logger.error("Error when trying to get value for key " + key + " from " + config + ", will continue to try the next one.");
            }
        }
        return null;
    }
}

