/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common.compiler.support;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javassist.CannotCompileException;
import javassist.ClassPath;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtField;
import javassist.CtNewConstructor;
import javassist.CtNewMethod;
import javassist.LoaderClassPath;
import javassist.NotFoundException;
import org.apache.dubbo.common.compiler.support.ClassUtils;

public class CtClassBuilder {
    private String className;
    private String superClassName = "java.lang.Object";
    private final List<String> imports = new ArrayList<String>();
    private final Map<String, String> fullNames = new HashMap<String, String>();
    private final List<String> ifaces = new ArrayList<String>();
    private final List<String> constructors = new ArrayList<String>();
    private final List<String> fields = new ArrayList<String>();
    private final List<String> methods = new ArrayList<String>();

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public String getSuperClassName() {
        return this.superClassName;
    }

    public void setSuperClassName(String superClassName) {
        this.superClassName = this.getQualifiedClassName(superClassName);
    }

    public List<String> getImports() {
        return this.imports;
    }

    public void addImports(String pkg) {
        int pi = pkg.lastIndexOf(46);
        if (pi > 0) {
            String pkgName = pkg.substring(0, pi);
            this.imports.add(pkgName);
            if (!pkg.endsWith(".*")) {
                this.fullNames.put(pkg.substring(pi + 1), pkg);
            }
        }
    }

    public List<String> getInterfaces() {
        return this.ifaces;
    }

    public void addInterface(String iface) {
        this.ifaces.add(this.getQualifiedClassName(iface));
    }

    public List<String> getConstructors() {
        return this.constructors;
    }

    public void addConstructor(String constructor) {
        this.constructors.add(constructor);
    }

    public List<String> getFields() {
        return this.fields;
    }

    public void addField(String field) {
        this.fields.add(field);
    }

    public List<String> getMethods() {
        return this.methods;
    }

    public void addMethod(String method) {
        this.methods.add(method);
    }

    protected String getQualifiedClassName(String className) {
        if (className.contains(".")) {
            return className;
        }
        if (this.fullNames.containsKey(className)) {
            return this.fullNames.get(className);
        }
        return ClassUtils.forName(this.imports.toArray(new String[0]), className).getName();
    }

    public CtClass build(ClassLoader classLoader) throws NotFoundException, CannotCompileException {
        ClassPool pool = new ClassPool(true);
        pool.insertClassPath((ClassPath)new LoaderClassPath(classLoader));
        CtClass ctClass = pool.makeClass(this.className, pool.get(this.superClassName));
        this.imports.forEach(arg_0 -> ((ClassPool)pool).importPackage(arg_0));
        for (String iface : this.ifaces) {
            ctClass.addInterface(pool.get(iface));
        }
        for (String constructor : this.constructors) {
            ctClass.addConstructor(CtNewConstructor.make((String)constructor, (CtClass)ctClass));
        }
        for (String field : this.fields) {
            ctClass.addField(CtField.make((String)field, (CtClass)ctClass));
        }
        for (String method : this.methods) {
            ctClass.addMethod(CtNewMethod.make((String)method, (CtClass)ctClass));
        }
        return ctClass;
    }
}

