/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common.bytecode;

import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.net.URL;
import javassist.ClassPath;

public class CustomizedLoaderClassPath
implements ClassPath {
    private WeakReference clref;

    public CustomizedLoaderClassPath(ClassLoader cl) {
        this.clref = new WeakReference<ClassLoader>(cl);
    }

    public String toString() {
        Object cl = null;
        if (this.clref != null) {
            cl = this.clref.get();
        }
        return cl == null ? "<null>" : cl.toString();
    }

    public InputStream openClassfile(String classname) {
        String cname = classname.replace('.', '/') + ".class";
        ClassLoader cl = (ClassLoader)this.clref.get();
        if (cl == null) {
            return null;
        }
        InputStream result = cl.getResourceAsStream(cname);
        if (result == null && cl != this.getClass().getClassLoader()) {
            return this.getClass().getClassLoader().getResourceAsStream(cname);
        }
        return result;
    }

    public URL find(String classname) {
        String cname = classname.replace('.', '/') + ".class";
        ClassLoader cl = (ClassLoader)this.clref.get();
        if (cl == null) {
            return null;
        }
        URL url = cl.getResource(cname);
        if (url == null && cl != this.getClass().getClassLoader()) {
            return this.getClass().getClassLoader().getResource(cname);
        }
        return url;
    }

    public void close() {
        this.clref = null;
    }
}

